/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.sftp.SFTPAttributesFinderFeature;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import java.io.IOException;
import java.util.EnumSet;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPException;
import org.apache.log4j.Logger;

public class SFTPListService
implements ListService {
    private static final Logger log = Logger.getLogger(SFTPListService.class);
    private final SFTPSession session;
    private final SFTPAttributesFinderFeature attributes;

    public SFTPListService(SFTPSession session) {
        this.session = session;
        this.attributes = new SFTPAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            RemoteDirectory handle = this.session.sftp().openDir(directory.getAbsolute());
            for (RemoteResourceInfo f : handle.scan(new RemoteResourceFilter(){

                public boolean accept(RemoteResourceInfo remoteResourceInfo) {
                    return true;
                }
            })) {
                Path file;
                PathAttributes attributes = this.attributes.convert(f.getAttributes());
                EnumSet<AbstractPath.Type> type = EnumSet.noneOf(AbstractPath.Type.class);
                if (f.getAttributes().getType().equals((Object)FileMode.Type.DIRECTORY)) {
                    type.add(AbstractPath.Type.directory);
                }
                if (f.getAttributes().getType().equals((Object)FileMode.Type.REGULAR)) {
                    type.add(AbstractPath.Type.file);
                }
                if (f.getAttributes().getType().equals((Object)FileMode.Type.SYMLINK)) {
                    type.add(AbstractPath.Type.symboliclink);
                }
                if (!this.post(file = new Path(directory, f.getName(), type, attributes))) continue;
                children.add((Referenceable)file);
                listener.chunk(directory, children);
            }
            handle.close();
            return children;
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    public ListService withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }

    protected boolean post(Path file) throws BackgroundException {
        if (file.isSymbolicLink()) {
            try {
                AbstractPath.Type type;
                String link = this.session.sftp().readLink(file.getAbsolute());
                Path target = link.startsWith(String.valueOf('/')) ? new Path(link, EnumSet.of(AbstractPath.Type.file)) : new Path(String.format("%s/%s", file.getParent().getAbsolute(), link), EnumSet.of(AbstractPath.Type.file));
                try {
                    type = this.session.sftp().stat(target.getAbsolute()).getType().equals((Object)FileMode.Type.DIRECTORY) ? AbstractPath.Type.directory : AbstractPath.Type.file;
                }
                catch (SFTPException e) {
                    BackgroundException reason = new SFTPExceptionMappingService().map((IOException)((Object)e));
                    if (reason instanceof NotfoundException) {
                        log.warn((Object)String.format("Cannot find symbolic link target of %s. %s", file, reason.toString()));
                    } else if (reason instanceof AccessDeniedException) {
                        log.warn((Object)String.format("Cannot find symbolic link target of %s. %s", file, reason.toString()));
                    } else if (reason instanceof InteroperabilityException) {
                        log.warn((Object)String.format("Cannot find symbolic link target of %s. %s", file, reason.toString()));
                    } else {
                        log.warn((Object)String.format("Unknown failure reading symbolic link target of %s. %s", file, reason.toString()));
                        throw reason;
                    }
                    type = AbstractPath.Type.file;
                }
                file.setType(EnumSet.of(AbstractPath.Type.symboliclink, type));
                target.setType(EnumSet.of(type));
                file.setSymlinkTarget(target);
            }
            catch (IOException e) {
                log.warn((Object)String.format("Failure to read symbolic link of %s. %s", file, e.getMessage()));
                return false;
            }
        }
        return true;
    }
}

