/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3MultipleDeleteFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.DeleteFolderRequest;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraDeleteFeature
extends S3MultipleDeleteFeature {
    private final PathContainerService containerService = new S3PathContainerService();
    private final SpectraSession session;

    public SpectraDeleteFeature(SpectraSession session) {
        super((S3Session)session, (S3MultipartService)new S3DisabledMultipartService());
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        try {
            ArrayList<Path> filtered = new ArrayList<Path>(files);
            Iterator<Path> iter = filtered.iterator();
            while (iter.hasNext()) {
                Path file = iter.next();
                if (file.isVolume() || !file.isDirectory()) continue;
                Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
                client.deleteFolder(new DeleteFolderRequest(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)));
                iter.remove();
            }
            super.delete(filtered, prompt, callback);
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        catch (SignatureException e) {
            throw new DefaultExceptionMappingService().map((Throwable)e);
        }
    }

    public boolean isRecursive() {
        return false;
    }
}

