/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class SharedFolderTransferOwnershipDetails {
    protected final String previousOwnerEmail;
    protected final String newOwnerEmail;

    public SharedFolderTransferOwnershipDetails(String newOwnerEmail, String previousOwnerEmail) {
        if (previousOwnerEmail != null && previousOwnerEmail.length() > 255) {
            throw new IllegalArgumentException("String 'previousOwnerEmail' is longer than 255");
        }
        this.previousOwnerEmail = previousOwnerEmail;
        if (newOwnerEmail == null) {
            throw new IllegalArgumentException("Required value for 'newOwnerEmail' is null");
        }
        if (newOwnerEmail.length() > 255) {
            throw new IllegalArgumentException("String 'newOwnerEmail' is longer than 255");
        }
        this.newOwnerEmail = newOwnerEmail;
    }

    public SharedFolderTransferOwnershipDetails(String newOwnerEmail) {
        this(newOwnerEmail, null);
    }

    public String getNewOwnerEmail() {
        return this.newOwnerEmail;
    }

    public String getPreviousOwnerEmail() {
        return this.previousOwnerEmail;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.previousOwnerEmail, this.newOwnerEmail});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFolderTransferOwnershipDetails other = (SharedFolderTransferOwnershipDetails)obj;
            return (this.newOwnerEmail == other.newOwnerEmail || this.newOwnerEmail.equals(other.newOwnerEmail)) && (this.previousOwnerEmail == other.previousOwnerEmail || this.previousOwnerEmail != null && this.previousOwnerEmail.equals(other.previousOwnerEmail));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedFolderTransferOwnershipDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedFolderTransferOwnershipDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("new_owner_email");
            StoneSerializers.string().serialize(value.newOwnerEmail, g);
            if (value.previousOwnerEmail != null) {
                g.writeFieldName("previous_owner_email");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.previousOwnerEmail, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedFolderTransferOwnershipDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_previousOwnerEmail;
            String f_newOwnerEmail;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_newOwnerEmail = null;
                f_previousOwnerEmail = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("new_owner_email".equals(field)) {
                        f_newOwnerEmail = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("previous_owner_email".equals(field)) {
                        f_previousOwnerEmail = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_newOwnerEmail == null) {
                    throw new JsonParseException(p, "Required field \"new_owner_email\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedFolderTransferOwnershipDetails value = new SharedFolderTransferOwnershipDetails(f_newOwnerEmail, f_previousOwnerEmail);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

