/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class FileRequestDeadline {
    protected final Date deadline;
    protected final String allowLateUploads;

    public FileRequestDeadline(Date deadline, String allowLateUploads) {
        this.deadline = LangUtil.truncateMillis(deadline);
        this.allowLateUploads = allowLateUploads;
    }

    public FileRequestDeadline() {
        this(null, null);
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public String getAllowLateUploads() {
        return this.allowLateUploads;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.deadline, this.allowLateUploads});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestDeadline other = (FileRequestDeadline)obj;
            return (this.deadline == other.deadline || this.deadline != null && this.deadline.equals(other.deadline)) && (this.allowLateUploads == other.allowLateUploads || this.allowLateUploads != null && this.allowLateUploads.equals(other.allowLateUploads));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestDeadline> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestDeadline value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.deadline != null) {
                g.writeFieldName("deadline");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.deadline, g);
            }
            if (value.allowLateUploads != null) {
                g.writeFieldName("allow_late_uploads");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.allowLateUploads, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequestDeadline deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_allowLateUploads;
            Date f_deadline;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_deadline = null;
                f_allowLateUploads = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("deadline".equals(field)) {
                        f_deadline = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("allow_late_uploads".equals(field)) {
                        f_allowLateUploads = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestDeadline value = new FileRequestDeadline(f_deadline, f_allowLateUploads);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected Date deadline = null;
        protected String allowLateUploads = null;

        protected Builder() {
        }

        public Builder withDeadline(Date deadline) {
            this.deadline = LangUtil.truncateMillis(deadline);
            return this;
        }

        public Builder withAllowLateUploads(String allowLateUploads) {
            this.allowLateUploads = allowLateUploads;
            return this;
        }

        public FileRequestDeadline build() {
            return new FileRequestDeadline(this.deadline, this.allowLateUploads);
        }
    }
}

