/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class FileRequestAddDeadlineDetails {
    protected final String fileRequestId;
    protected final String requestTitle;

    public FileRequestAddDeadlineDetails(String fileRequestId, String requestTitle) {
        if (fileRequestId != null) {
            if (fileRequestId.length() < 1) {
                throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
            }
        }
        this.fileRequestId = fileRequestId;
        this.requestTitle = requestTitle;
    }

    public FileRequestAddDeadlineDetails() {
        this(null, null);
    }

    public String getFileRequestId() {
        return this.fileRequestId;
    }

    public String getRequestTitle() {
        return this.requestTitle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileRequestId, this.requestTitle});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestAddDeadlineDetails other = (FileRequestAddDeadlineDetails)obj;
            return (this.fileRequestId == other.fileRequestId || this.fileRequestId != null && this.fileRequestId.equals(other.fileRequestId)) && (this.requestTitle == other.requestTitle || this.requestTitle != null && this.requestTitle.equals(other.requestTitle));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestAddDeadlineDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestAddDeadlineDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.fileRequestId != null) {
                g.writeFieldName("file_request_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileRequestId, g);
            }
            if (value.requestTitle != null) {
                g.writeFieldName("request_title");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.requestTitle, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequestAddDeadlineDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_requestTitle;
            String f_fileRequestId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileRequestId = null;
                f_requestTitle = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_request_id".equals(field)) {
                        f_fileRequestId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("request_title".equals(field)) {
                        f_requestTitle = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestAddDeadlineDetails value = new FileRequestAddDeadlineDetails(f_fileRequestId, f_requestTitle);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected String fileRequestId = null;
        protected String requestTitle = null;

        protected Builder() {
        }

        public Builder withFileRequestId(String fileRequestId) {
            if (fileRequestId != null) {
                if (fileRequestId.length() < 1) {
                    throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
                }
                if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                    throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
                }
            }
            this.fileRequestId = fileRequestId;
            return this;
        }

        public Builder withRequestTitle(String requestTitle) {
            this.requestTitle = requestTitle;
            return this;
        }

        public FileRequestAddDeadlineDetails build() {
            return new FileRequestAddDeadlineDetails(this.fileRequestId, this.requestTitle);
        }
    }
}

