/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.PendingUploadMode;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class CreateSharedLinkArg {
    protected final String path;
    protected final boolean shortUrl;
    protected final PendingUploadMode pendingUpload;

    public CreateSharedLinkArg(String path, boolean shortUrl, PendingUploadMode pendingUpload) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        this.path = path;
        this.shortUrl = shortUrl;
        this.pendingUpload = pendingUpload;
    }

    public CreateSharedLinkArg(String path) {
        this(path, false, null);
    }

    public String getPath() {
        return this.path;
    }

    public boolean getShortUrl() {
        return this.shortUrl;
    }

    public PendingUploadMode getPendingUpload() {
        return this.pendingUpload;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.shortUrl, this.pendingUpload});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            CreateSharedLinkArg other = (CreateSharedLinkArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && this.shortUrl == other.shortUrl && (this.pendingUpload == other.pendingUpload || this.pendingUpload != null && this.pendingUpload.equals((Object)other.pendingUpload));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<CreateSharedLinkArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(CreateSharedLinkArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("short_url");
            StoneSerializers.boolean_().serialize((Boolean)value.shortUrl, g);
            if (value.pendingUpload != null) {
                g.writeFieldName("pending_upload");
                StoneSerializers.nullable(PendingUploadMode.Serializer.INSTANCE).serialize(value.pendingUpload, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public CreateSharedLinkArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            PendingUploadMode f_pendingUpload;
            Boolean f_shortUrl;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_shortUrl = false;
                f_pendingUpload = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("short_url".equals(field)) {
                        f_shortUrl = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("pending_upload".equals(field)) {
                        f_pendingUpload = StoneSerializers.nullable(PendingUploadMode.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            CreateSharedLinkArg value = new CreateSharedLinkArg(f_path, f_shortUrl, f_pendingUpload);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String path;
        protected boolean shortUrl;
        protected PendingUploadMode pendingUpload;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            this.path = path;
            this.shortUrl = false;
            this.pendingUpload = null;
        }

        public Builder withShortUrl(Boolean shortUrl) {
            this.shortUrl = shortUrl != null ? shortUrl : false;
            return this;
        }

        public Builder withPendingUpload(PendingUploadMode pendingUpload) {
            this.pendingUpload = pendingUpload;
            return this;
        }

        public CreateSharedLinkArg build() {
            return new CreateSharedLinkArg(this.path, this.shortUrl, this.pendingUpload);
        }
    }
}

