/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.ListPaperDocsFilterBy;
import com.dropbox.core.v2.paper.ListPaperDocsSortBy;
import com.dropbox.core.v2.paper.ListPaperDocsSortOrder;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class ListPaperDocsArgs {
    protected final ListPaperDocsFilterBy filterBy;
    protected final ListPaperDocsSortBy sortBy;
    protected final ListPaperDocsSortOrder sortOrder;
    protected final int limit;

    public ListPaperDocsArgs(ListPaperDocsFilterBy filterBy, ListPaperDocsSortBy sortBy, ListPaperDocsSortOrder sortOrder, int limit) {
        if (filterBy == null) {
            throw new IllegalArgumentException("Required value for 'filterBy' is null");
        }
        this.filterBy = filterBy;
        if (sortBy == null) {
            throw new IllegalArgumentException("Required value for 'sortBy' is null");
        }
        this.sortBy = sortBy;
        if (sortOrder == null) {
            throw new IllegalArgumentException("Required value for 'sortOrder' is null");
        }
        this.sortOrder = sortOrder;
        if (limit < 1) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1");
        }
        if (limit > 1000) {
            throw new IllegalArgumentException("Number 'limit' is larger than 1000");
        }
        this.limit = limit;
    }

    public ListPaperDocsArgs() {
        this(ListPaperDocsFilterBy.DOCS_ACCESSED, ListPaperDocsSortBy.ACCESSED, ListPaperDocsSortOrder.ASCENDING, 1000);
    }

    public ListPaperDocsFilterBy getFilterBy() {
        return this.filterBy;
    }

    public ListPaperDocsSortBy getSortBy() {
        return this.sortBy;
    }

    public ListPaperDocsSortOrder getSortOrder() {
        return this.sortOrder;
    }

    public int getLimit() {
        return this.limit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.filterBy, this.sortBy, this.sortOrder, this.limit});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListPaperDocsArgs other = (ListPaperDocsArgs)obj;
            return !(this.filterBy != other.filterBy && !this.filterBy.equals((Object)other.filterBy) || this.sortBy != other.sortBy && !this.sortBy.equals((Object)other.sortBy) || this.sortOrder != other.sortOrder && !this.sortOrder.equals((Object)other.sortOrder) || this.limit != other.limit);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListPaperDocsArgs> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListPaperDocsArgs value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("filter_by");
            ListPaperDocsFilterBy.Serializer.INSTANCE.serialize(value.filterBy, g);
            g.writeFieldName("sort_by");
            ListPaperDocsSortBy.Serializer.INSTANCE.serialize(value.sortBy, g);
            g.writeFieldName("sort_order");
            ListPaperDocsSortOrder.Serializer.INSTANCE.serialize(value.sortOrder, g);
            g.writeFieldName("limit");
            StoneSerializers.int32().serialize((Integer)value.limit, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListPaperDocsArgs deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Integer f_limit;
            ListPaperDocsSortOrder f_sortOrder;
            ListPaperDocsSortBy f_sortBy;
            ListPaperDocsFilterBy f_filterBy;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_filterBy = ListPaperDocsFilterBy.DOCS_ACCESSED;
                f_sortBy = ListPaperDocsSortBy.ACCESSED;
                f_sortOrder = ListPaperDocsSortOrder.ASCENDING;
                f_limit = 1000;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("filter_by".equals(field)) {
                        f_filterBy = ListPaperDocsFilterBy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("sort_by".equals(field)) {
                        f_sortBy = ListPaperDocsSortBy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("sort_order".equals(field)) {
                        f_sortOrder = ListPaperDocsSortOrder.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.int32().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListPaperDocsArgs value = new ListPaperDocsArgs(f_filterBy, f_sortBy, f_sortOrder, f_limit);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected ListPaperDocsFilterBy filterBy = ListPaperDocsFilterBy.DOCS_ACCESSED;
        protected ListPaperDocsSortBy sortBy = ListPaperDocsSortBy.ACCESSED;
        protected ListPaperDocsSortOrder sortOrder = ListPaperDocsSortOrder.ASCENDING;
        protected int limit = 1000;

        protected Builder() {
        }

        public Builder withFilterBy(ListPaperDocsFilterBy filterBy) {
            this.filterBy = filterBy != null ? filterBy : ListPaperDocsFilterBy.DOCS_ACCESSED;
            return this;
        }

        public Builder withSortBy(ListPaperDocsSortBy sortBy) {
            this.sortBy = sortBy != null ? sortBy : ListPaperDocsSortBy.ACCESSED;
            return this;
        }

        public Builder withSortOrder(ListPaperDocsSortOrder sortOrder) {
            this.sortOrder = sortOrder != null ? sortOrder : ListPaperDocsSortOrder.ASCENDING;
            return this;
        }

        public Builder withLimit(Integer limit) {
            if (limit < 1) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1");
            }
            if (limit > 1000) {
                throw new IllegalArgumentException("Number 'limit' is larger than 1000");
            }
            this.limit = limit != null ? limit : 1000;
            return this;
        }

        public ListPaperDocsArgs build() {
            return new ListPaperDocsArgs(this.filterBy, this.sortBy, this.sortOrder, this.limit);
        }
    }
}

