/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.TemplateFilterBase;
import com.dropbox.core.v2.files.GetMetadataArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class AlphaGetMetadataArg
extends GetMetadataArg {
    protected final List<String> includePropertyTemplates;

    public AlphaGetMetadataArg(String path, boolean includeMediaInfo, boolean includeDeleted, boolean includeHasExplicitSharedMembers, TemplateFilterBase includePropertyGroups, List<String> includePropertyTemplates) {
        super(path, includeMediaInfo, includeDeleted, includeHasExplicitSharedMembers, includePropertyGroups);
        if (includePropertyTemplates != null) {
            for (String x : includePropertyTemplates) {
                if (x == null) {
                    throw new IllegalArgumentException("An item in list 'includePropertyTemplates' is null");
                }
                if (x.length() < 1) {
                    throw new IllegalArgumentException("Stringan item in list 'includePropertyTemplates' is shorter than 1");
                }
                if (Pattern.matches("(/|ptid:).*", x)) continue;
                throw new IllegalArgumentException("Stringan item in list 'includePropertyTemplates' does not match pattern");
            }
        }
        this.includePropertyTemplates = includePropertyTemplates;
    }

    public AlphaGetMetadataArg(String path) {
        this(path, false, false, false, null, null);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean getIncludeMediaInfo() {
        return this.includeMediaInfo;
    }

    @Override
    public boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    @Override
    public boolean getIncludeHasExplicitSharedMembers() {
        return this.includeHasExplicitSharedMembers;
    }

    @Override
    public TemplateFilterBase getIncludePropertyGroups() {
        return this.includePropertyGroups;
    }

    public List<String> getIncludePropertyTemplates() {
        return this.includePropertyTemplates;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.includePropertyTemplates});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            AlphaGetMetadataArg other = (AlphaGetMetadataArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && this.includeMediaInfo == other.includeMediaInfo && this.includeDeleted == other.includeDeleted && this.includeHasExplicitSharedMembers == other.includeHasExplicitSharedMembers && (this.includePropertyGroups == other.includePropertyGroups || this.includePropertyGroups != null && this.includePropertyGroups.equals(other.includePropertyGroups)) && (this.includePropertyTemplates == other.includePropertyTemplates || this.includePropertyTemplates != null && this.includePropertyTemplates.equals(other.includePropertyTemplates));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AlphaGetMetadataArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AlphaGetMetadataArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("include_media_info");
            StoneSerializers.boolean_().serialize((Boolean)value.includeMediaInfo, g);
            g.writeFieldName("include_deleted");
            StoneSerializers.boolean_().serialize((Boolean)value.includeDeleted, g);
            g.writeFieldName("include_has_explicit_shared_members");
            StoneSerializers.boolean_().serialize((Boolean)value.includeHasExplicitSharedMembers, g);
            if (value.includePropertyGroups != null) {
                g.writeFieldName("include_property_groups");
                StoneSerializers.nullable(TemplateFilterBase.Serializer.INSTANCE).serialize(value.includePropertyGroups, g);
            }
            if (value.includePropertyTemplates != null) {
                g.writeFieldName("include_property_templates");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.includePropertyTemplates, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public AlphaGetMetadataArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_includePropertyTemplates;
            TemplateFilterBase f_includePropertyGroups;
            Boolean f_includeHasExplicitSharedMembers;
            Boolean f_includeDeleted;
            Boolean f_includeMediaInfo;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_includeMediaInfo = false;
                f_includeDeleted = false;
                f_includeHasExplicitSharedMembers = false;
                f_includePropertyGroups = null;
                f_includePropertyTemplates = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("include_media_info".equals(field)) {
                        f_includeMediaInfo = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_deleted".equals(field)) {
                        f_includeDeleted = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_has_explicit_shared_members".equals(field)) {
                        f_includeHasExplicitSharedMembers = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("include_property_groups".equals(field)) {
                        f_includePropertyGroups = StoneSerializers.nullable(TemplateFilterBase.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("include_property_templates".equals(field)) {
                        f_includePropertyTemplates = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AlphaGetMetadataArg value = new AlphaGetMetadataArg(f_path, f_includeMediaInfo, f_includeDeleted, f_includeHasExplicitSharedMembers, f_includePropertyGroups, f_includePropertyTemplates);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends GetMetadataArg.Builder {
        protected List<String> includePropertyTemplates = null;

        protected Builder(String path) {
            super(path);
        }

        public Builder withIncludePropertyTemplates(List<String> includePropertyTemplates) {
            if (includePropertyTemplates != null) {
                for (String x : includePropertyTemplates) {
                    if (x == null) {
                        throw new IllegalArgumentException("An item in list 'includePropertyTemplates' is null");
                    }
                    if (x.length() < 1) {
                        throw new IllegalArgumentException("Stringan item in list 'includePropertyTemplates' is shorter than 1");
                    }
                    if (Pattern.matches("(/|ptid:).*", x)) continue;
                    throw new IllegalArgumentException("Stringan item in list 'includePropertyTemplates' does not match pattern");
                }
            }
            this.includePropertyTemplates = includePropertyTemplates;
            return this;
        }

        @Override
        public Builder withIncludeMediaInfo(Boolean includeMediaInfo) {
            super.withIncludeMediaInfo(includeMediaInfo);
            return this;
        }

        @Override
        public Builder withIncludeDeleted(Boolean includeDeleted) {
            super.withIncludeDeleted(includeDeleted);
            return this;
        }

        @Override
        public Builder withIncludeHasExplicitSharedMembers(Boolean includeHasExplicitSharedMembers) {
            super.withIncludeHasExplicitSharedMembers(includeHasExplicitSharedMembers);
            return this;
        }

        @Override
        public Builder withIncludePropertyGroups(TemplateFilterBase includePropertyGroups) {
            super.withIncludePropertyGroups(includePropertyGroups);
            return this;
        }

        @Override
        public AlphaGetMetadataArg build() {
            return new AlphaGetMetadataArg(this.path, this.includeMediaInfo, this.includeDeleted, this.includeHasExplicitSharedMembers, this.includePropertyGroups, this.includePropertyTemplates);
        }
    }
}

