/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.filerequests;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.filerequests.GracePeriod;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class FileRequestDeadline {
    protected final Date deadline;
    protected final GracePeriod allowLateUploads;

    public FileRequestDeadline(Date deadline, GracePeriod allowLateUploads) {
        if (deadline == null) {
            throw new IllegalArgumentException("Required value for 'deadline' is null");
        }
        this.deadline = LangUtil.truncateMillis(deadline);
        this.allowLateUploads = allowLateUploads;
    }

    public FileRequestDeadline(Date deadline) {
        this(deadline, null);
    }

    public Date getDeadline() {
        return this.deadline;
    }

    public GracePeriod getAllowLateUploads() {
        return this.allowLateUploads;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.deadline, this.allowLateUploads});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestDeadline other = (FileRequestDeadline)obj;
            return (this.deadline == other.deadline || this.deadline.equals(other.deadline)) && (this.allowLateUploads == other.allowLateUploads || this.allowLateUploads != null && this.allowLateUploads.equals((Object)other.allowLateUploads));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestDeadline> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestDeadline value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("deadline");
            StoneSerializers.timestamp().serialize(value.deadline, g);
            if (value.allowLateUploads != null) {
                g.writeFieldName("allow_late_uploads");
                StoneSerializers.nullable(GracePeriod.Serializer.INSTANCE).serialize(value.allowLateUploads, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequestDeadline deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            GracePeriod f_allowLateUploads;
            Date f_deadline;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_deadline = null;
                f_allowLateUploads = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("deadline".equals(field)) {
                        f_deadline = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("allow_late_uploads".equals(field)) {
                        f_allowLateUploads = StoneSerializers.nullable(GracePeriod.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_deadline == null) {
                    throw new JsonParseException(p, "Required field \"deadline\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestDeadline value = new FileRequestDeadline(f_deadline, f_allowLateUploads);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

