/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.PropertyGroup;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class PropertiesSearchMatch {
    protected final String id;
    protected final String path;
    protected final boolean isDeleted;
    protected final List<PropertyGroup> propertyGroups;

    public PropertiesSearchMatch(String id, String path, boolean isDeleted, List<PropertyGroup> propertyGroups) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        this.path = path;
        this.isDeleted = isDeleted;
        if (propertyGroups == null) {
            throw new IllegalArgumentException("Required value for 'propertyGroups' is null");
        }
        for (PropertyGroup x : propertyGroups) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
        }
        this.propertyGroups = propertyGroups;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getIsDeleted() {
        return this.isDeleted;
    }

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.path, this.isDeleted, this.propertyGroups});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PropertiesSearchMatch other = (PropertiesSearchMatch)obj;
            return !(this.id != other.id && !this.id.equals(other.id) || this.path != other.path && !this.path.equals(other.path) || this.isDeleted != other.isDeleted || this.propertyGroups != other.propertyGroups && !this.propertyGroups.equals(other.propertyGroups));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PropertiesSearchMatch> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PropertiesSearchMatch value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("is_deleted");
            StoneSerializers.boolean_().serialize((Boolean)value.isDeleted, g);
            g.writeFieldName("property_groups");
            StoneSerializers.list(PropertyGroup.Serializer.INSTANCE).serialize(value.propertyGroups, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PropertiesSearchMatch deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<PropertyGroup> f_propertyGroups;
            Boolean f_isDeleted;
            String f_path;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_path = null;
                f_isDeleted = null;
                f_propertyGroups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("is_deleted".equals(field)) {
                        f_isDeleted = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("property_groups".equals(field)) {
                        f_propertyGroups = StoneSerializers.list(PropertyGroup.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_isDeleted == null) {
                    throw new JsonParseException(p, "Required field \"is_deleted\" missing.");
                }
                if (f_propertyGroups == null) {
                    throw new JsonParseException(p, "Required field \"property_groups\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PropertiesSearchMatch value = new PropertiesSearchMatch(f_id, f_path, f_isDeleted, f_propertyGroups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

