/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.ClientServerNegotiationException;
import org.irods.jargon.core.exception.EncryptionException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.transfer.encrypt.EncryptionBuffer;
import org.irods.jargon.core.transfer.encrypt.ParallelEncryptionCipherWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AesCipherEncryptWrapper
extends ParallelEncryptionCipherWrapper {
    public static final Logger log = LoggerFactory.getLogger(AesCipherEncryptWrapper.class);
    public static byte[] ivPad = new byte[16];

    AesCipherEncryptWrapper(PipelineConfiguration pipelineConfiguration, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws ClientServerNegotiationException {
        super(pipelineConfiguration, negotiatedClientServerConfiguration);
        this.initImplementation();
    }

    private void initImplementation() {
        PipelineConfiguration pipelineConfiguration = this.getPipelineConfiguration();
        try {
            log.info("initCipher()");
            this.setCipher(Cipher.getInstance(pipelineConfiguration.getEncryptionAlgorithmEnum().getCypherKey()));
            SecretKey secretKey = this.getNegotiatedClientServerConfiguration().getSecretKey();
            this.getCipher().init(1, secretKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            log.error("error generating key for cipher", (Throwable)e);
            throw new JargonRuntimeException("cannot generate key for cipher", e);
        }
    }

    @Override
    protected EncryptionBuffer doEncrypt(byte[] input) throws EncryptionException {
        log.info("encrypt");
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        try {
            AlgorithmParameters params = this.getCipher().getParameters();
            byte[] mInitVec = params.getParameterSpec(IvParameterSpec.class).getIV();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(mInitVec);
            bos.write(ivPad);
            log.debug("encrypting");
            byte[] encrypted = this.getCipher().doFinal(input);
            log.debug("encrypted length:{}", (Object)encrypted.length);
            return new EncryptionBuffer(bos.toByteArray(), encrypted);
        }
        catch (IOException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException e) {
            log.error("encryption exception", (Throwable)e);
            throw new EncryptionException("encryption exception", e);
        }
    }
}

