/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.transfer.AbstractParallelFileTransferStrategy;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.ParallelGetTransferThread;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelGetFileTransferStrategy
extends AbstractParallelFileTransferStrategy {
    public static final Logger log = LoggerFactory.getLogger(ParallelGetFileTransferStrategy.class);

    public static ParallelGetFileTransferStrategy instance(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, FileRestartInfo fileRestartInfo, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws JargonException {
        return new ParallelGetFileTransferStrategy(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener, fileRestartInfo, negotiatedClientServerConfiguration);
    }

    private ParallelGetFileTransferStrategy(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, FileRestartInfo fileRestartInfo, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws JargonException {
        super(host, port, numberOfThreads, password, localFile, irodsAccessObjectFactory, transferLength, transferControlBlock, transferStatusCallbackListener, fileRestartInfo, negotiatedClientServerConfiguration);
        log.info("transfer options in transfer control block:{}", (Object)transferControlBlock.getTransferOptions());
        if (transferStatusCallbackListener == null) {
            log.info("null transferStatusCallbackListener");
        }
        if (transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && transferStatusCallbackListener != null) {
            log.info("will do intra-file status callbacks from transfer");
            this.setConnectionProgressStatusListener(DefaultIntraFileProgressCallbackListener.instance(TransferStatus.TransferType.GET, this.getTransferLength(), transferControlBlock, transferStatusCallbackListener));
        } else {
            log.info("transfer status callbacks will not be processed");
        }
    }

    @Override
    public void transfer() throws JargonException {
        log.info("initiating transfer for: {}", (Object)this.toString());
        ExecutorService executor = this.getIrodsAccessObjectFactory().getIrodsSession().getParallelTransferThreadPool();
        if (executor == null) {
            ExecutorService executorService = null;
            try {
                log.info("no pool available, transfer using single executor");
                executorService = Executors.newFixedThreadPool(this.numberOfThreads);
                this.transferWithExecutor(executorService);
            }
            finally {
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
        } else {
            log.info("transfer via executor");
            this.transferWithExecutor(executor);
        }
        log.info("transfer process has returned");
    }

    private void transferWithExecutor(ExecutorService executor) throws JargonException {
        ArrayList<ParallelGetTransferThread> parallelGetTransferThreads = new ArrayList<ParallelGetTransferThread>();
        try {
            for (int i = 0; i < this.numberOfThreads; ++i) {
                ParallelGetTransferThread parallelTransfer = ParallelGetTransferThread.instance(this, i);
                parallelGetTransferThreads.add(parallelTransfer);
            }
            log.info("invoking executor threads for get");
            log.info("invoking executor threads for put");
            List transferThreadStates = executor.invokeAll(parallelGetTransferThreads);
            for (Future transferState : transferThreadStates) {
                try {
                    transferState.get();
                }
                catch (ExecutionException e) {
                    throw new JargonException(e.getCause());
                }
            }
            log.info("executor completed");
        }
        catch (InterruptedException e) {
            log.error("interrupted exception in thread", (Throwable)e);
            throw new JargonException(e);
        }
        catch (Exception e) {
            log.error("an error occurred in a parallel get", (Throwable)e);
            throw new JargonException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ParallelGetFileTransferStrategy");
        sb.append("\n   host:");
        sb.append(this.getHost());
        sb.append("\n   port:");
        sb.append(this.getPort());
        sb.append("\n   numberOfThreads:");
        sb.append(this.getNumberOfThreads());
        sb.append("\n   localFile:");
        sb.append(this.localFile.getAbsolutePath());
        sb.append("\n   transferLength:");
        sb.append(this.transferLength);
        return sb.toString();
    }
}

