/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.ZoneAO;
import org.irods.jargon.core.pub.domain.Zone;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZoneAOImpl
extends IRODSGenericAO
implements ZoneAO {
    private static final Logger log = LoggerFactory.getLogger(ZoneAOImpl.class);

    protected ZoneAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public List<Zone> listZones() throws JargonException {
        IRODSQueryResultSet resultSet;
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_TYPE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_CONNECTION).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_COMMENT).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_MODIFY_TIME).addOrderByGenQueryField(RodsGenQueryEnum.COL_ZONE_NAME, GenQueryOrderByField.OrderByType.ASC);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(50);
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, "");
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        ArrayList<Zone> zones = new ArrayList<Zone>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            Zone zone = this.buildZoneForRow(row);
            zones.add(zone);
            log.info("got zone:{}", (Object)zone.toString());
        }
        return zones;
    }

    private Zone buildZoneForRow(IRODSQueryResultRow row) throws JargonException {
        Zone zone = new Zone();
        zone.setZoneId(row.getColumn(0));
        zone.setZoneName(row.getColumn(1));
        zone.setZoneType(row.getColumn(2));
        zone.setZoneConnection(row.getColumn(3));
        zone.setZoneComment(row.getColumn(4));
        zone.setZoneCreateTime(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(5)));
        zone.setZoneModifyTime(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(6)));
        String[] components = zone.getZoneConnection().split(":");
        if (components.length != 0) {
            if (components.length == 1) {
                zone.setHost(components[0]);
            } else if (components.length == 2) {
                zone.setHost(components[0]);
                try {
                    zone.setPort(Integer.parseInt(components[1]));
                }
                catch (NumberFormatException e) {
                    log.error("unable to parse connection string:{}", (Object)zone.getZoneConnection(), (Object)e);
                    throw new JargonException("error parsing zone connection string", e);
                }
            } else {
                throw new JargonException("unable to parse connection for host and port");
            }
        }
        return zone;
    }

    @Override
    public Zone getZoneByName(String zoneName) throws JargonException, DataNotFoundException {
        IRODSQueryResultSet resultSet;
        if (zoneName.equals("tempZone")) {
            Zone tempZone = new Zone();
            tempZone.setZoneName("tempZone");
            return tempZone;
        }
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        StringBuilder zoneQuery = new StringBuilder();
        char comma = ',';
        zoneQuery.append("select ");
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_ID.getName());
        zoneQuery.append(comma);
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_NAME.getName());
        zoneQuery.append(comma);
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_TYPE.getName());
        zoneQuery.append(comma);
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_CONNECTION.getName());
        zoneQuery.append(comma);
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_COMMENT.getName());
        zoneQuery.append(comma);
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_CREATE_TIME.getName());
        zoneQuery.append(comma);
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_MODIFY_TIME.getName());
        zoneQuery.append(" where ");
        zoneQuery.append(RodsGenQueryEnum.COL_ZONE_NAME.getName());
        zoneQuery.append(" = '");
        zoneQuery.append(zoneName);
        zoneQuery.append("'");
        String queryString = zoneQuery.toString();
        if (log.isInfoEnabled()) {
            log.info("zone query:" + this.toString());
        }
        IRODSGenQuery irodsQuery = IRODSGenQuery.instance(queryString, 500);
        try {
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error("query exception for:" + queryString, (Throwable)e);
            throw new JargonException("error in query");
        }
        if (resultSet.getResults().size() == 0) {
            StringBuilder message = new StringBuilder();
            message.append("zone not found for name:");
            message.append(zoneName);
            log.warn(message.toString());
            throw new DataNotFoundException(message.toString());
        }
        IRODSQueryResultRow row = resultSet.getResults().get(0);
        return this.buildZoneForRow(row);
    }

    @Override
    public List<String> listZoneNames() throws JargonException {
        IRODSQueryResultSet resultSet;
        log.info("listZoneNames()");
        IRODSGenQueryExecutorImpl irodsGenQueryExecutor = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_ZONE_NAME).addOrderByGenQueryField(RodsGenQueryEnum.COL_ZONE_NAME, GenQueryOrderByField.OrderByType.ASC);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(50);
            resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, "");
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query:", (Throwable)e);
            throw new JargonException("error in query", e);
        }
        ArrayList<String> zones = new ArrayList<String>();
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            String zone = row.getColumn(0);
            zones.add(zone);
            log.info("got zone:{}", (Object)zone);
        }
        return zones;
    }
}

