/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.checksum.ChecksumValue;
import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.CatNoAccessException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.FileIntegrityException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.InvalidInputParameterException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.exception.OperationNotSupportedForCollectionTypeException;
import org.irods.jargon.core.exception.OverwriteException;
import org.irods.jargon.core.exception.ResourceDoesNotExistException;
import org.irods.jargon.core.packinstr.DataObjCopyInp;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.ModAccessControlInp;
import org.irods.jargon.core.packinstr.ModAvuMetadataInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.protovalues.FilePermissionEnum;
import org.irods.jargon.core.protovalues.UserTypeEnum;
import org.irods.jargon.core.pub.BulkAVUOperationResponse;
import org.irods.jargon.core.pub.DataAOHelper;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.FileCatalogObjectAOImpl;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.pub.ResourceAOHelper;
import org.irods.jargon.core.pub.RuleProcessingAO;
import org.irods.jargon.core.pub.SpecificQueryAO;
import org.irods.jargon.core.pub.domain.AvuData;
import org.irods.jargon.core.pub.domain.DataObject;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.AVUQueryElement;
import org.irods.jargon.core.query.AVUQueryOperatorEnum;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.MetaDataAndDomainData;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.query.SpecificQuery;
import org.irods.jargon.core.query.SpecificQueryResultSet;
import org.irods.jargon.core.rule.IRODSRuleExecResult;
import org.irods.jargon.core.rule.IRODSRuleParameter;
import org.irods.jargon.core.transfer.AbstractRestartManager;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.FileRestartInfoIdentifier;
import org.irods.jargon.core.transfer.FileRestartManagementException;
import org.irods.jargon.core.transfer.GetTransferRestartProcessor;
import org.irods.jargon.core.transfer.ParallelGetFileTransferStrategy;
import org.irods.jargon.core.transfer.ParallelPutFileTransferStrategy;
import org.irods.jargon.core.transfer.PutTransferRestartProcessor;
import org.irods.jargon.core.transfer.RestartFailedException;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.irods.jargon.core.utils.CollectionAndPath;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.LocalFileUtils;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.irods.jargon.core.utils.RuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataObjectAOImpl
extends FileCatalogObjectAOImpl
implements DataObjectAO {
    private static final String NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH = "null or empty irodsCollectionAbsolutePath";
    private static final String ERROR_IN_PARALLEL_TRANSFER = "error in parallel transfer";
    private static final String NULL_LOCAL_FILE = "null local file";
    private static final String NULL_OR_EMPTY_ABSOLUTE_PATH = "null or empty absolutePath";
    public static final Logger log = LoggerFactory.getLogger(DataObjectAOImpl.class);
    private final transient DataAOHelper dataAOHelper = new DataAOHelper(this.getIRODSAccessObjectFactory(), this.getIRODSAccount());
    private final transient IRODSGenQueryExecutor irodsGenQueryExecutor;

    protected DataObjectAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(irodsAccount);
    }

    @Override
    public DataObject findByCollectionNameAndDataName(String collectionPath, String dataName) throws FileNotFoundException, JargonException {
        if (collectionPath == null) {
            throw new IllegalArgumentException("null collectionPath");
        }
        if (dataName == null || dataName.isEmpty()) {
            throw new IllegalArgumentException("dataName is null or empty");
        }
        MiscIRODSUtils.checkPathSizeForMax(collectionPath, dataName);
        log.info("find by collection path: {}", (Object)collectionPath);
        log.info(" data obj name: {}", (Object)dataName);
        String absPath = MiscIRODSUtils.buildAbsolutePathFromCollectionParentAndFileName(collectionPath, dataName);
        ObjStat objStat = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(absPath);
        return this.findGivenObjStat(objStat);
    }

    @Override
    public DataObject findByAbsolutePath(String absolutePath) throws FileNotFoundException, JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        log.info("findByAbsolutePath() with path:{}", (Object)absolutePath);
        CollectionAndPath collectionAndPath = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(absolutePath);
        return this.findByCollectionNameAndDataName(collectionAndPath.getCollectionParent(), collectionAndPath.getChildName());
    }

    @Override
    public DataObject findById(int id) throws FileNotFoundException, JargonException {
        log.info("findById() with id:{}", (Object)id);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        this.dataAOHelper.buildSelects(builder);
        builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_D_DATA_ID, QueryConditionOperators.EQUAL, String.valueOf(id));
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
        }
        catch (JargonQueryException e) {
            log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        if (resultSet.getFirstResult() == null) {
            log.error("no data object data found for id:{}", (Object)id);
            throw new FileNotFoundException("no data object data found in iCAT for id");
        }
        return DataAOHelper.buildDomainFromResultSetRow(resultSet.getFirstResult());
    }

    @Override
    public DataObject findGivenObjStat(ObjStat objStat) throws DataNotFoundException, JargonException {
        log.info("findGivenObjStat()");
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        log.info("objStat:{}", (Object)objStat);
        if (objStat.isSomeTypeOfCollection()) {
            log.error("objStat is not for a data object, wrong method called:{}", (Object)objStat);
            throw new JargonException("object is not a data object, it's a collection");
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String absPath = objStat.determineAbsolutePathBasedOnCollTypeInObjectStat();
        log.info("absPath for querying iCAT:{}", (Object)absPath);
        CollectionAndPath collectionAndPath = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(absPath);
        log.info("collection and path for data object:{}", (Object)collectionAndPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        this.dataAOHelper.buildSelects(builder);
        if (collectionAndPath.getCollectionParent() == null || collectionAndPath.getCollectionParent().isEmpty()) {
            log.info("ignoring collection path in query");
        } else {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, collectionAndPath.getCollectionParent());
        }
        builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, collectionAndPath.getChildName());
        IRODSQueryResultSet resultSet = null;
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
        }
        catch (JargonQueryException e) {
            log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for query", (Throwable)e);
            throw new JargonException("error in query for data object", e);
        }
        if (resultSet.getFirstResult() == null) {
            log.error("no data object data found for objStat:{}", (Object)objStat);
            throw new DataNotFoundException("no data object data found in iCAT for objStat");
        }
        DataObject dataObject = DataAOHelper.buildDomainFromResultSetRow(resultSet.getFirstResult());
        dataObject.setSpecColType(objStat.getSpecColType());
        dataObject.setObjectPath(objStat.getObjectPath());
        if (objStat.getSpecColType() == ObjStat.SpecColType.LINKED_COLL) {
            CollectionAndPath requestedCollectionAndPath = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(objStat.getAbsolutePath());
            dataObject.setCollectionName(requestedCollectionAndPath.getCollectionParent());
            dataObject.setDataName(requestedCollectionAndPath.getChildName());
        }
        log.info("returning: {}", (Object)dataObject.toString());
        return dataObject;
    }

    void putLocalDataObjectToIRODS(File localFile, IRODSFile irodsFileDestination, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, boolean ignoreChecks) throws JargonException {
        TransferControlBlock effectiveTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        this.putCommonProcessing(localFile, irodsFileDestination, ignoreChecks, effectiveTransferControlBlock, transferStatusCallbackListener);
    }

    void putLocalDataObjectToIRODS(File localFile, IRODSFile irodsFileDestination, boolean overwrite) throws DataNotFoundException, OverwriteException, JargonException {
        TransferControlBlock effectiveTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(null);
        if (overwrite) {
            effectiveTransferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.USE_FORCE);
        }
        this.putCommonProcessing(localFile, irodsFileDestination, false, effectiveTransferControlBlock, null);
    }

    void putLocalDataObjectToIRODSForClientSideRuleOperation(File localFile, IRODSFile irodsFileDestination, TransferControlBlock transferControlBlock) throws DataNotFoundException, OverwriteException, JargonException {
        TransferControlBlock effectiveTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        this.putCommonProcessing(localFile, irodsFileDestination, true, effectiveTransferControlBlock, null);
    }

    private void putCommonProcessing(File localFile, IRODSFile irodsFileDestination, boolean ignoreChecks, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws DataNotFoundException, JargonException, JargonRuntimeException, OverwriteException {
        log.info("putCommonProcessing()");
        if (!localFile.exists()) {
            log.error("put error, local file does not exist: {}", (Object)localFile.getAbsolutePath());
            throw new DataNotFoundException("put attempt where local file does not exist");
        }
        IRODSFile targetFile = this.dataAOHelper.checkTargetFileForPutOperation(localFile, irodsFileDestination, ignoreChecks, this.getIRODSFileFactory());
        long localFileLength = localFile.length();
        log.debug("localFileLength:{}", (Object)localFileLength);
        long startTime = System.currentTimeMillis();
        log.info("checking to see if this is a restart...");
        FileRestartInfo fileRestartInfo = this.retrieveRestartInfoIfAvailable(FileRestartInfo.RestartType.PUT, targetFile.getAbsolutePath());
        if (fileRestartInfo != null) {
            log.info("doing a restart of this transfer..");
            this.putRestartRetryTillMaxLoop(transferControlBlock, targetFile, fileRestartInfo, transferStatusCallbackListener);
            return;
        }
        boolean force = transferControlBlock.getTransferOptions().getForceOption() == TransferOptions.ForceOption.USE_FORCE;
        if (!force) {
            if (!ignoreChecks && targetFile.exists()) {
                if (transferControlBlock.getTransferOptions() == null) {
                    throw new JargonRuntimeException("transfer control block does not have a transfer options set");
                }
                OverwriteResponse overwriteResponse = this.evaluateOverwrite(localFile, transferControlBlock, transferStatusCallbackListener, transferControlBlock.getTransferOptions(), (File)((Object)targetFile));
                if (overwriteResponse == OverwriteResponse.SKIP) {
                    log.info("skipping due to overwrite status");
                    return;
                }
                if (overwriteResponse == OverwriteResponse.PROCEED_WITH_FORCE) {
                    force = true;
                }
            } else if (transferControlBlock.getTransferOptions().getForceOption() == TransferOptions.ForceOption.USE_FORCE) {
                force = true;
            }
        }
        if (localFileLength < 0x2000000L) {
            log.info("processing transfer as normal, length below max");
            try {
                this.dataAOHelper.processNormalPutTransfer(localFile, force, targetFile, this.getIRODSProtocol(), transferControlBlock, transferStatusCallbackListener);
            }
            catch (FileNotFoundException e) {
                log.error("iRODS file missing in put operation:{}", (Object)targetFile.getAbsolutePath());
                throw new DataNotFoundException("irodsFile not found", e);
            }
            catch (java.io.FileNotFoundException e) {
                throw new DataNotFoundException("local file not found in put to irods", e);
            }
        }
        log.info("processing as a parallel transfer, length above max");
        try {
            this.processAsAParallelPutOperationIfMoreThanZeroThreads(localFile, targetFile, force, transferControlBlock, transferStatusCallbackListener);
        }
        catch (FileRestartManagementException e) {
            log.error("transfer and restart failed", (Throwable)e);
            throw e;
        }
        catch (JargonException je) {
            log.info("attempting a restart after exception", (Throwable)je);
            fileRestartInfo = this.retrieveRestartInfoIfAvailable(FileRestartInfo.RestartType.PUT, irodsFileDestination.getAbsolutePath());
            if (fileRestartInfo == null) {
                log.info("no restart info, rethrow exception", (Throwable)je);
                throw je;
            }
            log.info("carrying out restart process..");
            this.putRestartRetryTillMaxLoop(transferControlBlock, targetFile, fileRestartInfo, transferStatusCallbackListener);
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        log.info(">>>>>>>>>>>>>>transfer complete in:{} millis", (Object)duration);
        if (transferStatusCallbackListener != null && transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && !transferControlBlock.isCancelled()) {
            ConnectionProgressStatusListener intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingTransferOptions(TransferStatus.TransferType.PUT, localFileLength, transferControlBlock, transferStatusCallbackListener, transferControlBlock.getTransferOptions());
            ConnectionProgressStatus status = ConnectionProgressStatus.instanceForSend(localFileLength);
            intraFileStatusListener.finalConnectionProgressStatusCallback(status);
        }
    }

    private void putRestartRetryTillMaxLoop(TransferControlBlock transferControlBlock, IRODSFile targetFile, FileRestartInfo fileRestartInfo, TransferStatusCallbackListener transferStatusCallbackListener) throws JargonException, RestartFailedException, FileRestartManagementException {
        log.info("putRestartRetryTillMaxLoop()");
        FileRestartInfo myFileRestartInfo = this.retrieveRestartInfoIfAvailable(fileRestartInfo.getRestartType(), fileRestartInfo.getIrodsAbsolutePath());
        int offsetInMillis = 10000;
        while (true) {
            log.info("increment and loop to do restart, loop will exit with exception or successful restart");
            try {
                Thread.sleep(offsetInMillis);
            }
            catch (InterruptedException e) {
                return;
            }
            offsetInMillis *= 2;
            try {
                myFileRestartInfo = this.getRestartManager().incrementRestartAttempts(myFileRestartInfo);
                if (myFileRestartInfo == null) {
                    log.info("restart info no longer available, complete the operation");
                    break;
                }
                this.putRestartProcess(transferControlBlock, targetFile, myFileRestartInfo, transferStatusCallbackListener);
                continue;
            }
            catch (RestartFailedException rfe) {
                log.error("restart failed, rethrow:{}", (Object)myFileRestartInfo, (Object)rfe);
                throw rfe;
            }
            catch (FileRestartManagementException frm) {
                log.error("restart failed, rethrow:{}", (Object)myFileRestartInfo, (Object)frm);
                throw frm;
            }
            catch (JargonException e) {
                log.error("restart failed with a JargonException, will loop again:{}", (Object)myFileRestartInfo, (Object)e);
                continue;
            }
            catch (Throwable t) {
                log.error("unanticipated exception in retry will loop again:{}", (Object)myFileRestartInfo, (Object)t);
                continue;
            }
            break;
        }
    }

    private void putRestartProcess(TransferControlBlock transferControlBlock, IRODSFile targetFile, FileRestartInfo fileRestartInfo, TransferStatusCallbackListener transferStatusCallbackListener) throws RestartFailedException, FileRestartManagementException, JargonException {
        log.info("have file restart info:{}", (Object)fileRestartInfo);
        PutTransferRestartProcessor putTransferRestartProcessor = new PutTransferRestartProcessor(this.getIRODSAccessObjectFactory(), this.getIRODSAccount(), this.getIRODSSession().getRestartManager(), transferStatusCallbackListener, transferControlBlock);
        putTransferRestartProcessor.restartIfNecessary(targetFile.getAbsolutePath());
    }

    private void processAsAParallelPutOperationIfMoreThanZeroThreads(File localFile, IRODSFile targetFile, boolean overwrite, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws DataNotFoundException, OverwriteException, JargonException {
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        if (targetFile == null) {
            throw new IllegalArgumentException("null target file");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        TransferOptions myTransferOptions = new TransferOptions(transferControlBlock.getTransferOptions());
        if (!myTransferOptions.isUseParallelTransfer()) {
            log.info("no parallel transfer set in transferOptions");
            myTransferOptions.setMaxThreads(-1);
        }
        ConnectionProgressStatusListener intraFileStatusListener = null;
        boolean execFlag = false;
        if (localFile.canExecute()) {
            log.info("file is executable");
            execFlag = true;
        }
        DataObjInp dataObjInp = DataObjInp.instanceForParallelPut(targetFile.getAbsolutePath(), localFile.length(), targetFile.getResource(), overwrite, myTransferOptions, execFlag);
        try {
            if (myTransferOptions.isComputeAndVerifyChecksumAfterTransfer() || myTransferOptions.isComputeChecksumAfterTransfer()) {
                log.info("before generating parallel transfer threads, computing a checksum on the file at:{}", (Object)localFile.getAbsolutePath());
                ChecksumValue localFileChecksum = this.dataAOHelper.computeLocalFileChecksum(localFile, null);
                log.info("local file checksum is:{}", (Object)localFileChecksum);
                dataObjInp.setFileChecksumValue(localFileChecksum);
            }
            Tag responseToInitialCallForPut = this.getIRODSProtocol().irodsFunction(dataObjInp);
            int numberOfThreads = responseToInitialCallForPut.getTag("numThreads").getIntValue();
            int fd = responseToInitialCallForPut.getTag("l1descInx").getIntValue();
            log.debug("fd for file:{}", (Object)fd);
            if (numberOfThreads < 0) {
                throw new JargonException("numberOfThreads returned from iRODS is < 0, some error occurred");
            }
            if (numberOfThreads > 0) {
                this.parallelPutTransfer(localFile, targetFile.getAbsolutePath(), responseToInitialCallForPut, numberOfThreads, localFile.length(), transferControlBlock, transferStatusCallbackListener);
            } else {
                log.info("parallel operation deferred by server sending 0 threads back in PortalOperOut, revert to single thread transfer");
                if (transferStatusCallbackListener != null || myTransferOptions.isIntraFileStatusCallbacks()) {
                    intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingTransferOptions(TransferStatus.TransferType.PUT, localFile.length(), transferControlBlock, transferStatusCallbackListener, transferControlBlock.getTransferOptions());
                }
                this.dataAOHelper.putReadWriteLoop(localFile, overwrite, targetFile, fd, this.getIRODSProtocol(), transferControlBlock, intraFileStatusListener);
            }
        }
        catch (DataNotFoundException dnf) {
            log.warn("send of put returned no data found from irods, currently is ignored and null is returned from put operation");
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-312000") > -1) {
                log.error("attempted put of file that exists in irods without overwrite");
                throw new JargonException("attempted put of a file that already exists in IRODS, overwrite was not set to true", je);
            }
            throw je;
        }
        catch (Throwable e) {
            log.error(ERROR_IN_PARALLEL_TRANSFER, e);
            throw new JargonException(ERROR_IN_PARALLEL_TRANSFER, e);
        }
    }

    private void parallelPutTransfer(File localFile, String irodsAbsolutePath, Tag responseToInitialCallForPut, int numberOfThreads, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws DataNotFoundException, OverwriteException, JargonException {
        FileRestartInfo fileRestartInfo = this.retrieveOrCreateRestartInfoIfConfigured(FileRestartInfo.RestartType.PUT, irodsAbsolutePath, localFile.getAbsolutePath(), numberOfThreads, transferLength);
        log.info("transfer will be done using {} threads", (Object)numberOfThreads);
        String host = responseToInitialCallForPut.getTag("PortList_PI").getTag("hostAddr").getStringValue();
        int port = responseToInitialCallForPut.getTag("PortList_PI").getTag("portNum").getIntValue();
        int pass = responseToInitialCallForPut.getTag("PortList_PI").getTag("cookie").getIntValue();
        ParallelPutFileTransferStrategy parallelPutFileStrategy = ParallelPutFileTransferStrategy.instance(host, port, numberOfThreads, pass, localFile, this.getIRODSAccessObjectFactory(), transferLength, transferControlBlock, transferStatusCallbackListener, fileRestartInfo, this.getIRODSProtocol().getStartupResponseData().getNegotiatedClientServerConfiguration());
        log.info("getting ready to initiate parallel file transfer strategy:{}", (Object)parallelPutFileStrategy);
        try {
            parallelPutFileStrategy.transfer();
            log.info("transfer process is complete");
            int statusForComplete = responseToInitialCallForPut.getTag("l1descInx").getIntValue();
            log.debug("status for complete:{}", (Object)statusForComplete);
            log.info("sending operation complete at termination of parallel transfer");
            this.getIRODSProtocol().operationComplete(statusForComplete);
            if (fileRestartInfo != null) {
                log.info("delete old restart stuff");
                this.getIRODSSession().getRestartManager().deleteRestart(fileRestartInfo.identifierFromThisInfo());
            }
        }
        catch (Throwable e) {
            log.error("error in parallel transfers, the main connection will be abandoned", e);
            this.getIRODSAccessObjectFactory().getIrodsSession().discardSessionForErrors(this.getIRODSAccount());
            throw new JargonException(e);
        }
    }

    void getDataObjectFromIrods(IRODSFile irodsFileToGet, File localFileToHoldData, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws OverwriteException, DataNotFoundException, JargonException {
        File localFile;
        log.info("getDataObjectFromIrods()");
        if (localFileToHoldData == null) {
            throw new IllegalArgumentException(NULL_LOCAL_FILE);
        }
        if (irodsFileToGet == null) {
            throw new IllegalArgumentException("nulll destination file");
        }
        log.info("irodsFileToGet:{}", (Object)irodsFileToGet.getAbsolutePath());
        log.info("localFileToHoldData:{}", (Object)localFileToHoldData.getAbsolutePath());
        TransferControlBlock operativeTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock);
        TransferOptions thisFileTransferOptions = new TransferOptions(operativeTransferControlBlock.getTransferOptions());
        if (!thisFileTransferOptions.isUseParallelTransfer()) {
            log.info("no parallel transfer set in transferOptions");
            thisFileTransferOptions.setMaxThreads(-1);
        }
        if (localFileToHoldData.isDirectory()) {
            log.info("a get to a directory, just use the source file name and accept the directory as a target");
            StringBuilder sb = new StringBuilder();
            sb.append(localFileToHoldData.getAbsolutePath());
            sb.append("/");
            sb.append(irodsFileToGet.getName());
            log.info("target file name will be:{}", (Object)sb.toString());
            localFile = new File(sb.toString());
        } else {
            localFile = localFileToHoldData;
        }
        log.info("checking to see if this is a restart...");
        FileRestartInfo fileRestartInfo = this.retrieveRestartInfoIfAvailable(FileRestartInfo.RestartType.GET, irodsFileToGet.getAbsolutePath());
        if (fileRestartInfo != null) {
            log.info("restart processing for get..");
            this.getRestartRetryTillMaxLoop(operativeTransferControlBlock, irodsFileToGet, fileRestartInfo, transferStatusCallbackListener);
        } else {
            OverwriteResponse overwriteResponse;
            if (operativeTransferControlBlock.getTransferOptions().getForceOption() != TransferOptions.ForceOption.USE_FORCE && (overwriteResponse = this.evaluateOverwrite((File)((Object)irodsFileToGet), operativeTransferControlBlock, transferStatusCallbackListener, thisFileTransferOptions, localFile)) == OverwriteResponse.SKIP) {
                log.info("skipping due to overwrite status");
                return;
            }
            long irodsFileLength = irodsFileToGet.length();
            log.info("testing file length to set parallel transfer options");
            if (irodsFileLength > 0x2000000L) {
                if (!thisFileTransferOptions.isUseParallelTransfer()) {
                    log.info("no parallel transfer set in transferOptions");
                    thisFileTransferOptions.setMaxThreads(-1);
                }
            } else {
                thisFileTransferOptions.setMaxThreads(0);
            }
            log.info("target local file: {}", (Object)localFile.getAbsolutePath());
            log.info("from source file: {}", (Object)irodsFileToGet.getAbsolutePath());
            DataObjInp dataObjInp = irodsFileToGet.getResource().isEmpty() ? DataObjInp.instanceForGet(irodsFileToGet.getAbsolutePath(), irodsFileLength, thisFileTransferOptions) : DataObjInp.instanceForGetSpecifyingResource(irodsFileToGet.getAbsolutePath(), irodsFileToGet.getResource(), "", thisFileTransferOptions);
            this.processGetAfterResourceDetermined(irodsFileToGet, localFile, dataObjInp, thisFileTransferOptions, irodsFileLength, operativeTransferControlBlock, transferStatusCallbackListener, false);
        }
    }

    private void getRestartRetryTillMaxLoop(TransferControlBlock transferControlBlock, IRODSFile irodsFileToGet, FileRestartInfo fileRestartInfo, TransferStatusCallbackListener transferStatusCallbackListener) throws FileRestartManagementException {
        log.info("getRestartRetryTillMaxLoop()");
        FileRestartInfo myFileRestartInfo = this.retrieveRestartInfoIfAvailable(fileRestartInfo.getRestartType(), fileRestartInfo.getIrodsAbsolutePath());
        int offsetInMillis = 10000;
        while (true) {
            log.info("increment and loop to do restart, loop will exit with exception or successful restart");
            try {
                Thread.sleep(offsetInMillis);
            }
            catch (InterruptedException e) {
                return;
            }
            offsetInMillis *= 2;
            log.info("increment and loop to do restart, loop will exit with exception or successful restart");
            try {
                myFileRestartInfo = this.getRestartManager().incrementRestartAttempts(myFileRestartInfo);
                if (myFileRestartInfo == null) {
                    log.info("restart info no longer available, complete the operation");
                    break;
                }
                this.getRestartProcess(transferControlBlock, irodsFileToGet, myFileRestartInfo, transferStatusCallbackListener);
                log.info("restart done");
                continue;
            }
            catch (RestartFailedException rfe) {
                log.error("restart failed, rethrow:{}", (Object)myFileRestartInfo, (Object)rfe);
                throw rfe;
            }
            catch (FileRestartManagementException frm) {
                log.error("restart failed, rethrow:{}", (Object)myFileRestartInfo, (Object)frm);
                throw frm;
            }
            catch (JargonException e) {
                log.error("restart failed with a JargonException, will loop again:{}", (Object)myFileRestartInfo, (Object)e);
                continue;
            }
            catch (Throwable t) {
                log.error("unanticipated exception in retry will loop again:{}", (Object)myFileRestartInfo, (Object)t);
                continue;
            }
            break;
        }
    }

    private void getRestartProcess(TransferControlBlock transferControlBlock, IRODSFile irodsFileToGet, FileRestartInfo myFileRestartInfo, TransferStatusCallbackListener transferStatusCallbackListener) throws RestartFailedException, FileRestartManagementException, JargonException {
        log.info("have file restart info:{}", (Object)myFileRestartInfo);
        GetTransferRestartProcessor getTransferRestartProcessor = new GetTransferRestartProcessor(this.getIRODSAccessObjectFactory(), this.getIRODSAccount(), this.getIRODSSession().getRestartManager(), transferStatusCallbackListener, transferControlBlock);
        getTransferRestartProcessor.restartIfNecessary(irodsFileToGet.getAbsolutePath());
    }

    private OverwriteResponse evaluateOverwrite(File sourceFile, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, TransferOptions thisFileTransferOptions, File targetFile) throws OverwriteException {
        OverwriteResponse overwriteResponse = OverwriteResponse.PROCEED_WITH_NO_FORCE;
        if (targetFile.exists()) {
            if (targetFile instanceof IRODSFile) {
                try {
                    if (this.getObjectStatForAbsolutePath(targetFile.getAbsolutePath()).getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
                        log.info("always use force for mounted collections, see comments for Bug 1606");
                        overwriteResponse = OverwriteResponse.PROCEED_WITH_FORCE;
                        return overwriteResponse;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (JargonException e) {
                    log.error("jargon error checking overwrite", (Throwable)e);
                    throw new JargonRuntimeException("runtime exception in overwrite handling process", e);
                }
            }
            log.info("target file exists, check if overwrite allowed, file is:{}", (Object)targetFile.getAbsolutePath());
            if (thisFileTransferOptions.getForceOption() == TransferOptions.ForceOption.NO_FORCE) {
                throw new OverwriteException("attempt to overwrite file, target file already exists and no force option specified");
            }
            if (thisFileTransferOptions.getForceOption() == TransferOptions.ForceOption.USE_FORCE) {
                log.info("force specified, do the overwrite");
                overwriteResponse = OverwriteResponse.PROCEED_WITH_FORCE;
            } else if (thisFileTransferOptions.getForceOption() == TransferOptions.ForceOption.ASK_CALLBACK_LISTENER) {
                if (transferStatusCallbackListener == null) {
                    throw new OverwriteException("attempt to overwrite file, target file already exists and no callback listener provided to ask");
                }
                TransferStatusCallbackListener.CallbackResponse callbackResponse = transferStatusCallbackListener.transferAsksWhetherToForceOperation(sourceFile.getAbsolutePath(), false);
                switch (callbackResponse) {
                    case CANCEL: {
                        log.info("transfer cancelleld");
                        overwriteResponse = OverwriteResponse.SKIP;
                        break;
                    }
                    case YES_THIS_FILE: {
                        overwriteResponse = OverwriteResponse.PROCEED_WITH_FORCE;
                        break;
                    }
                    case NO_THIS_FILE: {
                        overwriteResponse = OverwriteResponse.SKIP;
                        break;
                    }
                    case YES_FOR_ALL: {
                        if (transferControlBlock == null) {
                            log.warn("attempting to process a 'yes for all' response, but no transfer control block to maintain this, it will be ignored for subsequent transfers");
                        } else {
                            transferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.USE_FORCE);
                        }
                        overwriteResponse = OverwriteResponse.PROCEED_WITH_FORCE;
                        break;
                    }
                    case NO_FOR_ALL: {
                        if (transferControlBlock == null) {
                            log.warn("attempting to process a 'no for all' response, but no transfer control block to maintain this, it will be ignored for subsequent transfers");
                            overwriteResponse = OverwriteResponse.SKIP;
                            break;
                        }
                        transferControlBlock.getTransferOptions().setForceOption(TransferOptions.ForceOption.NO_FORCE);
                        overwriteResponse = OverwriteResponse.SKIP;
                        break;
                    }
                    default: {
                        log.error("unknown callback response:{}", (Object)callbackResponse);
                    }
                }
            }
        }
        return overwriteResponse;
    }

    int irodsDataObjectGetOperationForClientSideAction(IRODSFile irodsFileToGet, File localFileToHoldData, TransferOptions transferOptions) throws OverwriteException, DataNotFoundException, JargonException {
        if (localFileToHoldData == null) {
            throw new IllegalArgumentException(NULL_LOCAL_FILE);
        }
        if (irodsFileToGet == null) {
            throw new IllegalArgumentException("nulll destination file");
        }
        this.evaluateOverwrite((File)((Object)irodsFileToGet), null, null, this.buildDefaultTransferOptionsIfNotSpecified(transferOptions), localFileToHoldData);
        log.info("target local file: {}", (Object)localFileToHoldData.getAbsolutePath());
        log.info("from source file: {}", (Object)irodsFileToGet.getAbsolutePath());
        TransferOptions myTransferOptions = this.buildDefaultTransferOptionsIfNotSpecified(transferOptions);
        DataObjInp dataObjInp = DataObjInp.instanceForGetSpecifyingResource(irodsFileToGet.getAbsolutePath(), irodsFileToGet.getResource(), localFileToHoldData.getAbsolutePath(), myTransferOptions);
        TransferControlBlock transferControlBlock = DefaultTransferControlBlock.instance();
        transferControlBlock.setTransferOptions(myTransferOptions);
        return this.processGetAfterResourceDetermined(irodsFileToGet, localFileToHoldData, dataObjInp, myTransferOptions, 0L, transferControlBlock, null, true);
    }

    /*
     * Unable to fully structure code
     */
    private int processGetAfterResourceDetermined(IRODSFile irodsFileToGet, File localFileToHoldData, DataObjInp dataObjInp, TransferOptions thisFileTransferOptions, long irodsFileLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, boolean clientSideAction) throws OverwriteException, DataNotFoundException, JargonException {
        DataObjectAOImpl.log.info("process get after resource determined");
        if (transferStatusCallbackListener == null) {
            DataObjectAOImpl.log.info("no transfer status callback listener provided");
        }
        if (thisFileTransferOptions == null) {
            throw new IllegalArgumentException("null transfer options");
        }
        LocalFileUtils.createLocalFileIfNotExists(localFileToHoldData);
        try {
            message = this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (CatNoAccessException e) {
            DataObjectAOImpl.log.error("no access exception wrapped as DataNotFoundException for consistency with API", (Throwable)e);
            throw new FileNotFoundException(e);
        }
        if (message == null) {
            DataObjectAOImpl.log.warn("irods file does not exist, null was returned from the get, return DataNotFoundException for iRODS file: {}", (Object)irodsFileToGet.getAbsolutePath());
            throw new FileNotFoundException("irods file not found during get operation:" + irodsFileToGet.getAbsolutePath());
        }
        temp = message.getTag("MsgHeader_PI");
        if (temp == null) {
            DataObjectAOImpl.log.info("create a new file, length is zero");
            return 0;
        }
        if ((temp = temp.getTag("bsLen")) == null) {
            DataObjectAOImpl.log.info("no size returned, return from get with no update done");
            return 0;
        }
        lengthFromIrodsResponse = temp.getLongValue();
        DataObjectAOImpl.log.info("transfer length is:", (Object)lengthFromIrodsResponse);
        temp = message.getTag("l1descInx");
        l1descInx = 0;
        if (temp != null) {
            l1descInx = temp.getIntValue();
        }
        DataObjectAOImpl.log.debug("l1descInx value is:{}", (Object)l1descInx);
        try {
            if (lengthFromIrodsResponse == 0L) {
                try {
                    this.checkNbrThreadsAndProcessAsParallelIfMoreThanZeroThreads(irodsFileToGet, localFileToHoldData, thisFileTransferOptions, message, lengthFromIrodsResponse, irodsFileLength, transferControlBlock, transferStatusCallbackListener, clientSideAction);
                    if (!this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods4.1.6")) {
                        this.getIRODSProtocol().operationComplete(l1descInx);
                    }
                    if ((fileRestartInfo = this.retrieveRestartInfoIfAvailable(FileRestartInfo.RestartType.GET, irodsFileToGet.getAbsolutePath())) == null) ** GOTO lbl53
                    DataObjectAOImpl.log.info("delete old restart stuff");
                    this.getIRODSSession().getRestartManager().deleteRestart(fileRestartInfo.identifierFromThisInfo());
                }
                catch (FileRestartManagementException e) {
                    DataObjectAOImpl.log.error("transfer and restart failed", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    DataObjectAOImpl.log.info("attempting a restart after exception", e);
                    fileRestartInfo = this.retrieveRestartInfoIfAvailable(FileRestartInfo.RestartType.GET, irodsFileToGet.getAbsolutePath());
                    if (fileRestartInfo == null) {
                        DataObjectAOImpl.log.info("no restart info available, rethrow the exception");
                        throw e;
                    }
                    DataObjectAOImpl.log.info("carrying out restart process..");
                    this.getRestartRetryTillMaxLoop(transferControlBlock, irodsFileToGet, fileRestartInfo, transferStatusCallbackListener);
                }
            } else {
                this.dataAOHelper.processNormalGetTransfer(localFileToHoldData, lengthFromIrodsResponse, this.getIRODSProtocol(), thisFileTransferOptions, transferControlBlock, transferStatusCallbackListener);
            }
lbl53:
            // 4 sources

            if (transferStatusCallbackListener != null && transferControlBlock.getTransferOptions().isIntraFileStatusCallbacks() && !transferControlBlock.isCancelled()) {
                intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingTransferOptions(TransferStatus.TransferType.GET, irodsFileLength, transferControlBlock, transferStatusCallbackListener, transferControlBlock.getTransferOptions());
                status = ConnectionProgressStatus.instanceForSend(irodsFileLength);
                intraFileStatusListener.finalConnectionProgressStatusCallback(status);
            }
            if (thisFileTransferOptions != null && thisFileTransferOptions.isComputeAndVerifyChecksumAfterTransfer()) {
                irodsChecksum = this.computeChecksumOnDataObject(irodsFileToGet);
                DataObjectAOImpl.log.info("computing a checksum on the file at:{}", (Object)localFileToHoldData.getAbsolutePath());
                localFileChecksum = this.dataAOHelper.computeLocalFileChecksum(localFileToHoldData, irodsChecksum.getChecksumEncoding());
                DataObjectAOImpl.log.info("local file checksum is:{}", (Object)localFileChecksum);
                DataObjectAOImpl.log.info("irods checksum:{}", (Object)irodsChecksum);
                if (!irodsChecksum.getChecksumStringValue().equals(localFileChecksum.getChecksumStringValue())) {
                    throw new FileIntegrityException("checksum verification after get fails");
                }
            }
            if (!clientSideAction) {
                DataObjectAOImpl.log.info("looking for executable to set flag on local file");
                if (irodsFileToGet.canExecute()) {
                    DataObjectAOImpl.log.info("execute set on local file");
                    localFileToHoldData.setExecutable(true);
                }
            }
        }
        catch (Throwable e) {
            DataObjectAOImpl.log.error("error in parallel transfer", e);
            throw new JargonException("error in parallel transfer", e);
        }
        return l1descInx;
    }

    private void checkNbrThreadsAndProcessAsParallelIfMoreThanZeroThreads(IRODSFile irodsSourceFile, File localFileToHoldData, TransferOptions transferOptions, Tag message, long length, long irodsFileLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, boolean clientSideAction) throws JargonException {
        String host = message.getTag("PortList_PI").getTag("hostAddr").getStringValue();
        int port = message.getTag("PortList_PI").getTag("portNum").getIntValue();
        int password = message.getTag("PortList_PI").getTag("cookie").getIntValue();
        int numberOfThreads = message.getTag("numThreads").getIntValue();
        log.info("number of threads for this transfer = {} ", (Object)numberOfThreads);
        FileRestartInfo fileRestartInfo = null;
        if (numberOfThreads == 0) {
            log.info("number of threads is zero, possibly parallel transfers were turned off via rule, process as normal");
            int fd = message.getTag("l1descInx").getIntValue();
            this.dataAOHelper.processGetTransferViaRead(irodsSourceFile, localFileToHoldData, irodsFileLength, transferOptions, fd, transferControlBlock, transferStatusCallbackListener);
        } else {
            log.info("process as a parallel transfer");
            if (transferStatusCallbackListener == null) {
                log.info("no callback listener specified");
            } else {
                log.info("callback listener was provided");
            }
            ParallelGetFileTransferStrategy parallelGetTransferStrategy = ParallelGetFileTransferStrategy.instance(host, port, numberOfThreads, password, localFileToHoldData, this.getIRODSAccessObjectFactory(), irodsFileLength, transferControlBlock, transferStatusCallbackListener, fileRestartInfo, this.getIRODSProtocol().getStartupResponseData().getNegotiatedClientServerConfiguration());
            try {
                parallelGetTransferStrategy.transfer();
            }
            catch (Throwable e) {
                log.error("exception in parallel transfer, connection will be abandoned", e);
                this.getIRODSAccessObjectFactory().getIrodsSession().discardSessionForErrors(this.getIRODSAccount());
                throw new JargonException(e);
            }
        }
    }

    private boolean checkIfConfiguredForLongFileRestart() throws FileRestartManagementException {
        if (!this.getIRODSSession().getJargonProperties().isLongTransferRestart()) {
            log.debug("not configured for restarts");
            return false;
        }
        if (this.getIRODSSession().getRestartManager() == null) {
            log.error("configured for restarts, but there is no restart manager in IRODSSession");
            throw new FileRestartManagementException("restart specified but no restart manager in IRODSSession");
        }
        return true;
    }

    @Override
    public FileRestartInfo retrieveRestartInfoIfAvailable(FileRestartInfo.RestartType restartType, String irodsAbsolutePath) throws FileRestartManagementException {
        log.info("retrieveRestartInfoIfAvailable()");
        boolean configuredForRestart = this.checkIfConfiguredForLongFileRestart();
        if (!configuredForRestart) {
            return null;
        }
        FileRestartInfoIdentifier fileRestartInfoIdentifier = new FileRestartInfoIdentifier();
        fileRestartInfoIdentifier.setAbsolutePath(irodsAbsolutePath);
        fileRestartInfoIdentifier.setRestartType(restartType);
        fileRestartInfoIdentifier.setIrodsAccountIdentifier(this.getIRODSAccount().toString());
        return this.getIRODSSession().getRestartManager().retrieveRestart(fileRestartInfoIdentifier);
    }

    private FileRestartInfo retrieveOrCreateRestartInfoIfConfigured(FileRestartInfo.RestartType restartType, String irodsAbsolutePath, String localFilePath, int numberOfThreads, long dataSize) throws FileRestartManagementException {
        log.info("retrieveRestartInfoIfAvailable()");
        boolean configuredForRestart = this.checkIfConfiguredForLongFileRestart();
        if (!configuredForRestart) {
            return null;
        }
        if (dataSize < 0x100000L) {
            return null;
        }
        FileRestartInfoIdentifier fileRestartInfoIdentifier = new FileRestartInfoIdentifier();
        fileRestartInfoIdentifier.setAbsolutePath(irodsAbsolutePath);
        fileRestartInfoIdentifier.setRestartType(restartType);
        fileRestartInfoIdentifier.setIrodsAccountIdentifier(this.getIRODSAccount().toString());
        return this.getIRODSSession().getRestartManager().retrieveRestartAndBuildIfNotStored(fileRestartInfoIdentifier, localFilePath, numberOfThreads);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObjectUsingAVUQuery(List<AVUQueryElement> avuQuery, String dataObjectCollectionAbsPath, String dataObjectFileName) throws JargonQueryException, JargonException {
        return this.findMetadataValuesForDataObjectUsingAVUQuery(avuQuery, dataObjectCollectionAbsPath, dataObjectFileName, false);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObjectUsingAVUQuery(List<AVUQueryElement> avuQuery, String dataObjectCollectionAbsPath, String dataObjectFileName, boolean caseInsensitive) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null) {
            throw new IllegalArgumentException("null query");
        }
        if (dataObjectCollectionAbsPath == null || dataObjectCollectionAbsPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath for dataObjectCollectionAbsPath");
        }
        if (dataObjectFileName == null || dataObjectFileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectFileName");
        }
        MiscIRODSUtils.checkPathSizeForMax(dataObjectCollectionAbsPath, dataObjectFileName);
        if (caseInsensitive && !this.getIRODSServerProperties().isSupportsCaseInsensitiveQueries()) {
            throw new JargonException("case insensitive queries not supported on this iRODS version");
        }
        ObjStat objStat = this.retrieveObjStat(dataObjectCollectionAbsPath, dataObjectFileName);
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        IRODSFile dataObjectFile = this.getIRODSFileFactory().instanceIRODSFile(absPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, caseInsensitive, null);
        try {
            this.addMetadataAndDomainDataSelectsToBuilder(builder);
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, dataObjectFile.getParent()).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, dataObjectFile.getName());
            for (AVUQueryElement queryElement : avuQuery) {
                DataAOHelper.appendConditionPartToBuilderQuery(queryElement, builder);
            }
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        return DataAOHelper.buildMetaDataAndDomainDataListFromResultSet(resultSet);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObjectUsingAVUQuery(List<AVUQueryElement> avuQuery, String dataObjectAbsolutePath) throws JargonQueryException, JargonException {
        if (avuQuery == null) {
            throw new IllegalArgumentException("null query");
        }
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath for dataObjectAbsolutePath");
        }
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(dataObjectAbsolutePath);
        return this.findMetadataValuesForDataObjectUsingAVUQuery(avuQuery, irodsFile.getParent(), irodsFile.getName());
    }

    @Override
    public IRODSFile instanceIRODSFileForPath(String fileAbsolutePath) throws JargonException {
        log.info("returning a file for path: {}", (Object)fileAbsolutePath);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(fileAbsolutePath);
        return irodsFile;
    }

    @Override
    public List<BulkAVUOperationResponse> addBulkAVUMetadataToDataObject(String absolutePath, List<AvuData> avuData) throws JargonException {
        log.info("addBulkAVUMetadataToDataObject()");
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolute path");
        }
        if (avuData == null || avuData.isEmpty()) {
            throw new IllegalArgumentException("null or empty avuData");
        }
        ArrayList<BulkAVUOperationResponse> responses = new ArrayList<BulkAVUOperationResponse>();
        for (AvuData value : avuData) {
            try {
                this.addAVUMetadata(absolutePath, value);
            }
            catch (DataNotFoundException dnf) {
                log.error("dataNotFoundException when adding an AVU, catch and add to response data", (Throwable)dnf);
                responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.MISSING_METADATA_TARGET, value, dnf.getMessage()));
                continue;
            }
            catch (DuplicateDataException dde) {
                log.error("DuplicateDataException when adding an AVU, catch and add to response data", (Throwable)dde);
                responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.DUPLICATE_AVU, value, dde.getMessage()));
                continue;
            }
            log.info("treat as success...", (Object)value);
            responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.OK, value, ""));
        }
        log.info("...complete");
        return responses;
    }

    @Override
    public List<BulkAVUOperationResponse> deleteBulkAVUMetadataFromDataObject(String absolutePath, List<AvuData> avuData) throws JargonException {
        log.info("deleteBulkAVUMetadataFromDataObject()");
        if (avuData == null || avuData.isEmpty()) {
            throw new IllegalArgumentException("null or empty avuData");
        }
        ArrayList<BulkAVUOperationResponse> responses = new ArrayList<BulkAVUOperationResponse>();
        for (AvuData value : avuData) {
            try {
                this.deleteAVUMetadata(absolutePath, value);
            }
            catch (DataNotFoundException dnf) {
                log.error("dataNotFoundException when deleti an AVU, catch and add to response data", (Throwable)dnf);
                responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.MISSING_METADATA_TARGET, value, dnf.getMessage()));
                continue;
            }
            log.info("treat as success...", (Object)value);
            responses.add(BulkAVUOperationResponse.instance(BulkAVUOperationResponse.ResultStatus.OK, value, ""));
        }
        log.info("...complete");
        return responses;
    }

    @Override
    public void addAVUMetadata(String absolutePath, AvuData avuData) throws OperationNotSupportedForCollectionTypeException, DataNotFoundException, DuplicateDataException, JargonException {
        ObjStat objStat;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        log.info("adding avu metadata to data object: {}", (Object)avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        try {
            objStat = this.retrieveObjStat(absolutePath);
        }
        catch (Exception e) {
            throw new DataNotFoundException(e);
        }
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForAddDataObjectMetadata(absPath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target dataObject was not found, could not add AVU");
            }
            if (je.getMessage().indexOf("-809000") > -1) {
                throw new DuplicateDataException("Duplicate AVU exists, cannot add");
            }
            log.error("jargon exception adding AVU metadata", (Throwable)je);
            throw je;
        }
        log.debug("metadata added");
    }

    @Override
    public void addAVUMetadata(String irodsCollectionAbsolutePath, String fileName, AvuData avuData) throws DataNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsCollectionAbsolutePath, fileName);
        log.info("adding avu metadata to data object: {}", (Object)avuData);
        log.info("parent collection absolute path: {}", (Object)irodsCollectionAbsolutePath);
        log.info("file name: {}", (Object)fileName);
        ObjStat objStat = this.retrieveObjStat(irodsCollectionAbsolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        StringBuilder sb = new StringBuilder(absPath);
        sb.append("/");
        sb.append(fileName);
        this.addAVUMetadata(sb.toString(), avuData);
    }

    @Override
    public void deleteAllAVUForDataObject(String absolutePath) throws DataNotFoundException, JargonException {
        ObjStat objStat;
        log.info("deleteAllAVForDataObject()");
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        log.info("absolute path: {}", (Object)absolutePath);
        try {
            objStat = this.retrieveObjStat(absolutePath);
        }
        catch (FileNotFoundException e) {
            throw new DataNotFoundException(e);
        }
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            return;
        }
        List<MetaDataAndDomainData> metadatas = this.findMetadataValuesForDataObject(objStat);
        ArrayList<AvuData> avusToDelete = new ArrayList<AvuData>();
        for (MetaDataAndDomainData metadata : metadatas) {
            avusToDelete.add(AvuData.instance(metadata.getAvuAttribute(), metadata.getAvuValue(), metadata.getAvuUnit()));
        }
        this.deleteBulkAVUMetadataFromDataObject(absolutePath, avusToDelete);
    }

    @Override
    public void deleteAVUMetadata(String absolutePath, AvuData avuData) throws DataNotFoundException, JargonException {
        ObjStat objStat;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null AVU data");
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        log.info("deleting avu metadata on dataObject: {}", (Object)avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        try {
            objStat = this.retrieveObjStat(absolutePath);
        }
        catch (FileNotFoundException e) {
            throw new DataNotFoundException(e);
        }
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForDeleteDataObjectMetadata(absPath, avuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target data object was not found, could not remove AVU");
            }
            log.error("jargon exception removing AVU metadata", (Throwable)je);
            throw je;
        }
        log.debug("metadata removed");
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQuery(avuQuery, 0);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery, int partialStartIndex) throws JargonQueryException, JargonException {
        return this.findMetadataValuesByMetadataQuery(avuQuery, partialStartIndex, false);
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesByMetadataQuery(List<AVUQueryElement> avuQuery, int partialStartIndex, boolean caseInsensitive) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQuery == null || avuQuery.isEmpty()) {
            throw new IllegalArgumentException("null or empty query");
        }
        if (caseInsensitive && !this.getIRODSServerProperties().isSupportsCaseInsensitiveQueries()) {
            throw new JargonException("case insensitive queries not supported on this iRODS version");
        }
        log.info("building a metadata query for: {}", avuQuery);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, caseInsensitive, null);
        try {
            this.addMetadataAndDomainDataSelectsToBuilder(builder);
            for (AVUQueryElement queryElement : avuQuery) {
                DataAOHelper.appendConditionPartToBuilderQuery(queryElement, builder);
            }
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, partialStartIndex);
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        return DataAOHelper.buildMetaDataAndDomainDataListFromResultSet(resultSet);
    }

    private void addMetadataAndDomainDataSelectsToBuilder(IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_DATA_ATTR_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS);
    }

    @Override
    public List<DataObject> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements) throws JargonQueryException, JargonException {
        return this.findDomainByMetadataQuery(avuQueryElements, 0);
    }

    @Override
    public List<DataObject> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements, int partialStartIndex) throws JargonQueryException, JargonException {
        return this.findDomainByMetadataQuery(avuQueryElements, partialStartIndex, false);
    }

    @Override
    public List<DataObject> findDomainByMetadataQuery(List<AVUQueryElement> avuQueryElements, int partialStartIndex, boolean caseInsensitive) throws JargonQueryException, JargonException {
        IRODSQueryResultSet resultSet;
        if (avuQueryElements == null || avuQueryElements.isEmpty()) {
            throw new IllegalArgumentException("null or empty avuQueryElements");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("partial start index must be 0 or greater");
        }
        if (caseInsensitive && !this.getIRODSServerProperties().isSupportsCaseInsensitiveQueries()) {
            throw new JargonException("case insensitive queries not supported on this iRODS version");
        }
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, caseInsensitive, null);
        try {
            DataAOHelper.addDataObjectSelectsToBuilder(builder);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_DATA_ATTR_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_DATA_ATTR_VALUE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_META_DATA_ATTR_UNITS);
            for (AVUQueryElement queryElement : avuQueryElements) {
                DataAOHelper.appendConditionPartToBuilderQuery(queryElement, builder);
            }
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, partialStartIndex);
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        return DataAOHelper.buildListFromResultSet(resultSet);
    }

    @Override
    public void replicateIrodsDataObject(String irodsFileAbsolutePath, String targetResource) throws JargonException {
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsFileAbsolutePath");
        }
        if (targetResource == null || targetResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty targetResource");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsFileAbsolutePath);
        log.info("replicate operation, irodsFileAbsolutePath: {}", (Object)irodsFileAbsolutePath);
        log.info("to resource: {}", (Object)targetResource);
        DataObjInp dataObjInp = this.getIRODSServerProperties().isAtLeastIrods410() ? DataObjInp.instanceForReplicate410(irodsFileAbsolutePath, targetResource) : DataObjInp.instanceForReplicate(irodsFileAbsolutePath, targetResource);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (JargonException je) {
            log.error("error replicating irods file", (Throwable)je);
            throw je;
        }
        log.info("replication complete");
    }

    @Override
    public void replicateIrodsDataObjectAsynchronously(String irodsCollectionAbsolutePath, String fileName, String resourceName, int delayInMinutes) throws JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        if (resourceName == null || resourceName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceName");
        }
        if (delayInMinutes <= 0) {
            throw new IllegalArgumentException("delay in minutes must be > 0");
        }
        log.info("irodsCollectionAbsolutePath:{}", (Object)irodsCollectionAbsolutePath);
        log.info("fileName:{}", (Object)fileName);
        log.info("resourceName:{}", (Object)resourceName);
        log.info("delayInMinutes:{}", (Object)delayInMinutes);
        if (!this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0")) {
            throw new JargonException("service not available on servers prior to rods3.0");
        }
        RuleProcessingAO ruleProcessingAO = this.getIRODSAccessObjectFactory().getRuleProcessingAO(this.getIRODSAccount());
        ArrayList<IRODSRuleParameter> irodsRuleParameters = new ArrayList<IRODSRuleParameter>();
        StringBuilder sb = new StringBuilder();
        sb.append(irodsCollectionAbsolutePath);
        sb.append("/");
        sb.append(fileName);
        irodsRuleParameters.add(new IRODSRuleParameter("*SourceFile", MiscIRODSUtils.wrapStringInQuotes(sb.toString())));
        irodsRuleParameters.add(new IRODSRuleParameter("*Resource", MiscIRODSUtils.wrapStringInQuotes(resourceName)));
        irodsRuleParameters.add(new IRODSRuleParameter("*DelayInfo", RuleUtils.buildDelayParamForMinutes(delayInMinutes)));
        IRODSRuleExecResult result = ruleProcessingAO.executeRuleFromResource("/rules/rulemsiDataObjReplAsync.r", irodsRuleParameters, RuleProcessingAO.RuleProcessingType.EXTERNAL);
        log.info("result of action:{}", (Object)result.getRuleExecOut().trim());
    }

    void copyIRODSDataObject(IRODSFile irodsSourceFile, IRODSFile irodsTargetFile, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener) throws OverwriteException, DataNotFoundException, JargonException {
        TransferControlBlock operativeTransferControlBlock;
        boolean force;
        log.info("copyIRODSDataObject()");
        if (irodsSourceFile == null) {
            throw new IllegalArgumentException("null irodsSourceFile");
        }
        if (irodsTargetFile == null) {
            throw new IllegalArgumentException("null irodsTargetFile");
        }
        log.info("sourceFile:{}", (Object)irodsSourceFile.getAbsolutePath());
        log.info("targetFile:{}", (Object)irodsTargetFile.getAbsolutePath());
        log.info("at resource: {}", (Object)irodsTargetFile.getResource());
        if (!irodsSourceFile.exists()) {
            throw new DataNotFoundException("the source file for the copy does not exist");
        }
        if (!irodsSourceFile.isFile()) {
            throw new JargonException("the source file is not a data object");
        }
        IRODSFile myTargetFile = irodsTargetFile;
        if (myTargetFile.exists() && myTargetFile.isDirectory()) {
            log.info("target is a directory, check if the file already exists");
            myTargetFile = this.getIRODSFileFactory().instanceIRODSFile(irodsTargetFile.getAbsolutePath(), irodsSourceFile.getName());
            log.info("target file normalized as a data object:{}", (Object)irodsTargetFile.getAbsolutePath());
        }
        boolean bl = force = (operativeTransferControlBlock = this.checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(transferControlBlock)).getTransferOptions().getForceOption() == TransferOptions.ForceOption.USE_FORCE;
        if (!force) {
            OverwriteResponse overwriteResponse = this.evaluateOverwrite((File)((Object)irodsSourceFile), transferControlBlock, transferStatusCallbackListener, operativeTransferControlBlock.getTransferOptions(), (File)((Object)myTargetFile));
            if (overwriteResponse == OverwriteResponse.SKIP) {
                log.info("skipping due to overwrite status");
                return;
            }
            if (overwriteResponse == OverwriteResponse.PROCEED_WITH_FORCE) {
                force = true;
            }
        }
        DataObjCopyInp dataObjCopyInp = this.getIRODSServerProperties().isAtLeastIrods410() ? DataObjCopyInp.instanceForCopy410(irodsSourceFile.getAbsolutePath(), myTargetFile.getAbsolutePath(), irodsTargetFile.getResource(), irodsSourceFile.length(), force) : DataObjCopyInp.instanceForCopy(irodsSourceFile.getAbsolutePath(), myTargetFile.getAbsolutePath(), irodsTargetFile.getResource(), irodsSourceFile.length(), force);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjCopyInp);
        }
        catch (JargonException je) {
            log.error("error copying irods file", (Throwable)je);
            throw je;
        }
        log.info("copy complete");
    }

    @Override
    public void replicateIrodsDataObjectToAllResourcesInResourceGroup(String irodsFileAbsolutePath, String irodsResourceGroupName) throws JargonException {
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsFileAbsolutePath");
        }
        if (irodsResourceGroupName == null || irodsResourceGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty targetResource");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsFileAbsolutePath);
        log.info("replicate operation, irodsFileAbsolutePath: {}", (Object)irodsFileAbsolutePath);
        log.info("to resource group: {}", (Object)irodsResourceGroupName);
        DataObjInp dataObjInp = DataObjInp.instanceForReplicateToResourceGroup(irodsFileAbsolutePath, irodsResourceGroupName);
        try {
            this.getIRODSProtocol().irodsFunction(dataObjInp);
        }
        catch (JargonException je) {
            log.error("error replicating irods file to resource group", (Throwable)je);
            throw je;
        }
        log.info("replication complete");
    }

    @Override
    public List<Resource> getResourcesForDataObject(String dataObjectPath, String dataObjectName) throws JargonException {
        if (dataObjectPath == null || dataObjectPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectPath");
        }
        if (dataObjectName == null || dataObjectName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectName");
        }
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(dataObjectPath, dataObjectName);
        return this.listFileResources(irodsFile.getAbsolutePath());
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObject(String dataObjectCollectionAbsPath, String dataObjectFileName) throws JargonException {
        if (dataObjectCollectionAbsPath == null || dataObjectCollectionAbsPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectCollectionAbsPath");
        }
        if (dataObjectFileName == null || dataObjectFileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectFileName");
        }
        MiscIRODSUtils.checkPathSizeForMax(dataObjectCollectionAbsPath, dataObjectFileName);
        ObjStat objStat = this.retrieveObjStat(dataObjectCollectionAbsPath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            return this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, dataObjectCollectionAbsPath, dataObjectFileName);
        }
        catch (JargonQueryException e) {
            log.error("query exception looking up data object:{}", (Object)(dataObjectCollectionAbsPath + "/" + dataObjectFileName), (Object)e);
            log.error("fileName: {}", (Object)dataObjectFileName);
            throw new JargonException(e);
        }
    }

    @Override
    public MetaDataAndDomainData findMetadataValueForDataObjectById(String dataObjectAbsolutePath, int id) throws FileNotFoundException, DataNotFoundException, JargonException {
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectAbsolutePath");
        }
        MiscIRODSUtils.checkPathSizeForMax(dataObjectAbsolutePath);
        log.info("findMetadataValueForDataObjectById: {}", (Object)dataObjectAbsolutePath);
        log.info("id:{}", (Object)id);
        ObjStat objStat = this.retrieveObjStat(dataObjectAbsolutePath);
        return this.findMetadataValueForDataObjectById(objStat, id);
    }

    @Override
    public MetaDataAndDomainData findMetadataValueForDataObjectById(ObjStat objStat, int id) throws DataNotFoundException, JargonException {
        if (objStat == null) {
            throw new IllegalArgumentException("null or empty objStat");
        }
        log.info("findMetadataValueForDataObjectById: {}", (Object)objStat);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new JargonException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        IRODSFile dataObjectFile = this.getIRODSFileFactory().instanceIRODSFile(absPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, false, null);
        try {
            this.addMetadataAndDomainDataSelectsToBuilder(builder);
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, dataObjectFile.getParent()).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, dataObjectFile.getName()).addConditionAsGenQueryField(RodsGenQueryEnum.COL_META_DATA_ATTR_ID, QueryConditionOperators.EQUAL, id);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
            return DataAOHelper.buildMetaDataAndDomainDataFromResultSetRowForDataObject(resultSet.getFirstResult(), 1);
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObject(String dataObjectAbsolutePath) throws FileNotFoundException, JargonException {
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectAbsolutePath");
        }
        MiscIRODSUtils.checkPathSizeForMax(dataObjectAbsolutePath);
        log.info("findMetadataValuesForDataObject: {}", (Object)dataObjectAbsolutePath);
        ObjStat objStat = this.retrieveObjStat(dataObjectAbsolutePath);
        return this.findMetadataValuesForDataObject(objStat);
    }

    private List<MetaDataAndDomainData> findMetadataValuesForDataObject(ObjStat objStat) throws FileNotFoundException, JargonException {
        if (objStat == null) {
            throw new IllegalArgumentException("null or empty objStat");
        }
        log.info("findMetadataValuesForDataObject: {}", (Object)objStat);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        CollectionAndPath collectionAndName = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(objStat.getAbsolutePath());
        try {
            return this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, collectionAndName.getCollectionParent(), collectionAndName.getChildName());
        }
        catch (JargonQueryException e) {
            log.error("query exception looking up data object:{}", (Object)objStat.getAbsolutePath(), (Object)e);
            throw new JargonException(e);
        }
    }

    @Override
    public List<MetaDataAndDomainData> findMetadataValuesForDataObject(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsFile");
        }
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            return this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, irodsFile.getParent(), irodsFile.getName());
        }
        catch (JargonQueryException e) {
            log.error("query exception rethrown as Jargon Exception", (Throwable)e);
            throw new JargonException(e);
        }
    }

    @Override
    public String computeMD5ChecksumOnDataObject(IRODSFile irodsFile) throws JargonException {
        if (irodsFile == null) {
            throw new IllegalArgumentException("irodsFile is null");
        }
        log.info("computing checksum on irodsFile: {}", (Object)irodsFile.getAbsolutePath());
        DataObjInp dataObjInp = DataObjInp.instanceForDataObjectChecksum(irodsFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
        if (response == null) {
            log.error("invalid response to checksum call, response was null, expected checksum value");
            throw new JargonException("invalid response to checksum call, received null response when doing checksum on file:" + irodsFile);
        }
        String returnedChecksum = response.getTag("myStr").getStringValue();
        log.info("checksum is: {}", (Object)returnedChecksum);
        return returnedChecksum;
    }

    @Override
    public boolean verifyChecksumBetweenLocalAndIrods(IRODSFile irodsFile, File localFile) throws FileNotFoundException, JargonException {
        log.info("verifyChecksumBetweenLocalAndIrods()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("null irodsFile");
        }
        if (localFile == null) {
            throw new IllegalArgumentException("null localFile");
        }
        log.info("irodsfile:{}", (Object)irodsFile.getAbsolutePath());
        log.info("localFile:{}", (Object)localFile.getAbsolutePath());
        if (!irodsFile.exists()) {
            throw new FileNotFoundException("irodsFile does not exist");
        }
        if (!localFile.exists()) {
            throw new FileNotFoundException("localFile does not exist");
        }
        try {
            ChecksumValue irodsChecksum = this.computeChecksumOnDataObject(irodsFile);
            log.info("irodsChecksum:{}", (Object)irodsChecksum);
            ChecksumValue localChecksum = this.getIRODSSession().getLocalChecksumComputerFactory().instance(irodsChecksum.getChecksumEncoding()).computeChecksumValueForLocalFile(localFile.getAbsolutePath());
            log.info("localChecksum:{}", (Object)localChecksum);
            return irodsChecksum.getChecksumStringValue().equals(localChecksum.getChecksumStringValue());
        }
        catch (java.io.FileNotFoundException e) {
            log.error("did not find local file", (Throwable)e);
            throw new FileNotFoundException("local file not found when computing checksum", e);
        }
    }

    @Override
    @Deprecated
    public ChecksumValue computeChecksumOnDataObject(IRODSFile irodsFile) throws JargonException {
        log.info("computeChecksumOnDataObject()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("irodsFile is null");
        }
        log.info("computing checksum on irodsFile: {}", (Object)irodsFile.getAbsolutePath());
        DataObjInp dataObjInp = DataObjInp.instanceForDataObjectChecksum(irodsFile.getAbsolutePath());
        Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
        if (response == null) {
            log.error("invalid response to checksum call, response was null, expected checksum value");
            throw new JargonException("invalid response to checksum call, received null response when doing checksum on file:" + irodsFile);
        }
        String returnedChecksum = response.getTag("myStr").getStringValue();
        log.info("checksum is: {}", (Object)returnedChecksum);
        return this.dataAOHelper.computeChecksumValueFromIrodsData(returnedChecksum);
    }

    @Override
    public void setAccessPermissionRead(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absPath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionReadInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absPath, userName, "read");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionWrite(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absPath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermission(String zone, String absolutePath, String userName, FilePermissionEnum filePermission) throws JargonException {
        log.info("setAccessPermission()");
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (filePermission == null) {
            throw new IllegalArgumentException("null filePermission");
        }
        if (filePermission == FilePermissionEnum.OWN) {
            this.setAccessPermissionOwn(zone, absolutePath, userName);
        } else if (filePermission == FilePermissionEnum.READ) {
            this.setAccessPermissionRead(zone, absolutePath, userName);
        } else if (filePermission == FilePermissionEnum.WRITE) {
            this.setAccessPermissionWrite(zone, absolutePath, userName);
        } else if (filePermission == FilePermissionEnum.NONE) {
            this.removeAccessPermissionsForUser(zone, absolutePath, userName);
        } else {
            throw new JargonException("Cannot update permission, currently only READ, WRITE, and OWN, and NONE are supported");
        }
    }

    @Override
    public void setAccessPermissionWriteInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absPath, userName, "write");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwn(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absPath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void setAccessPermissionOwnInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absPath, userName, "own");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionsForUser(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermission(false, zone, absPath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public void removeAccessPermissionsForUserInAdminMode(String zone, String absolutePath, String userName) throws JargonException {
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ModAccessControlInp modAccessControlInp = ModAccessControlInp.instanceForSetPermissionInAdminMode(false, zone, absPath, userName, "null");
        this.getIRODSProtocol().irodsFunction(modAccessControlInp);
    }

    @Override
    public FilePermissionEnum getPermissionForDataObject(String absolutePath, String userName, String zone) throws JargonException {
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (zone == null) {
            throw new IllegalArgumentException("null zone");
        }
        UserFilePermission userFilePermission = this.getPermissionForDataObjectForUserName(absolutePath, userName);
        if (userFilePermission == null) {
            return null;
        }
        return userFilePermission.getFilePermissionEnum();
    }

    @Override
    public List<UserFilePermission> listPermissionsForDataObject(String irodsCollectionAbsolutePath, String dataName) throws JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (dataName == null || dataName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataName");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsCollectionAbsolutePath, dataName);
        log.info("listPermissionsForDataObject path: {}", (Object)irodsCollectionAbsolutePath);
        log.info("dataName: {}", (Object)irodsCollectionAbsolutePath);
        ObjStat objStat = this.getObjectStatForAbsolutePath(irodsCollectionAbsolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        ArrayList<UserFilePermission> userFilePermissions = new ArrayList<UserFilePermission>();
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        DataAOHelper.buildACLQueryForCollectionPathAndDataName(absPath, dataName, builder);
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
            for (IRODSQueryResultRow row : resultSet.getResults()) {
                userFilePermissions.add(this.buildUserFilePermissionFromResultRow(row));
            }
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for data object", e);
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for data object", e);
        }
        return userFilePermissions;
    }

    private UserFilePermission buildUserFilePermissionFromResultRow(IRODSQueryResultRow row) throws JargonException {
        UserFilePermission userFilePermission = new UserFilePermission(row.getColumn(0), row.getColumn(1), FilePermissionEnum.valueOf(IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(row.getColumn(2))), UserTypeEnum.findTypeByString(row.getColumn(3)), row.getColumn(4));
        return userFilePermission;
    }

    @Override
    public List<UserFilePermission> listPermissionsForDataObject(String irodsDataObjectAbsolutePath) throws JargonException {
        if (irodsDataObjectAbsolutePath == null || irodsDataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsDataObjectAbsolutePath");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsDataObjectAbsolutePath);
        log.info("listPermissionsForDataObject: {}", (Object)irodsDataObjectAbsolutePath);
        CollectionAndPath collName = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(irodsDataObjectAbsolutePath);
        return this.listPermissionsForDataObject(collName.getCollectionParent(), collName.getChildName());
    }

    @Override
    public void modifyAvuValueBasedOnGivenAttributeAndUnit(String absolutePath, AvuData avuData) throws DataNotFoundException, JargonException {
        List<MetaDataAndDomainData> result;
        if (absolutePath == null || absolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_ABSOLUTE_PATH);
        }
        if (avuData == null) {
            throw new IllegalArgumentException("null avuData");
        }
        MiscIRODSUtils.checkPathSizeForMax(absolutePath);
        log.info("setting avu metadata value for dataObject");
        log.info("with avu metadata:{}", (Object)avuData);
        log.info("absolute path: {}", (Object)absolutePath);
        ObjStat objStat = this.retrieveObjStat(absolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        ArrayList<AVUQueryElement> queryElements = new ArrayList<AVUQueryElement>();
        try {
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.ATTRIBUTE, AVUQueryOperatorEnum.EQUAL, avuData.getAttribute()));
            queryElements.add(AVUQueryElement.instanceForValueQuery(AVUQueryElement.AVUQueryPart.UNITS, AVUQueryOperatorEnum.EQUAL, avuData.getUnit()));
            result = this.findMetadataValuesForDataObjectUsingAVUQuery(queryElements, absolutePath);
        }
        catch (JargonQueryException e) {
            log.error("error querying data for avu", (Throwable)e);
            throw new JargonException("error querying data for AVU");
        }
        if (result.isEmpty()) {
            throw new DataNotFoundException("no avu data found");
        }
        if (result.size() > 1) {
            throw new JargonException("more than one AVU found with given attribute and unit, cannot modify non-unique AVU's in this way");
        }
        AvuData currentAvuData = new AvuData(result.get(0).getAvuAttribute(), result.get(0).getAvuValue(), result.get(0).getAvuUnit());
        AvuData modAvuData = new AvuData(result.get(0).getAvuAttribute(), avuData.getValue(), result.get(0).getAvuUnit());
        this.modifyAVUMetadata(absolutePath, currentAvuData, modAvuData);
        log.info("metadata modified to:{}", (Object)modAvuData);
    }

    @Override
    public void modifyAVUMetadata(String dataObjectAbsolutePath, AvuData currentAvuData, AvuData newAvuData) throws DataNotFoundException, JargonException {
        if (dataObjectAbsolutePath == null || dataObjectAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectAbsolutePath");
        }
        if (currentAvuData == null) {
            throw new IllegalArgumentException("null currentAvuData");
        }
        if (newAvuData == null) {
            throw new IllegalArgumentException("null newAvuData");
        }
        MiscIRODSUtils.checkPathSizeForMax(dataObjectAbsolutePath);
        log.info("overwrite avu metadata for data object: {}", (Object)currentAvuData);
        log.info("with new avu metadata:{}", (Object)newAvuData);
        log.info("absolute path: {}", (Object)dataObjectAbsolutePath);
        ObjStat objStat = this.retrieveObjStat(dataObjectAbsolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        ModAvuMetadataInp modifyAvuMetadataInp = ModAvuMetadataInp.instanceForModifyDataObjectMetadata(dataObjectAbsolutePath, currentAvuData, newAvuData);
        log.debug("sending avu request");
        try {
            this.getIRODSProtocol().irodsFunction(modifyAvuMetadataInp);
        }
        catch (JargonException je) {
            if (je.getMessage().indexOf("-817000") > -1) {
                throw new DataNotFoundException("Target data object was not found, could not modify AVU");
            }
            log.error("jargon exception modifying AVU metadata", (Throwable)je);
            throw je;
        }
        log.debug("metadata rewritten");
    }

    @Override
    public void modifyAVUMetadata(String irodsCollectionAbsolutePath, String dataObjectName, AvuData currentAvuData, AvuData newAvuData) throws DataNotFoundException, JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (dataObjectName == null || dataObjectName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataObjectName");
        }
        if (currentAvuData == null) {
            throw new IllegalArgumentException("null currentAvuData");
        }
        if (newAvuData == null) {
            throw new IllegalArgumentException("null newAvuData");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsCollectionAbsolutePath);
        ObjStat objStat = this.retrieveObjStat(irodsCollectionAbsolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        log.info("overwrite avu metadata for collection: {}", (Object)currentAvuData);
        log.info("with new avu metadata:{}", (Object)newAvuData);
        log.info("absolute path: {}", (Object)irodsCollectionAbsolutePath);
        log.info(" data object name: {}", (Object)dataObjectName);
        StringBuilder sb = new StringBuilder();
        sb.append(irodsCollectionAbsolutePath);
        sb.append("/");
        sb.append(dataObjectName);
        this.modifyAVUMetadata(sb.toString(), currentAvuData, newAvuData);
    }

    private UserFilePermission getPermissionViaSpecQueryAsGroupMember(String dataName, String userName, ObjStat objStat, String absPath) throws JargonException {
        log.info("see if there is a permission based on group membership...");
        UserFilePermission permissionViaGroup = null;
        if (this.getJargonProperties().isUsingSpecQueryForDataObjPermissionsForUserInGroup()) {
            log.info("is set to use specific query for group permissions via isUsingSpecQueryForDataObjPermissionsForUserInGroup()");
            permissionViaGroup = this.findPermissionForUserGrantedThroughUserGroup(userName, MiscIRODSUtils.getZoneInPath(absPath), objStat.determineAbsolutePathBasedOnCollTypeInObjectStat());
            return permissionViaGroup;
        }
        log.info("no group membership data found, not using specific query");
        return null;
    }

    private UserFilePermission getPermissionViaGenQuery(String dataName, String userName, String absPath) throws JargonException {
        UserFilePermission userFilePermission = null;
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        DataAOHelper.buildACLQueryForCollectionPathAndDataName(absPath, dataName, builder);
        try {
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_USER_NAME, QueryConditionOperators.EQUAL, userName).addOrderByGenQueryField(RodsGenQueryEnum.COL_DATA_ACCESS_TYPE, GenQueryOrderByField.OrderByType.DESC);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            IRODSQueryResultSet resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
            IRODSQueryResultRow row = resultSet.getFirstResult();
            userFilePermission = this.buildUserFilePermissionFromResultRow(row);
            log.debug("loaded filePermission:{}", (Object)userFilePermission);
        }
        catch (JargonQueryException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for data object", e);
        }
        catch (DataNotFoundException dnf) {
            log.info("no data found for user ACL");
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception for  query", (Throwable)e);
            throw new JargonException("error in query loading user file permissions for data object", e);
        }
        return userFilePermission;
    }

    private UserFilePermission findPermissionForUserGrantedThroughUserGroup(String userName, String zone, String absPath) throws JargonException {
        log.info("findPermissionForUserGrantedThroughUserGroup()");
        IRODSFile collFile = this.getIRODSFileFactory().instanceIRODSFile(absPath);
        SpecificQueryAO specificQueryAO = this.getIRODSAccessObjectFactory().getSpecificQueryAO(this.getIRODSAccount());
        if (!specificQueryAO.isSupportsSpecificQuery()) {
            log.info("no specific query support, so just return null");
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>(3);
        arguments.add(collFile.getParent());
        arguments.add(collFile.getName());
        arguments.add(userName);
        SpecificQuery specificQuery = SpecificQuery.instanceArguments("listUserACLForDataObjViaGroup", arguments, 0, zone);
        UserFilePermission userFilePermission = null;
        try {
            SpecificQueryResultSet specificQueryResultSet = specificQueryAO.executeSpecificQueryUsingAlias(specificQuery, this.getJargonProperties().getMaxFilesAndDirsQueryMax(), 0);
            IRODSQueryResultRow row = null;
            try {
                row = specificQueryResultSet.getFirstResult();
                userFilePermission = this.buildUserFilePermissionFromResultRow(row);
            }
            catch (DataNotFoundException dnf) {
                log.info("no result, return null");
                return null;
            }
        }
        catch (JargonQueryException e) {
            log.error("jargon query exception looking up permission via specific query", (Throwable)e);
            throw new JargonException(e);
        }
        return userFilePermission;
    }

    @Override
    public List<Resource> listFileResources(String irodsAbsolutePath) throws JargonException {
        IRODSQueryResultSet resultSet;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsAbsolutePath);
        log.info("listFileResources() for path:{}", (Object)irodsAbsolutePath);
        ResourceAOHelper resourceAOHelper = new ResourceAOHelper(this.getIRODSAccount(), this.getIRODSAccessObjectFactory());
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(irodsAbsolutePath);
        ObjStat objStat = this.getObjectStatForAbsolutePath(irodsAbsolutePath);
        String absPath = this.resolveAbsolutePathGivenObjStat(objStat);
        CollectionAndPath collName = MiscIRODSUtils.separateCollectionAndPathFromGivenAbsolutePath(absPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        resourceAOHelper.buildResourceSelects(builder);
        if (!irodsFile.exists() || !irodsFile.isFile()) {
            log.error("file for query does not exist, or is not a file at path:{}", (Object)irodsAbsolutePath);
            throw new JargonException("file does not exist, or is not a file");
        }
        builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, collName.getCollectionParent()).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, irodsFile.getName());
        IRODSGenQueryExecutorImpl irodsGenQueryExecutorImpl = new IRODSGenQueryExecutorImpl(this.getIRODSSession(), this.getIRODSAccount());
        try {
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
            resultSet = irodsGenQueryExecutorImpl.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, MiscIRODSUtils.getZoneInPath(absPath));
        }
        catch (JargonQueryException e) {
            log.error("query exception", (Throwable)e);
            throw new JargonException("error in query");
        }
        catch (GenQueryBuilderException e) {
            log.error("query exception", (Throwable)e);
            throw new JargonException("error in query");
        }
        List<Resource> resources = resourceAOHelper.buildResourceListFromResultSetClassic(resultSet);
        if (resources.isEmpty()) {
            log.warn("no data found");
            throw new DataNotFoundException("no resources found for file:" + irodsFile.getAbsolutePath());
        }
        return resources;
    }

    @Override
    public List<DataObject> listReplicationsForFileInResGroup(String collectionAbsPath, String fileName, String resourceGroupName) throws JargonException {
        log.info("listReplicationsForFileInResGroup");
        if (this.getIRODSServerProperties().isAtLeastIrods410()) {
            throw new UnsupportedOperationException("resource groups are not a concept in iRODS 4.1+");
        }
        if (collectionAbsPath == null || collectionAbsPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collection");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty filename");
        }
        if (resourceGroupName == null || resourceGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resgroup");
        }
        if (collectionAbsPath.endsWith("/")) {
            collectionAbsPath = collectionAbsPath.substring(0, collectionAbsPath.length() - 1);
        }
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        try {
            DataAOHelper.addDataObjectSelectsToBuilder(builder);
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, collectionAbsPath).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, fileName).addConditionAsGenQueryField(RodsGenQueryEnum.COL_D_RESC_GROUP_NAME, QueryConditionOperators.EQUAL, resourceGroupName);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(100);
            IRODSQueryResultSet resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
            return DataAOHelper.buildListFromResultSet(resultSet);
        }
        catch (Exception e) {
            log.error("Error executing Query getReplicationsForFile()", (Throwable)e);
            throw new JargonException("error querying for files in resource group", e);
        }
    }

    @Override
    public UserFilePermission getPermissionForDataObjectForUserName(String irodsAbsolutePath, String userName) throws JargonException {
        UserFilePermission groupFilePermission;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsAbsolutePath);
        ObjStat objStat = this.retrieveObjStat(irodsAbsolutePath);
        if (objStat.getSpecColType() == ObjStat.SpecColType.MOUNTED_COLL) {
            log.info("objStat indicates collection type that does not support this operation:{}", (Object)objStat);
            throw new OperationNotSupportedForCollectionTypeException("The special collection type does not support this operation");
        }
        log.info("listPermissionsForDataObjectForUserName path: {}", (Object)irodsAbsolutePath);
        log.info("userName:{}", (Object)userName);
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(this.resolveAbsolutePathGivenObjStat(objStat));
        UserFilePermission userFilePermission = this.getPermissionViaGenQuery(irodsFile.getName(), userName, irodsFile.getParent());
        try {
            groupFilePermission = this.getPermissionViaSpecQueryAsGroupMember(irodsFile.getName(), userName, objStat, irodsFile.getParent());
        }
        catch (Exception e) {
            log.error("error in getting group permission, see bug 1655");
            return userFilePermission;
        }
        return this.scoreAndReturnHighestPermission(userFilePermission, groupFilePermission);
    }

    @Override
    public UserFilePermission getPermissionForDataObjectForUserName(String irodsCollectionAbsolutePath, String dataName, String userName) throws JargonException {
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (dataName == null || dataName.isEmpty()) {
            throw new IllegalArgumentException("null or empty dataName");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(irodsCollectionAbsolutePath);
        sb.append('/');
        sb.append(dataName);
        return this.getPermissionForDataObjectForUserName(sb.toString(), userName);
    }

    private TransferOptions buildDefaultTransferOptionsIfNotSpecified(TransferOptions transferOptions) throws JargonException {
        TransferOptions myTransferOptions = transferOptions;
        myTransferOptions = transferOptions == null ? this.getIRODSSession().buildTransferOptionsBasedOnJargonProperties() : new TransferOptions(transferOptions);
        return myTransferOptions;
    }

    private TransferControlBlock checkTransferControlBlockForOptionsAndSetDefaultsIfNotSpecified(TransferControlBlock transferControlBlock) throws JargonException {
        TransferControlBlock effectiveTransferControlBlock = transferControlBlock;
        if (effectiveTransferControlBlock == null) {
            log.info("no transferControlBlock provided, building a default version");
            effectiveTransferControlBlock = DefaultTransferControlBlock.instance();
        }
        if (effectiveTransferControlBlock.getTransferOptions() == null) {
            log.info("creating a default transferOptions, as none specified");
            effectiveTransferControlBlock.setTransferOptions(this.getIRODSSession().buildTransferOptionsBasedOnJargonProperties());
        }
        return effectiveTransferControlBlock;
    }

    @Override
    public boolean isUserHasAccess(String irodsAbsolutePath, String userName) throws JargonException {
        log.info("isUserHasAccess()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        MiscIRODSUtils.checkPathSizeForMax(irodsAbsolutePath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("userName:{}", (Object)userName);
        UserFilePermission derivedPermission = this.getPermissionForDataObjectForUserName(irodsAbsolutePath, userName);
        boolean hasPermission = false;
        if (derivedPermission != null) {
            hasPermission = true;
        }
        log.info("has permision? {}", (Object)hasPermission);
        return hasPermission;
    }

    @Override
    public int getTotalNumberOfReplsForDataObject(String irodsAbsolutePath, String fileName) throws JargonException {
        log.info("getTotalNumberOfReplsForDataObject()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        List<Resource> totalres = this.getResourcesForDataObject(irodsAbsolutePath, fileName);
        return totalres.size();
    }

    @Override
    public int getTotalNumberOfReplsInResourceGroupForDataObject(String irodsAbsolutePath, String fileName, String resourceGroupName) throws JargonException {
        log.info("getTotalNumberOfReplsInResourceGroupForDataObject()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        if (resourceGroupName == null || resourceGroupName.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourceGroupName");
        }
        List<DataObject> totalres = this.listReplicationsForFileInResGroup(irodsAbsolutePath, fileName, resourceGroupName);
        return totalres.size();
    }

    @Override
    public void trimDataObjectReplicas(String irodsCollectionAbsolutePath, String fileName, String resourceName, int numberOfCopiesToKeep, int replicaNumberToDelete, boolean asIRODSAdmin) throws DataNotFoundException, JargonException {
        log.info("trimDataObjectReplicasInResourceGroup");
        if (irodsCollectionAbsolutePath == null || irodsCollectionAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException(NULL_OR_EMPTY_IRODS_COLLECTION_ABSOLUTE_PATH);
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("null resourceName");
        }
        log.info("irodsCollectionAbsolutePath:{}", (Object)irodsCollectionAbsolutePath);
        log.info("fileName:{}", (Object)fileName);
        log.info("resourceName:{}", (Object)resourceName);
        log.info("numberOfCopiesToKeep:{}", (Object)numberOfCopiesToKeep);
        log.info("replicaNumberToDelete:{}", (Object)replicaNumberToDelete);
        log.info("asIRODSAdmin:{}", (Object)asIRODSAdmin);
        if (!this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods3.0")) {
            throw new JargonException("service not available on servers prior to rods3.0");
        }
        RuleProcessingAO ruleProcessingAO = this.getIRODSAccessObjectFactory().getRuleProcessingAO(this.getIRODSAccount());
        ArrayList<IRODSRuleParameter> irodsRuleParameters = new ArrayList<IRODSRuleParameter>();
        StringBuilder sb = new StringBuilder();
        sb.append(irodsCollectionAbsolutePath);
        sb.append("/");
        sb.append(fileName);
        irodsRuleParameters.add(new IRODSRuleParameter("*SourceFile", MiscIRODSUtils.wrapStringInQuotes(sb.toString())));
        if (resourceName.isEmpty()) {
            irodsRuleParameters.add(new IRODSRuleParameter("*StorageResource", MiscIRODSUtils.wrapStringInQuotes("null")));
        } else {
            irodsRuleParameters.add(new IRODSRuleParameter("*StorageResource", MiscIRODSUtils.wrapStringInQuotes(resourceName)));
        }
        if (replicaNumberToDelete > -1) {
            irodsRuleParameters.add(new IRODSRuleParameter("*ReplicaNumber", MiscIRODSUtils.wrapStringInQuotes(String.valueOf(replicaNumberToDelete))));
        } else {
            irodsRuleParameters.add(new IRODSRuleParameter("*ReplicaNumber", MiscIRODSUtils.wrapStringInQuotes("null")));
        }
        if (numberOfCopiesToKeep > -1) {
            irodsRuleParameters.add(new IRODSRuleParameter("*KeepReplicas", MiscIRODSUtils.wrapStringInQuotes(String.valueOf(numberOfCopiesToKeep))));
        } else {
            irodsRuleParameters.add(new IRODSRuleParameter("*KeepReplicas", MiscIRODSUtils.wrapStringInQuotes("null")));
        }
        if (asIRODSAdmin) {
            irodsRuleParameters.add(new IRODSRuleParameter("*IRODSAdminFlag", MiscIRODSUtils.wrapStringInQuotes(String.valueOf(asIRODSAdmin))));
        } else {
            irodsRuleParameters.add(new IRODSRuleParameter("*IRODSAdminFlag", MiscIRODSUtils.wrapStringInQuotes("null")));
        }
        try {
            IRODSRuleExecResult result = ruleProcessingAO.executeRuleFromResource("/rules/trimDataObject.r", irodsRuleParameters, RuleProcessingAO.RuleProcessingType.EXTERNAL);
            log.info("result of action:{}", (Object)result.getRuleExecOut().trim());
        }
        catch (ResourceDoesNotExistException e) {
            log.error("resource does not exist, rethrow as datanotfound for method contract post 4.1", (Throwable)e);
            if (this.getIRODSAccessObjectFactory().getIRODSServerProperties(this.getIRODSAccount()).isAtLeastIrods410()) {
                throw new DataNotFoundException(e);
            }
            log.warn("logged and ignored for backwards compatability");
        }
        catch (InvalidInputParameterException e) {
            log.warn("invalid input parameter, for iRODS 4.0 plus treat this like it should be an ignore to preserve previous behavior", (Throwable)e);
            if (this.getIRODSServerProperties().isAtLeastIrods410()) {
                log.warn("ignored....is eirods");
            }
            throw e;
        }
    }

    @Override
    public List<DataObject> listReplicationsForFile(String collectionAbsPath, String fileName) throws JargonException {
        log.info("listReplicationsForFile");
        if (collectionAbsPath == null || collectionAbsPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collection");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty filename");
        }
        if (collectionAbsPath.endsWith("/")) {
            collectionAbsPath = collectionAbsPath.substring(0, collectionAbsPath.length() - 1);
        }
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        IRODSGenQueryExecutor irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(this.getIRODSAccount());
        try {
            DataAOHelper.addDataObjectSelectsToBuilder(builder);
            builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, collectionAbsPath).addConditionAsGenQueryField(RodsGenQueryEnum.COL_DATA_NAME, QueryConditionOperators.EQUAL, fileName);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(100);
            IRODSQueryResultSet resultSet = irodsGenQueryExecutor.executeIRODSQueryAndCloseResult(irodsQuery, 0);
            return DataAOHelper.buildListFromResultSet(resultSet);
        }
        catch (Exception e) {
            log.error("error querying for replicas", (Throwable)e);
            throw new JargonException("error querying for file replicas", e);
        }
    }

    @Override
    public byte[] computeSHA1ChecksumOfIrodsFileByReadingDataFromStream(String irodsAbsolutePath) throws DataNotFoundException, JargonException {
        MessageDigest md;
        log.info("computeSHA1ChecksumOfIrodsFileByReadingDataFromStream()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("get input stream and read to compute sha1");
        BufferedInputStream is = new BufferedInputStream(this.getIRODSFileFactory().instanceIRODSFileInputStream(irodsAbsolutePath));
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("unable to get SHA1 message digest", (Throwable)e);
            throw new JargonException("cannot commute SHA1 checksum", e);
        }
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        try {
            while ((nread = ((InputStream)is).read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
        }
        catch (IOException e) {
            log.error("IO exception computing sha1 checksum", (Throwable)e);
            throw new JargonException(e.getMessage());
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        byte[] mdbytes = md.digest();
        log.info("computed");
        return mdbytes;
    }

    private AbstractRestartManager getRestartManager() {
        return this.getIRODSSession().getRestartManager();
    }

    private static enum OverwriteResponse {
        SKIP,
        PROCEED_WITH_NO_FORCE,
        PROCEED_WITH_FORCE;

    }
}

