/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class AuthReqPluginRequestInp
extends AbstractIRODSPackingInstruction {
    public static final int AUTH_REQ_API_NBR = 1201;
    private String authScheme = "";
    private String userName = "";
    private String password = "";
    private int timeToLive = 0;
    public static final String AUTH_SCHEME_PAM = "PAM";

    public static AuthReqPluginRequestInp instancePam(String userName, String password, int timeToLive) {
        return new AuthReqPluginRequestInp(AUTH_SCHEME_PAM, userName, password, timeToLive);
    }

    private AuthReqPluginRequestInp(String authScheme, String userName, String password, int timeToLive) {
        if (authScheme == null || authScheme.isEmpty()) {
            throw new IllegalArgumentException("null or empty authScheme");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("null or empty password");
        }
        this.authScheme = authScheme;
        this.userName = userName;
        this.password = password.replaceAll(";", "\\\\;");
        this.setApiNumber(1201);
        this.timeToLive = timeToLive;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag("authPlugReqInp_PI", new Tag[]{new Tag("auth_scheme_", this.authScheme), new Tag("context_", this.getContext())});
        return message;
    }

    private String getContext() {
        StringBuilder sb = new StringBuilder();
        sb.append("a_user=");
        sb.append(this.userName);
        sb.append(";a_pw=");
        sb.append(this.password);
        sb.append(";a_ttl=");
        sb.append(this.timeToLive);
        return sb.toString();
    }
}

