/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.ClientServerNegotiationPolicy;
import org.irods.jargon.core.exception.JargonException;

public class IRODSAccount
implements Serializable {
    private static final long serialVersionUID = 8627989693793656697L;
    public static final String IRODS_JARGON_RELEASE_NUMBER = "rods3.2";
    public static final String IRODS_API_VERSION = "d";
    public static final boolean defaultObfuscate = false;
    public static final String PUBLIC_USERNAME = "anonymous";
    private AuthScheme authenticationScheme = AuthScheme.STANDARD;
    private final String host;
    private final int port;
    private String userZone;
    private String userName;
    private final String proxyZone;
    private final String proxyName;
    private String password;
    private String defaultStorageResource;
    private String homeDirectory;
    private ClientServerNegotiationPolicy clientServerNegotiationPolicy;
    private List<String> authenticatedRoles = new ArrayList<String>();

    public static IRODSAccount instance(String host, int port, String userName, String password, String homeDirectory, String zone, String defaultStorageResource, ClientServerNegotiationPolicy clientServerNegotiationPolicy) throws JargonException {
        return new IRODSAccount(host, port, userName, password, homeDirectory, zone, defaultStorageResource, userName, zone, null, clientServerNegotiationPolicy);
    }

    public static IRODSAccount instance(String host, int port, String userName, String password, String homeDirectory, String zone, String defaultStorageResource) throws JargonException {
        return new IRODSAccount(host, port, userName, password, homeDirectory, zone, defaultStorageResource, userName, zone, null, null);
    }

    public static IRODSAccount instance(String host, int port, String userName, String password, String homeDirectory, String zone, String defaultStorageResource, AuthScheme authenticationScheme) throws JargonException {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host is null or empty");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        if (homeDirectory == null) {
            throw new IllegalArgumentException("homeDirectory is null");
        }
        if (zone == null || zone.isEmpty()) {
            throw new IllegalArgumentException("zone is null or empty");
        }
        if (defaultStorageResource == null) {
            throw new IllegalArgumentException("defaultStorageResource is null");
        }
        IRODSAccount irodsAccount = new IRODSAccount(host, port, userName, password, homeDirectory, zone, defaultStorageResource);
        if (authenticationScheme == null) {
            throw new IllegalArgumentException("null authenticationScheme");
        }
        irodsAccount.setAuthenticationScheme(authenticationScheme);
        return irodsAccount;
    }

    public static IRODSAccount instanceForAnonymous(String host, int port, String homeDirectory, String zone, String defaultStorageResource) throws JargonException {
        return IRODSAccount.instance(host, port, PUBLIC_USERNAME, "", "", zone, defaultStorageResource);
    }

    public static IRODSAccount instanceForReroutedHost(IRODSAccount initialAccount, String reroutedHostName) throws JargonException {
        if (initialAccount == null) {
            throw new IllegalArgumentException("null initialAccount");
        }
        if (reroutedHostName == null || reroutedHostName.isEmpty()) {
            throw new IllegalArgumentException("null or empty reroutedHostName");
        }
        return new IRODSAccount(reroutedHostName, initialAccount.getPort(), initialAccount.getUserName(), initialAccount.getPassword(), initialAccount.getHomeDirectory(), initialAccount.getZone(), initialAccount.getDefaultStorageResource(), initialAccount.getProxyName(), initialAccount.getProxyZone(), null, initialAccount.getClientServerNegotiationPolicy());
    }

    public static IRODSAccount instanceWithProxy(String host, int port, String userName, String password, String homeDirectory, String userZone, String defaultStorageResource, String proxyName, String proxyZone, AuthScheme authScheme, ClientServerNegotiationPolicy clientServerNegotiationPolicy) {
        return new IRODSAccount(host, port, userName, password, homeDirectory, userZone, defaultStorageResource, proxyName, proxyZone, authScheme, clientServerNegotiationPolicy);
    }

    public static IRODSAccount instanceWithProxy(String host, int port, String userName, String password, String homeDirectory, String userZone, String defaultStorageResource, String proxyName, String proxyZone) {
        return new IRODSAccount(host, port, userName, password, homeDirectory, userZone, defaultStorageResource, proxyName, proxyZone, null, null);
    }

    public IRODSAccount(String host, int port, String userName, String password, String homeDirectory, String userZone, String defaultStorageResource) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.proxyName = userName;
        this.password = password;
        this.homeDirectory = homeDirectory;
        this.userZone = userZone;
        this.proxyZone = userZone;
        this.defaultStorageResource = defaultStorageResource;
    }

    private IRODSAccount(String host, int port, String userName, String password, String homeDirectory, String userZone, String defaultStorageResource, String proxyName, String proxyZone, AuthScheme authScheme, ClientServerNegotiationPolicy clientServerNegotiationPolicy) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host is null or empty");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("null or empty userName");
        }
        if (proxyName == null || proxyName.isEmpty()) {
            throw new IllegalArgumentException("null or empty proxy name");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        if (homeDirectory == null) {
            throw new IllegalArgumentException("homeDirectory is null");
        }
        if (userZone == null || userZone.isEmpty()) {
            throw new IllegalArgumentException("user zone is null or empty");
        }
        if (proxyZone == null || proxyZone.isEmpty()) {
            throw new IllegalArgumentException("proxy zone is null or empty");
        }
        if (defaultStorageResource == null) {
            throw new IllegalArgumentException("defaultStorageResource is null");
        }
        this.authenticationScheme = authScheme == null ? AuthScheme.STANDARD : authScheme;
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.proxyName = proxyName;
        this.password = password;
        this.homeDirectory = homeDirectory;
        this.userZone = userZone;
        this.proxyZone = proxyZone;
        this.defaultStorageResource = defaultStorageResource;
        this.clientServerNegotiationPolicy = clientServerNegotiationPolicy;
    }

    public String getDefaultStorageResource() {
        return this.defaultStorageResource;
    }

    public AuthScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public String getZone() {
        return this.userZone;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            IRODSAccount temp = (IRODSAccount)obj;
            if (!this.getHost().equals(temp.getHost())) {
                return false;
            }
            if (this.getPort() != temp.getPort()) {
                return false;
            }
            return this.getUserName().equals(temp.getUserName());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.host.hashCode() + this.port + this.userName.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("irods://");
        sb.append(this.getUserName());
        sb.append("@");
        sb.append(this.getHost());
        sb.append(":");
        sb.append(this.getPort());
        return sb.toString();
    }

    public URI toURI(boolean includePassword) throws JargonException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getUserName());
        sb.append('.');
        sb.append(this.getZone());
        if (includePassword) {
            if (this.proxied()) {
                throw new UnsupportedOperationException("irods URI scheme doesn't support authentication through a proxy.");
            }
            sb.append(':');
            sb.append(this.getPassword());
        }
        try {
            return new URI("irods", sb.toString(), this.getHost(), this.getPort(), this.getHomeDirectory(), null, null);
        }
        catch (URISyntaxException e) {
            throw new JargonException("unable to convert to URI", e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public final String getProxyName() {
        return this.proxyName;
    }

    public final String getProxyZone() {
        return this.proxyZone;
    }

    public String getPassword() {
        return this.password;
    }

    public static boolean isDefaultObfuscate() {
        return false;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    protected List<String> getAuthenticatedRoles() {
        return this.authenticatedRoles;
    }

    protected void setAuthenticatedRoles(List<String> authenticatedRoles) {
        this.authenticatedRoles = authenticatedRoles;
    }

    public void setAuthenticationScheme(AuthScheme authenticationScheme) {
        this.authenticationScheme = authenticationScheme;
    }

    public void setDefaultStorageResource(String defaultStorageResource) {
        this.defaultStorageResource = defaultStorageResource;
    }

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public boolean isAnonymousAccount() {
        return this.userName.equals(PUBLIC_USERNAME);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setZone(String zone) {
        this.userZone = zone;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private boolean proxied() {
        if (!this.getUserName().equals(this.getProxyName())) {
            return true;
        }
        return !this.getZone().equals(this.getProxyZone());
    }

    public synchronized ClientServerNegotiationPolicy getClientServerNegotiationPolicy() {
        return this.clientServerNegotiationPolicy;
    }

    public synchronized void setClientServerNegotiationPolicy(ClientServerNegotiationPolicy clientServerNegotiationPolicy) {
        this.clientServerNegotiationPolicy = clientServerNegotiationPolicy;
    }
}

