/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServerNegotiationPolicy {
    private static Logger log = LoggerFactory.getLogger(ClientServerNegotiationPolicy.class);
    public static final String REQUEST_NEGOTIATION_STARTUP_OPTION = "request_server_negotiation";
    private SslNegotiationPolicy sslNegotiationPolicy = SslNegotiationPolicy.NO_NEGOTIATION;

    public synchronized SslNegotiationPolicy getSslNegotiationPolicy() {
        return this.sslNegotiationPolicy;
    }

    public synchronized void setSslNegotiationPolicy(SslNegotiationPolicy sslNegotiationPolicy) {
        this.sslNegotiationPolicy = sslNegotiationPolicy;
    }

    public synchronized String buildStartupOptionsForNegotiation() {
        if (this.sslNegotiationPolicy == SslNegotiationPolicy.NO_NEGOTIATION) {
            return "";
        }
        return REQUEST_NEGOTIATION_STARTUP_OPTION;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClientServerNegotiationPolicy [");
        if (this.sslNegotiationPolicy != null) {
            builder.append("sslNegotiationPolicy=");
            builder.append((Object)this.sslNegotiationPolicy);
        }
        builder.append("]");
        return builder.toString();
    }

    public static SslNegotiationPolicy findSslNegotiationPolicyFromString(String policyString) {
        if (policyString == null || policyString.isEmpty()) {
            throw new IllegalArgumentException("null or empty policyString");
        }
        log.info("policyString:{}", (Object)policyString);
        if (policyString.equals(SslNegotiationPolicy.CS_NEG_REQUIRE.toString())) {
            log.info("setting to neg require");
            return SslNegotiationPolicy.CS_NEG_REQUIRE;
        }
        if (policyString.equals(SslNegotiationPolicy.CS_NEG_DONT_CARE.toString())) {
            log.info("setting to neg dont care");
            return SslNegotiationPolicy.CS_NEG_DONT_CARE;
        }
        if (policyString.equals(SslNegotiationPolicy.CS_NEG_REFUSE.toString())) {
            log.info("setting to neg refuse");
            return SslNegotiationPolicy.CS_NEG_REFUSE;
        }
        if (policyString.equals(SslNegotiationPolicy.NO_NEGOTIATION.toString())) {
            log.info("setting to no negotiation");
            return SslNegotiationPolicy.NO_NEGOTIATION;
        }
        throw new IllegalArgumentException("unknown negotitation policy");
    }

    public static enum SslNegotiationPolicy {
        CS_NEG_REQUIRE,
        CS_NEG_DONT_CARE,
        CS_NEG_REFUSE,
        NO_NEGOTIATION,
        CS_NEG_FAILURE;

    }
}

