/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.openstack.SwiftMetadataFeature;
import ch.cyberduck.core.openstack.SwiftSession;

public class SwiftFindFeature
implements Find {
    private final Headers feature;

    public SwiftFindFeature(SwiftSession session) {
        this(new SwiftMetadataFeature(session));
    }

    public SwiftFindFeature(Headers feature) {
        this.feature = feature;
    }

    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            this.feature.getMetadata(file);
            return true;
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        return this;
    }
}

