/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.iterate.openstack.swift.method.Authentication10UsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication11UsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication20AccessKeySecretKeyRequest;
import ch.iterate.openstack.swift.method.Authentication20RAXUsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication20UsernamePasswordRequest;
import ch.iterate.openstack.swift.method.Authentication20UsernamePasswordTenantIdRequest;
import ch.iterate.openstack.swift.method.Authentication3UsernamePasswordProjectRequest;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftAuthenticationService {
    private static final Logger log = Logger.getLogger(SwiftAuthenticationService.class);

    public Set<? extends AuthenticationRequest> getRequest(Host host, LoginCallback prompt) throws LoginCanceledException {
        Credentials credentials = host.getCredentials();
        StringBuilder url = new StringBuilder();
        url.append(host.getProtocol().getScheme().toString()).append("://");
        url.append(host.getHostname());
        if (host.getProtocol().getScheme().getPort() != host.getPort()) {
            url.append(":").append(host.getPort());
        }
        String context = PathNormalizer.normalize((String)host.getProtocol().getContext());
        url.append(context);
        if (host.getProtocol().getDefaultHostname().endsWith("identity.api.rackspacecloud.com") || host.getHostname().endsWith("identity.api.rackspacecloud.com")) {
            return Collections.singleton(new Authentication20RAXUsernameKeyRequest(URI.create(url.toString()), credentials.getUsername(), credentials.getPassword(), null));
        }
        LoginOptions options = new LoginOptions(host.getProtocol()).password(false).anonymous(false).publickey(false);
        if (context.contains("1.0")) {
            return Collections.singleton(new Authentication10UsernameKeyRequest(URI.create(url.toString()), credentials.getUsername(), credentials.getPassword()));
        }
        if (context.contains("1.1")) {
            return Collections.singleton(new Authentication11UsernameKeyRequest(URI.create(url.toString()), credentials.getUsername(), credentials.getPassword()));
        }
        if (context.contains("2.0")) {
            String user;
            String tenant;
            if (StringUtils.contains((CharSequence)credentials.getUsername(), (int)58)) {
                String[] parts = StringUtils.splitPreserveAllTokens((String)credentials.getUsername(), (char)':');
                tenant = parts[0];
                user = parts[1];
            } else {
                user = credentials.getUsername();
                tenant = prompt.prompt(host, credentials.getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Tenant Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Tenant Name", (String)"Mosso"))).getUsername();
                credentials.setUsername(String.format("%s:%s", tenant, credentials.getUsername()));
            }
            LinkedHashSet<Object> requests = new LinkedHashSet<Object>();
            requests.add(new Authentication20UsernamePasswordRequest(URI.create(url.toString()), user, credentials.getPassword(), tenant));
            requests.add(new Authentication20UsernamePasswordTenantIdRequest(URI.create(url.toString()), user, credentials.getPassword(), tenant));
            requests.add(new Authentication20AccessKeySecretKeyRequest(URI.create(url.toString()), user, credentials.getPassword(), tenant));
            return requests;
        }
        if (context.contains("3")) {
            String user;
            String domain;
            String project;
            if (StringUtils.contains((CharSequence)credentials.getUsername(), (int)58)) {
                String[] parts = StringUtils.splitPreserveAllTokens((String)credentials.getUsername(), (char)':');
                if (parts.length == 3) {
                    project = parts[0];
                    domain = parts[1];
                    user = parts[2];
                } else {
                    project = parts[0];
                    user = parts[1];
                    domain = prompt.prompt(host, credentials.getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"))).getUsername();
                    credentials.setUsername(String.format("%s:%s:%s", project, domain, credentials.getUsername()));
                }
            } else {
                user = credentials.getUsername();
                Credentials projectName = prompt.prompt(host, credentials.getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Project Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Project Name", (String)"Mosso")));
                if (StringUtils.contains((CharSequence)credentials.getUsername(), (int)58)) {
                    String[] parts = StringUtils.splitPreserveAllTokens((String)projectName.getUsername(), (char)':');
                    project = parts[0];
                    domain = parts[1];
                } else {
                    project = projectName.getUsername();
                    domain = prompt.prompt(host, credentials.getUsername(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"), options.usernamePlaceholder(LocaleFactory.localizedString((String)"Project Domain Name", (String)"Mosso"))).getUsername();
                }
                credentials.setUsername(String.format("%s:%s:%s", project, domain, credentials.getUsername()));
            }
            LinkedHashSet<Authentication3UsernamePasswordProjectRequest> requests = new LinkedHashSet<Authentication3UsernamePasswordProjectRequest>();
            requests.add(new Authentication3UsernamePasswordProjectRequest(URI.create(url.toString()), user, credentials.getPassword(), project, domain));
            return requests;
        }
        log.warn((Object)String.format("Unknown context version in %s. Default to v1 authentication.", context));
        return Collections.singleton(new Authentication10UsernameKeyRequest(URI.create(url.toString()), credentials.getUsername(), credentials.getPassword()));
    }
}

