/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.IRODSFileSystemAO;

public class IRODSTouchFeature
implements Touch {
    private final IRODSSession session;

    public IRODSTouchFeature(IRODSSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            int descriptor = fs.createFile(file.getAbsolute(), DataObjInp.OpenFlags.WRITE_TRUNCATE, 33188);
            fs.fileClose(descriptor, false);
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Cannot create file {0}", e, file);
        }
        return file;
    }

    public boolean isSupported(Path workdir) {
        return true;
    }

    public Touch withWriter(Write writer) {
        return this;
    }
}

