/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.irods.IRODSDeleteFeature;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFile;

public class IRODSMoveFeature
implements Move {
    private final IRODSSession session;
    private Delete delete;

    public IRODSMoveFeature(IRODSSession session) {
        this.session = session;
        this.delete = new IRODSDeleteFeature(session);
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            IRODSFile s = fs.getIRODSFileFactory().instanceIRODSFile(file.getAbsolute());
            if (!s.exists()) {
                throw new NotfoundException(String.format("%s doesn't exist", file.getAbsolute()));
            }
            if (status.isExists()) {
                this.delete.delete(Collections.singletonList(renamed), (PasswordCallback)connectionCallback, callback);
            }
            IRODSFile d = fs.getIRODSFileFactory().instanceIRODSFile(renamed.getAbsolute());
            s.renameTo(d);
            return renamed;
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

