/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.exception.MantaClientEncryptionException;
import com.joyent.manta.http.HttpConnectionAware;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.util.MantaUtils;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.MDC;

public interface HttpHelper
extends AutoCloseable,
HttpConnectionAware {
    public HttpResponse httpHead(String var1) throws IOException;

    public HttpResponse httpGet(String var1) throws IOException;

    public HttpResponse httpDelete(String var1) throws IOException;

    public HttpResponse httpPost(String var1) throws IOException;

    public HttpResponse httpPost(String var1, MantaHttpHeaders var2, HttpEntity var3) throws IOException;

    public MantaObjectInputStream httpRequestAsInputStream(HttpUriRequest var1, MantaHttpHeaders var2) throws IOException;

    public MantaObjectResponse httpPut(String var1, MantaHttpHeaders var2, HttpEntity var3, MantaMetadata var4) throws IOException;

    public MantaObjectResponse httpPutMetadata(String var1, MantaHttpHeaders var2, MantaMetadata var3) throws IOException;

    public CloseableHttpResponse executeRequest(HttpUriRequest var1, String var2, Object ... var3) throws IOException;

    public CloseableHttpResponse executeRequest(HttpUriRequest var1, Integer var2, String var3, Object ... var4) throws IOException;

    public CloseableHttpResponse executeAndCloseRequest(HttpUriRequest var1, String var2, Object ... var3) throws IOException;

    public CloseableHttpResponse executeAndCloseRequest(HttpUriRequest var1, Integer var2, String var3, Object ... var4) throws IOException;

    public CloseableHttpResponse executeRequest(HttpUriRequest var1, Integer var2, boolean var3, String var4, Object ... var5) throws IOException;

    public <R> R executeAndCloseRequest(HttpUriRequest var1, Function<CloseableHttpResponse, R> var2, String var3, Object ... var4) throws IOException;

    public <R> R executeAndCloseRequest(HttpUriRequest var1, Integer var2, Function<CloseableHttpResponse, R> var3, String var4, Object ... var5) throws IOException;

    public <R> R executeRequest(HttpUriRequest var1, Integer var2, Function<CloseableHttpResponse, R> var3, boolean var4, String var5, Object ... var6) throws IOException;

    public static String extractRequestId(HttpResponse response) {
        if (response == null) {
            return null;
        }
        Header responseIdHeader = response.getFirstHeader("x-request-id");
        String requestId = responseIdHeader != null ? responseIdHeader.getValue() : (MDC.get((String)"mantaRequestId") != null ? MDC.get((String)"mantaRequestId") : null);
        return requestId;
    }

    public static void annotateContextedException(ExceptionContext exception, HttpRequest request, HttpResponse response) {
        Validate.notNull((Object)exception, (String)"Exception context object must not be null", (Object[])new Object[0]);
        if (request != null) {
            String requestId = HttpHelper.extractRequestId(response);
            exception.setContextValue("requestId", (Object)requestId);
            String requestDump = ToStringBuilder.reflectionToString((Object)request, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            exception.setContextValue("request", (Object)requestDump);
            exception.setContextValue("requestMethod", (Object)request.getRequestLine().getMethod());
            exception.setContextValue("requestURL", (Object)request.getRequestLine().getUri());
            String requestHeaders = MantaUtils.asString(request.getAllHeaders());
            exception.setContextValue("requestHeaders", (Object)requestHeaders);
            exception.setContextValue("loadBalancerAddress", (Object)MDC.get((String)"mantaLoadBalancerAddress"));
        }
        if (response != null) {
            String responseDump = ToStringBuilder.reflectionToString((Object)response, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            exception.setContextValue("response", (Object)responseDump);
            String responseHeaders = MantaUtils.asString(response.getAllHeaders());
            exception.setContextValue("responseHeaders", (Object)responseHeaders);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null) {
                exception.setContextValue("responseStatusCode", (Object)statusLine.getStatusCode());
                exception.setContextValue("responseStatusReason", (Object)statusLine.getReasonPhrase());
            }
        }
    }

    public static long attemptToFindPlaintextSize(MantaObjectResponse response, long ciphertextSize, SupportedCipherDetails cipherDetails) {
        if (!cipherDetails.plaintextSizeCalculationIsAnEstimate()) {
            return cipherDetails.plaintextSize(ciphertextSize);
        }
        String plaintextLengthHeaderVal = response.getHeaderAsString("m-encrypt-plaintext-content-length");
        if (plaintextLengthHeaderVal != null) {
            return Long.parseLong(plaintextLengthHeaderVal);
        }
        String msg = "Plaintext length specified is greater than the size of the file and there is no reliable fallback information for getting the real plaintext value";
        MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
        e.setContextValue("response", response);
        throw e;
    }
}

