/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.util.MantaUtils;
import java.util.Arrays;
import java.util.Base64;

public class EnvVarConfigContext
implements ConfigContext {
    public static final String MANTA_URL_ENV_KEY = "MANTA_URL";
    public static final String MANTA_ACCOUNT_ENV_KEY = "MANTA_USER";
    public static final String MANTA_KEY_ID_ENV_KEY = "MANTA_KEY_ID";
    public static final String MANTA_KEY_PATH_ENV_KEY = "MANTA_KEY_PATH";
    public static final String MANTA_TIMEOUT_ENV_KEY = "MANTA_TIMEOUT";
    public static final String MANTA_RETRIES_ENV_KEY = "MANTA_HTTP_RETRIES";
    public static final String MANTA_MAX_CONNS_ENV_KEY = "MANTA_MAX_CONNS";
    public static final String MANTA_PRIVATE_KEY_CONTENT_ENV_KEY = "MANTA_KEY_CONTENT";
    public static final String MANTA_PASSWORD_ENV_KEY = "MANTA_PASSWORD";
    public static final String MANTA_HTTP_BUFFER_SIZE_ENV_KEY = "MANTA_HTTP_BUFFER_SIZE";
    public static final String MANTA_HTTPS_PROTOCOLS_ENV_KEY = "MANTA_HTTPS_PROTOCOLS";
    public static final String MANTA_HTTPS_CIPHERS_ENV_KEY = "MANTA_HTTPS_CIPHERS";
    public static final String MANTA_NO_AUTH_ENV_KEY = "MANTA_NO_AUTH";
    public static final String MANTA_NO_NATIVE_SIGS_ENV_KEY = "MANTA_NO_NATIVE_SIGS";
    public static final String MANTA_TCP_SOCKET_TIMEOUT_ENV_KEY = "MANTA_TCP_SOCKET_TIMEOUT";
    public static final String MANTA_CONNECTION_REQUEST_TIMEOUT_ENV_KEY = "MANTA_CONNECTION_REQUEST_TIMEOUT";
    public static final String MANTA_EXPECT_CONTINUE_TIMEOUT_ENV_KEY = "MANTA_EXPECT_CONTINUE_TIMEOUT";
    public static final String MANTA_VERIFY_UPLOADS_ENV_KEY = "MANTA_VERIFY_UPLOADS";
    public static final String MANTA_UPLOAD_BUFFER_SIZE_ENV_KEY = "MANTA_UPLOAD_BUFFER_SIZE";
    public static final String MANTA_SKIP_DIRECTORY_DEPTH_ENV_KEY = "MANTA_SKIP_DIRECTORY_DEPTH";
    public static final String MANTA_CLIENT_ENCRYPTION_ENABLED_ENV_KEY = "MANTA_CLIENT_ENCRYPTION";
    public static final String MANTA_ENCRYPTION_KEY_ID_ENV_KEY = "MANTA_CLIENT_ENCRYPTION_KEY_ID";
    public static final String MANTA_ENCRYPTION_ALGORITHM_ENV_KEY = "MANTA_ENCRYPTION_ALGORITHM";
    public static final String MANTA_PERMIT_UNENCRYPTED_DOWNLOADS_ENV_KEY = "MANTA_UNENCRYPTED_DOWNLOADS";
    public static final String MANTA_ENCRYPTION_AUTHENTICATION_MODE_ENV_KEY = "MANTA_ENCRYPTION_AUTH_MODE";
    public static final String MANTA_ENCRYPTION_PRIVATE_KEY_PATH_ENV_KEY = "MANTA_ENCRYPTION_KEY_PATH";
    public static final String MANTA_ENCRYPTION_PRIVATE_KEY_BYTES_BASE64_ENV_KEY = "MANTA_ENCRYPTION_KEY_BYTES";
    public static final String[] ALL_PROPERTIES = new String[]{"MANTA_URL", "MANTA_USER", "MANTA_KEY_ID", "MANTA_KEY_PATH", "MANTA_TIMEOUT", "MANTA_HTTP_RETRIES", "MANTA_MAX_CONNS", "MANTA_KEY_CONTENT", "MANTA_PASSWORD", "MANTA_HTTP_BUFFER_SIZE", "MANTA_HTTPS_PROTOCOLS", "MANTA_HTTPS_CIPHERS", "MANTA_NO_AUTH", "MANTA_NO_NATIVE_SIGS", "MANTA_TCP_SOCKET_TIMEOUT", "MANTA_CONNECTION_REQUEST_TIMEOUT", "MANTA_EXPECT_CONTINUE_TIMEOUT", "MANTA_VERIFY_UPLOADS", "MANTA_UPLOAD_BUFFER_SIZE", "MANTA_SKIP_DIRECTORY_DEPTH", "MANTA_CLIENT_ENCRYPTION", "MANTA_CLIENT_ENCRYPTION_KEY_ID", "MANTA_UNENCRYPTED_DOWNLOADS", "MANTA_ENCRYPTION_AUTH_MODE", "MANTA_ENCRYPTION_KEY_PATH", "MANTA_ENCRYPTION_KEY_BYTES"};

    private static String getEnv(String var) {
        return MantaUtils.toStringEmptyToNull(System.getenv(var));
    }

    @Override
    public String getMantaURL() {
        return EnvVarConfigContext.getEnv(MANTA_URL_ENV_KEY);
    }

    @Override
    public String getMantaUser() {
        return EnvVarConfigContext.getEnv(MANTA_ACCOUNT_ENV_KEY);
    }

    @Override
    public String getMantaKeyId() {
        return EnvVarConfigContext.getEnv(MANTA_KEY_ID_ENV_KEY);
    }

    @Override
    public String getMantaKeyPath() {
        return EnvVarConfigContext.getEnv(MANTA_KEY_PATH_ENV_KEY);
    }

    @Override
    public String getPrivateKeyContent() {
        return EnvVarConfigContext.getEnv(MANTA_PRIVATE_KEY_CONTENT_ENV_KEY);
    }

    @Override
    public String getPassword() {
        return EnvVarConfigContext.getEnv(MANTA_PASSWORD_ENV_KEY);
    }

    @Override
    public Integer getTimeout() {
        String timeoutString = EnvVarConfigContext.getEnv(MANTA_TIMEOUT_ENV_KEY);
        return MantaUtils.parseIntegerOrNull(timeoutString);
    }

    @Override
    public Integer getRetries() {
        String retriesString = EnvVarConfigContext.getEnv(MANTA_RETRIES_ENV_KEY);
        return MantaUtils.parseIntegerOrNull(retriesString);
    }

    @Override
    public Integer getMaximumConnections() {
        String maxConnsString = EnvVarConfigContext.getEnv(MANTA_MAX_CONNS_ENV_KEY);
        return MantaUtils.parseIntegerOrNull(maxConnsString);
    }

    @Override
    public Integer getHttpBufferSize() {
        String sizeString = EnvVarConfigContext.getEnv(MANTA_HTTP_BUFFER_SIZE_ENV_KEY);
        return MantaUtils.parseIntegerOrNull(sizeString);
    }

    @Override
    public String getHttpsProtocols() {
        return EnvVarConfigContext.getEnv(MANTA_HTTPS_PROTOCOLS_ENV_KEY);
    }

    @Override
    public String getHttpsCipherSuites() {
        return EnvVarConfigContext.getEnv(MANTA_HTTPS_CIPHERS_ENV_KEY);
    }

    @Override
    public Boolean noAuth() {
        String noAuthString = EnvVarConfigContext.getEnv(MANTA_NO_AUTH_ENV_KEY);
        return MantaUtils.parseBooleanOrNull(noAuthString);
    }

    @Override
    public Boolean disableNativeSignatures() {
        String disableNativeString = EnvVarConfigContext.getEnv(MANTA_NO_NATIVE_SIGS_ENV_KEY);
        return MantaUtils.parseBooleanOrNull(disableNativeString);
    }

    @Override
    public Integer getTcpSocketTimeout() {
        String timeoutString = EnvVarConfigContext.getEnv(MANTA_TCP_SOCKET_TIMEOUT_ENV_KEY);
        return MantaUtils.parseIntegerOrNull(timeoutString);
    }

    @Override
    public Integer getConnectionRequestTimeout() {
        return MantaUtils.parseIntegerOrNull(EnvVarConfigContext.getEnv(MANTA_CONNECTION_REQUEST_TIMEOUT_ENV_KEY));
    }

    @Override
    public Integer getExpectContinueTimeout() {
        return MantaUtils.parseIntegerOrNull(EnvVarConfigContext.getEnv(MANTA_EXPECT_CONTINUE_TIMEOUT_ENV_KEY));
    }

    @Override
    public Boolean verifyUploads() {
        String verify = EnvVarConfigContext.getEnv(MANTA_VERIFY_UPLOADS_ENV_KEY);
        return MantaUtils.parseBooleanOrNull(verify);
    }

    @Override
    public Integer getSkipDirectoryDepth() {
        return MantaUtils.parseIntegerOrNull(EnvVarConfigContext.getEnv(MANTA_SKIP_DIRECTORY_DEPTH_ENV_KEY));
    }

    @Override
    public Integer getUploadBufferSize() {
        String buffString = EnvVarConfigContext.getEnv(MANTA_UPLOAD_BUFFER_SIZE_ENV_KEY);
        return MantaUtils.parseIntegerOrNull(buffString);
    }

    @Override
    public Boolean isClientEncryptionEnabled() {
        String enabled = EnvVarConfigContext.getEnv(MANTA_CLIENT_ENCRYPTION_ENABLED_ENV_KEY);
        return MantaUtils.parseBooleanOrNull(enabled);
    }

    @Override
    public String getEncryptionKeyId() {
        return EnvVarConfigContext.getEnv(MANTA_ENCRYPTION_KEY_ID_ENV_KEY);
    }

    @Override
    public String getEncryptionAlgorithm() {
        return EnvVarConfigContext.getEnv(MANTA_ENCRYPTION_ALGORITHM_ENV_KEY);
    }

    @Override
    public Boolean permitUnencryptedDownloads() {
        String permit = EnvVarConfigContext.getEnv(MANTA_PERMIT_UNENCRYPTED_DOWNLOADS_ENV_KEY);
        return MantaUtils.parseBooleanOrNull(permit);
    }

    @Override
    public EncryptionAuthenticationMode getEncryptionAuthenticationMode() {
        String enumValue = EnvVarConfigContext.getEnv(MANTA_ENCRYPTION_AUTHENTICATION_MODE_ENV_KEY);
        return MantaUtils.parseEnumOrNull(enumValue, EncryptionAuthenticationMode.class);
    }

    @Override
    public String getEncryptionPrivateKeyPath() {
        return EnvVarConfigContext.getEnv(MANTA_ENCRYPTION_PRIVATE_KEY_PATH_ENV_KEY);
    }

    @Override
    public byte[] getEncryptionPrivateKeyBytes() {
        String base64 = EnvVarConfigContext.getEnv(MANTA_ENCRYPTION_PRIVATE_KEY_BYTES_BASE64_ENV_KEY);
        if (base64 == null) {
            return null;
        }
        return Base64.getDecoder().decode(base64);
    }

    public String toString() {
        return ConfigContext.toString(this);
    }

    static {
        Arrays.sort(ALL_PROPERTIES);
    }
}

