/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObjectMapper;
import com.joyent.manta.client.multipart.AbstractMultipartManager;
import com.joyent.manta.client.multipart.CreateMPURequestBody;
import com.joyent.manta.client.multipart.MantaMultipartStatus;
import com.joyent.manta.client.multipart.MantaMultipartUpload;
import com.joyent.manta.client.multipart.MantaMultipartUploadPart;
import com.joyent.manta.client.multipart.MantaMultipartUploadTuple;
import com.joyent.manta.client.multipart.ServerSideMultipartUpload;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.exception.MantaMultipartException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.http.entity.ExposedByteArrayEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSideMultipartManager
extends AbstractMultipartManager<ServerSideMultipartUpload, MantaMultipartUploadPart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSideMultipartManager.class);
    private static final int MAX_PARTS = 10000;
    private static final int MIN_PART_SIZE = 0x500000;
    private final ConfigContext config;
    private final HttpHelper httpHelper;
    private final MantaClient mantaClient;
    private final Set<AutoCloseable> danglingStreams;

    public ServerSideMultipartManager(MantaClient mantaClient) {
        Set dangling;
        Validate.isTrue((!mantaClient.isClosed() ? 1 : 0) != 0, (String)"Manta client must not be closed", (Object[])new Object[0]);
        this.config = mantaClient.getContext();
        this.mantaClient = mantaClient;
        this.httpHelper = ServerSideMultipartManager.readFieldFromMantaClient("httpHelper", mantaClient, HttpHelper.class);
        this.danglingStreams = dangling = ServerSideMultipartManager.readFieldFromMantaClient("danglingStreams", mantaClient, Set.class);
    }

    ServerSideMultipartManager(ConfigContext config, HttpHelper httpHelper, MantaClient mantaClient) {
        Set dangling;
        Validate.isTrue((!mantaClient.isClosed() ? 1 : 0) != 0, (String)"MantaClient must not be closed", (Object[])new Object[0]);
        this.config = config;
        this.mantaClient = mantaClient;
        this.httpHelper = httpHelper;
        this.danglingStreams = dangling = ServerSideMultipartManager.readFieldFromMantaClient("danglingStreams", mantaClient, Set.class);
    }

    @Override
    public int getMaxParts() {
        return 10000;
    }

    @Override
    public int getMinimumPartSize() {
        return 0x500000;
    }

    @Override
    public Stream<MantaMultipartUpload> listInProgress() throws IOException {
        String uploadsPath = this.uploadsPath();
        Stream<MantaMultipartUpload> stream = this.mantaClient.listObjects(uploadsPath).map(mantaObject -> {
            try {
                return this.mantaClient.listObjects(mantaObject.getPath()).map(item -> {
                    String objectName = FilenameUtils.getName((String)item.getPath());
                    UUID id = UUID.fromString(objectName);
                    return new ServerSideMultipartUpload(id, null, this.uuidPrefixedPath(id));
                }).collect(Collectors.toSet());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).flatMap(Collection::stream);
        this.danglingStreams.add(stream);
        return stream;
    }

    @Override
    public ServerSideMultipartUpload initiateUpload(String path) throws IOException {
        return this.initiateUpload(path, new MantaMetadata());
    }

    @Override
    public ServerSideMultipartUpload initiateUpload(String path, MantaMetadata mantaMetadata) throws IOException {
        return this.initiateUpload(path, mantaMetadata, new MantaHttpHeaders());
    }

    @Override
    public ServerSideMultipartUpload initiateUpload(String path, MantaMetadata mantaMetadata, MantaHttpHeaders httpHeaders) throws IOException {
        return this.initiateUpload(path, null, mantaMetadata, httpHeaders);
    }

    @Override
    public ServerSideMultipartUpload initiateUpload(String path, Long contentLength, MantaMetadata mantaMetadata, MantaHttpHeaders httpHeaders) throws IOException {
        Validate.notBlank((CharSequence)path, (String)"Path to object must not be blank", (Object[])new Object[0]);
        MantaMetadata metadata = mantaMetadata == null ? new MantaMetadata() : mantaMetadata;
        MantaHttpHeaders headers = httpHeaders == null ? new MantaHttpHeaders() : httpHeaders;
        if (contentLength != null && headers.getContentLength() == null) {
            headers.setContentLength(contentLength);
        }
        String postPath = this.uploadsPath();
        HttpPost post = this.httpHelper.getRequestFactory().post(postPath);
        byte[] jsonRequest = ServerSideMultipartManager.createMpuRequestBody(path, metadata, headers);
        ExposedByteArrayEntity entity = new ExposedByteArrayEntity(jsonRequest, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        int expectedStatusCode = 201;
        CloseableHttpClient httpClient = this.httpHelper.getConnectionContext().getHttpClient();
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            ServerSideMultipartUpload serverSideMultipartUpload;
            block17: {
                StatusLine statusLine = response.getStatusLine();
                this.validateStatusCode(201, statusLine.getStatusCode(), "Unable to create multipart upload", (HttpRequest)post, (HttpResponse)response, path, jsonRequest);
                this.validateEntityIsPresent((HttpRequest)post, (HttpResponse)response, path, jsonRequest);
                InputStream in = response.getEntity().getContent();
                Throwable throwable2 = null;
                try {
                    ObjectNode mpu = (ObjectNode)MantaObjectMapper.INSTANCE.readValue(in, ObjectNode.class);
                    JsonNode idNode = mpu.get("id");
                    Validate.notNull((Object)idNode, (String)"No multipart id returned in response", (Object[])new Object[0]);
                    UUID uploadId = UUID.fromString(idNode.textValue());
                    JsonNode partsDirectoryNode = mpu.get("partsDirectory");
                    Validate.notNull((Object)partsDirectoryNode, (String)"No parts directory returned in response", (Object[])new Object[0]);
                    String partsDirectory = partsDirectoryNode.textValue();
                    serverSideMultipartUpload = new ServerSideMultipartUpload(uploadId, path, partsDirectory);
                    if (in == null) break block17;
                }
                catch (Throwable mpu) {
                    try {
                        String msg;
                        try {
                            try {
                                throwable2 = mpu;
                                throw mpu;
                            }
                            catch (Throwable throwable3) {
                                if (in != null) {
                                    ServerSideMultipartManager.$closeResource(throwable2, in);
                                }
                                throw throwable3;
                            }
                        }
                        catch (IllegalArgumentException | NullPointerException e) {
                            msg = "Expected response field was missing or malformed";
                            MantaMultipartException me = new MantaMultipartException(msg, e);
                            this.annotateException((ExceptionContext)me, (HttpRequest)post, (HttpResponse)response, path, jsonRequest);
                            throw me;
                        }
                        catch (JsonParseException e) {
                            msg = "Response body was not JSON";
                            MantaMultipartException me = new MantaMultipartException(msg, e);
                            this.annotateException((ExceptionContext)me, (HttpRequest)post, (HttpResponse)response, path, jsonRequest);
                            throw me;
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                ServerSideMultipartManager.$closeResource(throwable2, in);
            }
            return serverSideMultipartUpload;
        }
    }

    @Override
    MantaMultipartUploadPart uploadPart(ServerSideMultipartUpload upload, int partNumber, HttpEntity entity, HttpContext context) throws IOException {
        Validate.notNull((Object)upload, (String)"Upload state object must not be null", (Object[])new Object[0]);
        this.validatePartNumber(partNumber);
        int adjustedPartNumber = partNumber - 1;
        String putPath = upload.getPartsDirectory() + "/" + adjustedPartNumber;
        HttpPut put = this.httpHelper.getRequestFactory().put(putPath);
        put.setEntity(entity);
        CloseableHttpClient httpClient = this.httpHelper.getConnectionContext().getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put, context);){
            this.validateStatusCode(204, response.getStatusLine().getStatusCode(), "Unable to upload part", (HttpRequest)put, (HttpResponse)response, null, null);
            Header etagHeader = response.getFirstHeader("ETag");
            if (etagHeader == null || StringUtils.isEmpty((CharSequence)etagHeader.getValue())) {
                MantaMultipartException mme = new MantaMultipartException("ETag missing from part response");
                HttpHelper.annotateContextedException((ExceptionContext)mme, (HttpRequest)put, (HttpResponse)response);
                throw mme;
            }
            MantaMultipartUploadPart mantaMultipartUploadPart = new MantaMultipartUploadPart(partNumber, upload.getPath(), etagHeader.getValue());
            return mantaMultipartUploadPart;
        }
    }

    @Override
    public MantaMultipartUploadPart getPart(ServerSideMultipartUpload upload, int partNumber) throws IOException {
        String etag;
        String objectPath;
        JsonNode objectPathNode;
        Throwable throwable;
        Validate.notNull((Object)upload, (String)"Upload state object must not be null", (Object[])new Object[0]);
        this.validatePartNumber(partNumber);
        int adjustedPartNumber = partNumber - 1;
        String getPath = upload.getPartsDirectory() + "/" + "state";
        HttpGet get = this.httpHelper.getRequestFactory().get(getPath);
        int expectedStatusCode = 200;
        CloseableHttpClient httpClient = this.httpHelper.getConnectionContext().getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            StatusLine statusLine = response.getStatusLine();
            this.validateStatusCode(200, statusLine.getStatusCode(), "Unable to get status for multipart upload", (HttpRequest)get, (HttpResponse)response, null, null);
            this.validateEntityIsPresent((HttpRequest)get, (HttpResponse)response, null, null);
            try {
                throwable = null;
                try (InputStream in = response.getEntity().getContent();){
                    ObjectNode objectNode = (ObjectNode)MantaObjectMapper.INSTANCE.readValue(in, ObjectNode.class);
                    objectPathNode = objectNode.get("targetObject");
                    Validate.notNull((Object)objectPathNode, (String)"Unable to read object path from response", (Object[])new Object[0]);
                    objectPath = objectPathNode.textValue();
                    Validate.notBlank((CharSequence)objectPath, (String)"Object path field was blank in response", (Object[])new Object[0]);
                }
                catch (Throwable objectNode) {
                    throwable = objectNode;
                    throw objectNode;
                }
            }
            catch (JsonParseException e) {
                String msg = "Response body was not JSON";
                MantaMultipartException me = new MantaMultipartException(msg, e);
                this.annotateException((ExceptionContext)me, (HttpRequest)get, (HttpResponse)response, null, null);
                throw me;
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "Expected response field was missing or malformed";
                MantaMultipartException me = new MantaMultipartException(msg, e);
                this.annotateException((ExceptionContext)me, (HttpRequest)get, (HttpResponse)response, null, null);
                throw me;
            }
        }
        String headPath = upload.getPartsDirectory() + "/" + adjustedPartNumber;
        HttpHead head = this.httpHelper.getRequestFactory().head(headPath);
        throwable = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)head);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 404) {
                objectPathNode = null;
                return objectPathNode;
            }
            this.validateStatusCode(200, statusLine.getStatusCode(), "Unable to get status for multipart upload part", (HttpRequest)get, (HttpResponse)response, null, null);
            try {
                Header etagHeader = response.getFirstHeader("ETag");
                Validate.notNull((Object)etagHeader, (String)"ETag header was not returned", (Object[])new Object[0]);
                etag = etagHeader.getValue();
                Validate.notBlank((CharSequence)etag, (String)"ETag is blank", (Object[])new Object[0]);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "Expected header was missing or malformed";
                MantaMultipartException me = new MantaMultipartException(msg, e);
                this.annotateException((ExceptionContext)me, (HttpRequest)get, (HttpResponse)response, null, null);
                throw me;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return new MantaMultipartUploadPart(partNumber, objectPath, etag);
    }

    /*
     * Loose catch block
     */
    @Override
    public MantaMultipartStatus getStatus(ServerSideMultipartUpload upload) throws IOException {
        Validate.notNull((Object)upload, (String)"Upload state object must not be null", (Object[])new Object[0]);
        String partsDirectory = upload.getPartsDirectory() == null ? this.uuidPrefixedPath(upload.getId()) : upload.getPartsDirectory();
        String getPath = partsDirectory + "/" + "state";
        HttpGet get = this.httpHelper.getRequestFactory().get(getPath);
        int expectedStatusCode = 200;
        CloseableHttpClient httpClient = this.httpHelper.getConnectionContext().getHttpClient();
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            MantaMultipartStatus mantaMultipartStatus;
            Throwable throwable2;
            InputStream in;
            block30: {
                block28: {
                    MantaMultipartStatus mantaMultipartStatus2;
                    block29: {
                        String state;
                        ObjectNode objectNode;
                        block26: {
                            MantaMultipartStatus mantaMultipartStatus3;
                            block27: {
                                block24: {
                                    MantaMultipartStatus mantaMultipartStatus4;
                                    block25: {
                                        StatusLine statusLine = response.getStatusLine();
                                        if (statusLine.getStatusCode() == 404) {
                                            MantaMultipartStatus mantaMultipartStatus5 = MantaMultipartStatus.UNKNOWN;
                                            return mantaMultipartStatus5;
                                        }
                                        this.validateStatusCode(200, statusLine.getStatusCode(), "Unable to get status for multipart upload", (HttpRequest)get, (HttpResponse)response, null, null);
                                        this.validateEntityIsPresent((HttpRequest)get, (HttpResponse)response, null, null);
                                        in = response.getEntity().getContent();
                                        throwable2 = null;
                                        objectNode = (ObjectNode)MantaObjectMapper.INSTANCE.readValue(in, ObjectNode.class);
                                        JsonNode stateNode = objectNode.get("state");
                                        Validate.notNull((Object)stateNode, (String)"Unable to get state from response", (Object[])new Object[0]);
                                        state = stateNode.textValue();
                                        Validate.notBlank((CharSequence)state, (String)"State field was blank in response", (Object[])new Object[0]);
                                        if (!state.equalsIgnoreCase("created")) break block24;
                                        mantaMultipartStatus4 = MantaMultipartStatus.CREATED;
                                        if (in == null) break block25;
                                        ServerSideMultipartManager.$closeResource(throwable2, in);
                                    }
                                    return mantaMultipartStatus4;
                                }
                                if (!state.equalsIgnoreCase("finalizing")) break block26;
                                mantaMultipartStatus3 = this.extractMultipartStatusResult(objectNode);
                                if (in == null) break block27;
                                ServerSideMultipartManager.$closeResource(throwable2, in);
                            }
                            return mantaMultipartStatus3;
                        }
                        if (!state.equalsIgnoreCase("done")) break block28;
                        mantaMultipartStatus2 = this.extractMultipartStatusResult(objectNode);
                        if (in == null) break block29;
                        ServerSideMultipartManager.$closeResource(throwable2, in);
                    }
                    return mantaMultipartStatus2;
                }
                mantaMultipartStatus = MantaMultipartStatus.UNKNOWN;
                if (in == null) break block30;
                ServerSideMultipartManager.$closeResource(throwable2, in);
            }
            return mantaMultipartStatus;
            {
                catch (Throwable objectNode) {
                    try {
                        MantaMultipartException me;
                        String msg;
                        try {
                            try {
                                throwable2 = objectNode;
                                throw objectNode;
                            }
                            catch (Throwable throwable3) {
                                if (in != null) {
                                    ServerSideMultipartManager.$closeResource(throwable2, in);
                                }
                                throw throwable3;
                            }
                        }
                        catch (JsonParseException e) {
                            msg = "Response body was not JSON";
                            me = new MantaMultipartException(msg, e);
                            this.annotateException((ExceptionContext)me, (HttpRequest)get, (HttpResponse)response, null, null);
                            throw me;
                        }
                        catch (IllegalArgumentException | NullPointerException e) {
                            msg = "Expected response field was missing or malformed";
                            me = new MantaMultipartException(msg, e);
                            this.annotateException((ExceptionContext)me, (HttpRequest)get, (HttpResponse)response, null, null);
                            throw me;
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
            }
        }
    }

    private MantaMultipartStatus extractMultipartStatusResult(ObjectNode objectNode) {
        JsonNode resultNode = objectNode.get("result");
        Validate.notNull((Object)resultNode, (String)"Unable to get result from response", (Object[])new Object[0]);
        String result = resultNode.textValue();
        Validate.notBlank((CharSequence)result, (String)"Result field was blank in response", (Object[])new Object[0]);
        if (result.equalsIgnoreCase("aborting")) {
            return MantaMultipartStatus.ABORTING;
        }
        if (result.equalsIgnoreCase("aborted")) {
            return MantaMultipartStatus.ABORTED;
        }
        if (result.equalsIgnoreCase("committing")) {
            return MantaMultipartStatus.COMMITTING;
        }
        if (result.equalsIgnoreCase("committed")) {
            return MantaMultipartStatus.COMMITTING;
        }
        return MantaMultipartStatus.UNKNOWN;
    }

    @Override
    public Stream<MantaMultipartUploadPart> listParts(ServerSideMultipartUpload upload) throws IOException {
        Validate.notNull((Object)upload, (String)"Upload state object must not be null", (Object[])new Object[0]);
        String partsDirectory = upload.getPartsDirectory();
        Stream<MantaMultipartUploadPart> stream = this.mantaClient.listObjects(partsDirectory).map(mantaObject -> {
            String item = FilenameUtils.getName((String)mantaObject.getPath());
            int adjustedPartNumber = Integer.parseInt(item) + 1;
            String etag = mantaObject.getEtag();
            return new MantaMultipartUploadPart(adjustedPartNumber, upload.getPath(), etag);
        });
        this.danglingStreams.add(stream);
        return stream;
    }

    @Override
    public void abort(ServerSideMultipartUpload upload) throws IOException {
        Validate.notNull((Object)upload, (String)"Upload state object must not be null", (Object[])new Object[0]);
        String postPath = upload.getPartsDirectory() + "/" + "abort";
        HttpPost post = this.httpHelper.getRequestFactory().post(postPath);
        int expectedStatusCode = 204;
        CloseableHttpClient httpClient = this.httpHelper.getConnectionContext().getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            StatusLine statusLine = response.getStatusLine();
            this.validateStatusCode(204, statusLine.getStatusCode(), "Unable to abort multipart upload", (HttpRequest)post, (HttpResponse)response, null, null);
            LOGGER.info("Aborted multipart upload [id={}]", (Object)upload.getId());
        }
    }

    @Override
    public void complete(ServerSideMultipartUpload upload, Iterable<? extends MantaMultipartUploadTuple> parts) throws IOException {
        Validate.notNull((Object)upload, (String)"Upload state object must not be null", (Object[])new Object[0]);
        Stream<? extends MantaMultipartUploadTuple> partsStream = StreamSupport.stream(parts.spliterator(), false);
        this.complete(upload, partsStream);
    }

    @Override
    public void complete(ServerSideMultipartUpload upload, Stream<? extends MantaMultipartUploadTuple> partsStream) throws IOException {
        int numParts;
        byte[] jsonRequest;
        Validate.notNull((Object)upload, (String)"Upload state object must not be null", (Object[])new Object[0]);
        String path = upload.getPath();
        String postPath = upload.getPartsDirectory();
        HttpPost post = this.httpHelper.getRequestFactory().post(postPath + "/commit");
        try {
            ImmutablePair<byte[], Integer> pair = ServerSideMultipartManager.createCommitRequestBody(partsStream);
            jsonRequest = (byte[])pair.getLeft();
            numParts = (Integer)pair.getRight();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            String msg = "Expected response field was missing or malformed";
            MantaMultipartException me = new MantaMultipartException(msg, e);
            this.annotateException((ExceptionContext)me, (HttpRequest)post, null, path, null);
            throw me;
        }
        ExposedByteArrayEntity entity = new ExposedByteArrayEntity(jsonRequest, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        int expectedStatusCode = 201;
        CloseableHttpClient httpClient = this.httpHelper.getConnectionContext().getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            StatusLine statusLine = response.getStatusLine();
            this.validateStatusCode(201, statusLine.getStatusCode(), "Unable to create multipart upload", (HttpRequest)post, (HttpResponse)response, path, jsonRequest);
            Header location = response.getFirstHeader("Location");
            if (location != null && LOGGER.isInfoEnabled()) {
                LOGGER.info("Multipart upload [{}] for file [{}] from [{}] parts has completed", new Object[]{upload.getId(), location.getValue(), numParts});
            }
        }
        catch (MantaClientHttpResponseException | MantaMultipartException me) {
            throw me;
        }
        catch (Exception e) {
            String msg = "Error initiating multipart upload completion";
            MantaMultipartException me = new MantaMultipartException(msg, e);
            this.annotateException((ExceptionContext)me, (HttpRequest)post, null, path, jsonRequest);
            throw me;
        }
    }

    static byte[] createMpuRequestBody(String objectPath, MantaMetadata mantaMetadata, MantaHttpHeaders headers) {
        Validate.notNull((Object)objectPath, (String)"Path to Manta object must not be null", (Object[])new Object[0]);
        CreateMPURequestBody requestBody = new CreateMPURequestBody(objectPath, mantaMetadata, headers);
        try {
            return MantaObjectMapper.INSTANCE.writeValueAsBytes((Object)requestBody);
        }
        catch (IOException e) {
            String msg = "Error serializing JSON for create MPU request body";
            throw new MantaMultipartException(msg, e);
        }
    }

    static ImmutablePair<byte[], Integer> createCommitRequestBody(Stream<? extends MantaMultipartUploadTuple> parts) {
        JsonNodeFactory nodeFactory = MantaObjectMapper.NODE_FACTORY_INSTANCE;
        ObjectNode objectNode = new ObjectNode(nodeFactory);
        ArrayNode partsArrayNode = new ArrayNode(nodeFactory);
        objectNode.set("parts", (JsonNode)partsArrayNode);
        try (Stream<? extends MantaMultipartUploadTuple> sorted = parts.sorted();){
            sorted.forEach(tuple -> partsArrayNode.add(tuple.getEtag()));
        }
        Validate.isTrue((partsArrayNode.size() > 0 ? 1 : 0) != 0, (String)"Can't commit multipart upload with no parts", (Object[])new Object[0]);
        try {
            return ImmutablePair.of((Object)MantaObjectMapper.INSTANCE.writeValueAsBytes((Object)objectNode), (Object)partsArrayNode.size());
        }
        catch (IOException e) {
            String msg = "Error serializing JSON for commit MPU request body";
            throw new MantaMultipartException(msg, e);
        }
    }

    private void validateStatusCode(int expectedCode, int actualCode, String errorMessage, HttpRequest request, HttpResponse response, String objectPath, byte[] requestBody) {
        if (actualCode != expectedCode) {
            String path = objectPath == null && request != null ? request.getRequestLine().getUri() : objectPath;
            MantaClientHttpResponseException mchre = new MantaClientHttpResponseException(request, response, path);
            MantaMultipartException e = new MantaMultipartException(errorMessage, mchre);
            this.annotateException((ExceptionContext)e, request, response, objectPath, requestBody);
            throw e;
        }
    }

    private String uploadsPath() {
        return this.config.getMantaHomeDirectory() + "/" + "uploads";
    }

    String uuidPrefixedPath(UUID uuid) {
        Validate.notNull((Object)uuid, (String)"UUID must not be null", (Object[])new Object[0]);
        String uuidString = uuid.toString();
        return this.uploadsPath() + "/" + uuidString.substring(0, 1) + "/" + uuidString;
    }

    private void validateEntityIsPresent(HttpRequest request, HttpResponse response, String objectPath, byte[] requestBody) throws MantaIOException {
        if (response.getEntity() == null) {
            String msg = "Entity response was null";
            MantaMultipartException e = new MantaMultipartException(msg);
            this.annotateException((ExceptionContext)e, request, response, objectPath, requestBody);
            throw e;
        }
        try {
            if (response.getEntity().getContent() == null) {
                String msg = "Entity content InputStream was null";
                MantaMultipartException e = new MantaMultipartException(msg);
                this.annotateException((ExceptionContext)e, request, response, objectPath, requestBody);
                throw e;
            }
        }
        catch (IOException e) {
            String msg = "Unable to get an InputStream from the HTTP entity";
            MantaIOException mioe = new MantaIOException(msg, e);
            this.annotateException(mioe, request, response, objectPath, requestBody);
            throw mioe;
        }
    }

    private void annotateException(ExceptionContext exception, HttpRequest request, HttpResponse response, String objectPath, byte[] requestBody) {
        HttpHelper.annotateContextedException(exception, request, response);
        if (objectPath != null) {
            exception.setContextValue("objectPath", (Object)objectPath);
        }
        if (requestBody != null) {
            exception.setContextValue("requestBody", (Object)new String(requestBody, StandardCharsets.UTF_8));
        }
    }
}

