/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.binding.foundation.FoundationKitFunctionsLibrary;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinder;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class ApplicationSupportDirectoryFinder
implements SupportDirectoryFinder {
    private static final Logger log = Logger.getLogger(ApplicationSupportDirectoryFinder.class);
    private final Preferences preferences = PreferencesFactory.get();

    public Local find() {
        NSArray directories = FoundationKitFunctionsLibrary.NSSearchPathForDirectoriesInDomains((int)14, (int)1, (boolean)true);
        String application = this.preferences.getProperty("application.name");
        if (directories.count().intValue() == 0) {
            log.error((Object)"Failed searching for application support directory");
            return LocalFactory.get((String)"~/Library/Application Support", (String)application);
        }
        String directory = directories.objectAtIndex(new NSUInteger(0L)).toString();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Found application support directory in %s", directory));
        }
        Local folder = LocalFactory.get((String)directory, (String)application);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Use folder %s for application support directory", folder));
        }
        return folder;
    }
}

