/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.foundation.NSFileManager;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.io.LocalRepeatableFileInputStream;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.FilesystemBookmarkResolver;
import ch.cyberduck.core.local.FilesystemBookmarkResolverFactory;
import ch.cyberduck.core.local.FinderLocalAttributes;
import ch.cyberduck.core.local.TildeExpander;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Serializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public class FinderLocal
extends Local {
    private static final Logger log = Logger.getLogger(FinderLocal.class);
    private static final NSFileManager manager;
    private static final FilesystemBookmarkResolver<NSURL> resolver;
    private String bookmark;
    private final FinderLocalAttributes attributes = new FinderLocalAttributes(this);

    public FinderLocal(Local parent, String name) throws LocalAccessDeniedException {
        super(parent, name);
    }

    public FinderLocal(String parent, String name) throws LocalAccessDeniedException {
        super(parent, name);
    }

    public FinderLocal(String path) throws LocalAccessDeniedException {
        super(FinderLocal.resolveAlias(new TildeExpander().expand(path)));
    }

    public <T> T serialize(Serializer dict) {
        dict.setStringForKey(this.getAbbreviatedPath(), "Path");
        String bookmark = this.getBookmark();
        if (StringUtils.isNotBlank((CharSequence)bookmark)) {
            dict.setStringForKey(bookmark, String.format("%s Bookmark", PreferencesFactory.get().getProperty("application.name")));
        }
        return (T)dict.getSerialized();
    }

    public String getDisplayName() {
        return manager.displayNameAtPath(this.getName());
    }

    public String getAbbreviatedPath() {
        return new TildeExpander().abbreviate(this.getAbsolute());
    }

    public Local getVolume() {
        Local parent = this.getParent();
        while (!parent.isRoot()) {
            Local directory = parent.getParent();
            if (null == directory) {
                return super.getVolume();
            }
            if ("/Volumes".equals(directory.getAbsolute())) {
                return parent;
            }
            parent = parent.getParent();
        }
        return super.getVolume();
    }

    public String getBookmark() {
        if (StringUtils.isBlank((CharSequence)this.bookmark)) {
            try {
                this.bookmark = resolver.create((Local)this);
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure resolving bookmark for %s. %s", new Object[]{this, e.getDetail()}));
            }
        }
        return this.bookmark;
    }

    public void setBookmark(String data) {
        this.bookmark = data;
    }

    public OutputStream getOutputStream(boolean append) throws AccessDeniedException {
        NSURL resolved;
        try {
            resolved = this.lock(false);
        }
        catch (LocalAccessDeniedException e) {
            return super.getOutputStream(append);
        }
        try {
            return new ProxyOutputStream(new FileOutputStream(new File(resolved.path()), append)){

                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        FinderLocal.this.release(resolved);
                    }
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new LocalAccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    public NSURL lock(boolean interactive) throws AccessDeniedException {
        NSURL resolved = (NSURL)resolver.resolve((Local)this, interactive);
        if (resolved.respondsToSelector(Foundation.selector((String)"startAccessingSecurityScopedResource")) && !resolved.startAccessingSecurityScopedResource()) {
            throw new LocalAccessDeniedException(String.format("Failure accessing security scoped resource for %s", new Object[]{this}));
        }
        return resolved;
    }

    public void release(Object lock) {
        if (null == lock) {
            return;
        }
        NSURL resolved = (NSURL)lock;
        if (resolved.respondsToSelector(Foundation.selector((String)"stopAccessingSecurityScopedResource"))) {
            resolved.stopAccessingSecurityScopedResource();
        }
    }

    public InputStream getInputStream() throws AccessDeniedException {
        NSURL resolved;
        try {
            resolved = this.lock(false);
        }
        catch (AccessDeniedException e) {
            return super.getInputStream();
        }
        try {
            return new ProxyInputStream((InputStream)new LocalRepeatableFileInputStream(new File(resolved.path()))){

                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        FinderLocal.this.release(resolved);
                    }
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new LocalAccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    private static String resolveAlias(String absolute) {
        if (PreferencesFactory.get().getBoolean("local.alias.resolve")) {
            return FinderLocal.resolveAliasNative(absolute);
        }
        return absolute;
    }

    private static native String resolveAliasNative(String var0);

    public FinderLocalAttributes attributes() {
        return this.attributes;
    }

    static {
        Native.load((String)"core");
        manager = NSFileManager.defaultManager();
        resolver = FilesystemBookmarkResolverFactory.get();
    }
}

