/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.PublicKeyContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class UserData {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="gender")
    private GenderEnum gender = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="expireAt")
    private Date expireAt = null;
    @JsonProperty(value="hasManageableRooms")
    private Boolean hasManageableRooms = null;
    @JsonProperty(value="isEncryptionEnabled")
    private Boolean isEncryptionEnabled = null;
    @JsonProperty(value="publicKeyContainer")
    private PublicKeyContainer publicKeyContainer = null;
    @JsonProperty(value="userRoles")
    private RoleList userRoles = null;
    @JsonProperty(value="userAttributes")
    private UserAttributes userAttributes = null;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = new ArrayList<UserAuthMethod>();

    public UserData id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserData login(String login) {
        this.login = login;
        return this;
    }

    @ApiModelProperty(required=true, value="Login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserData title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserData firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(required=true, value="First name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserData lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="Last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserData gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(value="Gender key, one of [m|f|n]")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public UserData email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(required=true, value="Email [NOT USED]")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserData lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="Lock status: 0 - Locked, 1 - Web access allowed, 2 - Web and mobile access allowed")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UserData expireAt(Date expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @ApiModelProperty(value="Account expiration date (2015-12-31T23:59:00)")
    public Date getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    public UserData hasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
        return this;
    }

    @ApiModelProperty(value="User has manageable rooms")
    public Boolean getHasManageableRooms() {
        return this.hasManageableRooms;
    }

    public void setHasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
    }

    public UserData isEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
        return this;
    }

    @ApiModelProperty(value="User has generated private key. Possible if <b>Triple-Crypt&trade; Technology</b> is active.")
    public Boolean getIsEncryptionEnabled() {
        return this.isEncryptionEnabled;
    }

    public void setIsEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
    }

    public UserData publicKeyContainer(PublicKeyContainer publicKeyContainer) {
        this.publicKeyContainer = publicKeyContainer;
        return this;
    }

    @ApiModelProperty(value="")
    public PublicKeyContainer getPublicKeyContainer() {
        return this.publicKeyContainer;
    }

    public void setPublicKeyContainer(PublicKeyContainer publicKeyContainer) {
        this.publicKeyContainer = publicKeyContainer;
    }

    public UserData userRoles(RoleList userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @ApiModelProperty(value="User assignment roles")
    public RoleList getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(RoleList userRoles) {
        this.userRoles = userRoles;
    }

    public UserData userAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    @ApiModelProperty(value="Custom user attributes; visible only with role user manager")
    public UserAttributes getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
    }

    public UserData authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public UserData addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Authentication methods")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserData userData = (UserData)o;
        return Objects.equals(this.id, userData.id) && Objects.equals(this.login, userData.login) && Objects.equals(this.title, userData.title) && Objects.equals(this.firstName, userData.firstName) && Objects.equals(this.lastName, userData.lastName) && Objects.equals((Object)this.gender, (Object)userData.gender) && Objects.equals(this.email, userData.email) && Objects.equals(this.lockStatus, userData.lockStatus) && Objects.equals(this.expireAt, userData.expireAt) && Objects.equals(this.hasManageableRooms, userData.hasManageableRooms) && Objects.equals(this.isEncryptionEnabled, userData.isEncryptionEnabled) && Objects.equals(this.publicKeyContainer, userData.publicKeyContainer) && Objects.equals(this.userRoles, userData.userRoles) && Objects.equals(this.userAttributes, userData.userAttributes) && Objects.equals(this.authMethods, userData.authMethods);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.login, this.title, this.firstName, this.lastName, this.gender, this.email, this.lockStatus, this.expireAt, this.hasManageableRooms, this.isEncryptionEnabled, this.publicKeyContainer, this.userRoles, this.userAttributes, this.authMethods});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    hasManageableRooms: ").append(this.toIndentedString(this.hasManageableRooms)).append("\n");
        sb.append("    isEncryptionEnabled: ").append(this.toIndentedString(this.isEncryptionEnabled)).append("\n");
        sb.append("    publicKeyContainer: ").append(this.toIndentedString(this.publicKeyContainer)).append("\n");
        sb.append("    userRoles: ").append(this.toIndentedString(this.userRoles)).append("\n");
        sb.append("    userAttributes: ").append(this.toIndentedString(this.userAttributes)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f"),
        N("n");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String text) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

