/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerAttributes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;

public class Customer {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="companyName")
    private String companyName = null;
    @JsonProperty(value="customerContractType")
    private CustomerContractTypeEnum customerContractType = null;
    @JsonProperty(value="activationCode")
    private String activationCode = null;
    @JsonProperty(value="trialDaysLeft")
    private Integer trialDaysLeft = null;
    @JsonProperty(value="providerCustomerId")
    private String providerCustomerId = null;
    @JsonProperty(value="quotaMax")
    private Long quotaMax = null;
    @JsonProperty(value="quotaUsed")
    private Long quotaUsed = null;
    @JsonProperty(value="userMax")
    private Integer userMax = null;
    @JsonProperty(value="userUsed")
    private Integer userUsed = null;
    @JsonProperty(value="lockStatus")
    private Boolean lockStatus = null;
    @JsonProperty(value="createdAt")
    private Date createdAt = null;
    @JsonProperty(value="updatedAt")
    private Date updatedAt = null;
    @JsonProperty(value="lastLoginAt")
    private Date lastLoginAt = null;
    @JsonProperty(value="customerAttributes")
    private CustomerAttributes customerAttributes = null;

    public Customer id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the customer")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Customer companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(required=true, value="Company name")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Customer customerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
        return this;
    }

    @ApiModelProperty(required=true, value="Customer contract type.")
    public CustomerContractTypeEnum getCustomerContractType() {
        return this.customerContractType;
    }

    public void setCustomerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
    }

    public Customer activationCode(String activationCode) {
        this.activationCode = activationCode;
        return this;
    }

    @ApiModelProperty(value="Customer activation code string, valid only for types free and demo, for pay customers it is empty")
    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public Customer trialDaysLeft(Integer trialDaysLeft) {
        this.trialDaysLeft = trialDaysLeft;
        return this;
    }

    @ApiModelProperty(value="Number of days, left for the trial period. Relevant only for type demo.")
    public Integer getTrialDaysLeft() {
        return this.trialDaysLeft;
    }

    public void setTrialDaysLeft(Integer trialDaysLeft) {
        this.trialDaysLeft = trialDaysLeft;
    }

    public Customer providerCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
        return this;
    }

    @ApiModelProperty(value="Provider customer ID value, relevant only for type 'pay'")
    public String getProviderCustomerId() {
        return this.providerCustomerId;
    }

    public void setProviderCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
    }

    public Customer quotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal disc space which can be allocated by customer in bytes")
    public Long getQuotaMax() {
        return this.quotaMax;
    }

    public void setQuotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
    }

    public Customer quotaUsed(Long quotaUsed) {
        this.quotaUsed = quotaUsed;
        return this;
    }

    @ApiModelProperty(required=true, value="Used amount of disc space in bytes")
    public Long getQuotaUsed() {
        return this.quotaUsed;
    }

    public void setQuotaUsed(Long quotaUsed) {
        this.quotaUsed = quotaUsed;
    }

    public Customer userMax(Integer userMax) {
        this.userMax = userMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal number of users")
    public Integer getUserMax() {
        return this.userMax;
    }

    public void setUserMax(Integer userMax) {
        this.userMax = userMax;
    }

    public Customer userUsed(Integer userUsed) {
        this.userUsed = userUsed;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of users which are already allocated")
    public Integer getUserUsed() {
        return this.userUsed;
    }

    public void setUserUsed(Integer userUsed) {
        this.userUsed = userUsed;
    }

    public Customer lockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="Lock status: false - Unlocked, true - Locked. All users of this customer will be blocked and can not login anymore")
    public Boolean getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
    }

    public Customer createdAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Creation date (2015-12-31T23:59:00)")
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Customer updatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="Modification date (2015-12-31T23:59:00)")
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Customer lastLoginAt(Date lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
        return this;
    }

    @ApiModelProperty(value="The date of the last login seen in the customer (2015-12-31T23:59:00)")
    public Date getLastLoginAt() {
        return this.lastLoginAt;
    }

    public void setLastLoginAt(Date lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    public Customer customerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
        return this;
    }

    @ApiModelProperty(value="Customer Attributes")
    public CustomerAttributes getCustomerAttributes() {
        return this.customerAttributes;
    }

    public void setCustomerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return Objects.equals(this.id, customer.id) && Objects.equals(this.companyName, customer.companyName) && Objects.equals((Object)this.customerContractType, (Object)customer.customerContractType) && Objects.equals(this.activationCode, customer.activationCode) && Objects.equals(this.trialDaysLeft, customer.trialDaysLeft) && Objects.equals(this.providerCustomerId, customer.providerCustomerId) && Objects.equals(this.quotaMax, customer.quotaMax) && Objects.equals(this.quotaUsed, customer.quotaUsed) && Objects.equals(this.userMax, customer.userMax) && Objects.equals(this.userUsed, customer.userUsed) && Objects.equals(this.lockStatus, customer.lockStatus) && Objects.equals(this.createdAt, customer.createdAt) && Objects.equals(this.updatedAt, customer.updatedAt) && Objects.equals(this.lastLoginAt, customer.lastLoginAt) && Objects.equals(this.customerAttributes, customer.customerAttributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.companyName, this.customerContractType, this.activationCode, this.trialDaysLeft, this.providerCustomerId, this.quotaMax, this.quotaUsed, this.userMax, this.userUsed, this.lockStatus, this.createdAt, this.updatedAt, this.lastLoginAt, this.customerAttributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Customer {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    customerContractType: ").append(this.toIndentedString((Object)this.customerContractType)).append("\n");
        sb.append("    activationCode: ").append(this.toIndentedString(this.activationCode)).append("\n");
        sb.append("    trialDaysLeft: ").append(this.toIndentedString(this.trialDaysLeft)).append("\n");
        sb.append("    providerCustomerId: ").append(this.toIndentedString(this.providerCustomerId)).append("\n");
        sb.append("    quotaMax: ").append(this.toIndentedString(this.quotaMax)).append("\n");
        sb.append("    quotaUsed: ").append(this.toIndentedString(this.quotaUsed)).append("\n");
        sb.append("    userMax: ").append(this.toIndentedString(this.userMax)).append("\n");
        sb.append("    userUsed: ").append(this.toIndentedString(this.userUsed)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    lastLoginAt: ").append(this.toIndentedString(this.lastLoginAt)).append("\n");
        sb.append("    customerAttributes: ").append(this.toIndentedString(this.customerAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomerContractTypeEnum {
        PAY("pay"),
        FREE("free"),
        DEMO("demo");

        private String value;

        private CustomerContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomerContractTypeEnum fromValue(String text) {
            for (CustomerContractTypeEnum b : CustomerContractTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

