/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class ActiveDirectoryConfig {
    @JsonProperty(value="id")
    private Integer id = null;
    @JsonProperty(value="alias")
    private String alias = null;
    @JsonProperty(value="serverIp")
    private String serverIp = null;
    @JsonProperty(value="serverPort")
    private Integer serverPort = null;
    @JsonProperty(value="serverAdminName")
    private String serverAdminName = null;
    @JsonProperty(value="serverAdminPassword")
    private String serverAdminPassword = null;
    @JsonProperty(value="ldapUsersDomain")
    private String ldapUsersDomain = null;
    @JsonProperty(value="userFilter")
    private String userFilter = null;
    @JsonProperty(value="userImport")
    private Boolean userImport = null;
    @JsonProperty(value="adExportGroup")
    private String adExportGroup = null;
    @JsonProperty(value="sdsImportGroup")
    private Long sdsImportGroup = null;
    @JsonProperty(value="createHomeFolder")
    private Boolean createHomeFolder = null;
    @JsonProperty(value="homeFolderParent")
    private Long homeFolderParent = null;
    @JsonProperty(value="useLdaps")
    private Boolean useLdaps = null;
    @JsonProperty(value="sslFingerPrint")
    private String sslFingerPrint = null;

    public ActiveDirectoryConfig id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public ActiveDirectoryConfig alias(String alias) {
        this.alias = alias;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique name for an active directory configuration")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ActiveDirectoryConfig serverIp(String serverIp) {
        this.serverIp = serverIp;
        return this;
    }

    @ApiModelProperty(required=true, value="IPv4 or IPv6 address or host name")
    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public ActiveDirectoryConfig serverPort(Integer serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    @ApiModelProperty(required=true, value="Port")
    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public ActiveDirectoryConfig serverAdminName(String serverAdminName) {
        this.serverAdminName = serverAdminName;
        return this;
    }

    @ApiModelProperty(required=true, value="DistinguishedName of Active Directory administrative account")
    public String getServerAdminName() {
        return this.serverAdminName;
    }

    public void setServerAdminName(String serverAdminName) {
        this.serverAdminName = serverAdminName;
    }

    public ActiveDirectoryConfig serverAdminPassword(String serverAdminPassword) {
        this.serverAdminPassword = serverAdminPassword;
        return this;
    }

    @ApiModelProperty(value="Password of Active Directory administrative account")
    public String getServerAdminPassword() {
        return this.serverAdminPassword;
    }

    public void setServerAdminPassword(String serverAdminPassword) {
        this.serverAdminPassword = serverAdminPassword;
    }

    public ActiveDirectoryConfig ldapUsersDomain(String ldapUsersDomain) {
        this.ldapUsersDomain = ldapUsersDomain;
        return this;
    }

    @ApiModelProperty(required=true, value="Search scope of Active Directory; only users below this node can log on.")
    public String getLdapUsersDomain() {
        return this.ldapUsersDomain;
    }

    public void setLdapUsersDomain(String ldapUsersDomain) {
        this.ldapUsersDomain = ldapUsersDomain;
    }

    public ActiveDirectoryConfig userFilter(String userFilter) {
        this.userFilter = userFilter;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of Active Directory attribute that is used as login name")
    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public ActiveDirectoryConfig userImport(Boolean userImport) {
        this.userImport = userImport;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines if an SDS account is automatically created for a new user who successfully logs on with his/her AD account,")
    public Boolean getUserImport() {
        return this.userImport;
    }

    public void setUserImport(Boolean userImport) {
        this.userImport = userImport;
    }

    public ActiveDirectoryConfig adExportGroup(String adExportGroup) {
        this.adExportGroup = adExportGroup;
        return this;
    }

    @ApiModelProperty(required=true, value="If ad_userimport is set to true, a user must be member of this Active Directory group to receive a newly created SDS account.")
    public String getAdExportGroup() {
        return this.adExportGroup;
    }

    public void setAdExportGroup(String adExportGroup) {
        this.adExportGroup = adExportGroup;
    }

    public ActiveDirectoryConfig sdsImportGroup(Long sdsImportGroup) {
        this.sdsImportGroup = sdsImportGroup;
        return this;
    }

    @ApiModelProperty(value="User group that is assigned to users who are created by automatic import.")
    public Long getSdsImportGroup() {
        return this.sdsImportGroup;
    }

    public void setSdsImportGroup(Long sdsImportGroup) {
        this.sdsImportGroup = sdsImportGroup;
    }

    public ActiveDirectoryConfig createHomeFolder(Boolean createHomeFolder) {
        this.createHomeFolder = createHomeFolder;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether a room is created for each user that is created by automatic import (Like a home folder). The room's name will equal the user's login name.")
    public Boolean getCreateHomeFolder() {
        return this.createHomeFolder;
    }

    public void setCreateHomeFolder(Boolean createHomeFolder) {
        this.createHomeFolder = createHomeFolder;
    }

    public ActiveDirectoryConfig homeFolderParent(Long homeFolderParent) {
        this.homeFolderParent = homeFolderParent;
        return this;
    }

    @ApiModelProperty(value="ID of the Data Room in which the individual rooms for users will be created (cf. 'ad_create_home_folder_on').")
    public Long getHomeFolderParent() {
        return this.homeFolderParent;
    }

    public void setHomeFolderParent(Long homeFolderParent) {
        this.homeFolderParent = homeFolderParent;
    }

    public ActiveDirectoryConfig useLdaps(Boolean useLdaps) {
        this.useLdaps = useLdaps;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines whether LDAPS should be used instead of plain LDAP.")
    public Boolean getUseLdaps() {
        return this.useLdaps;
    }

    public void setUseLdaps(Boolean useLdaps) {
        this.useLdaps = useLdaps;
    }

    public ActiveDirectoryConfig sslFingerPrint(String sslFingerPrint) {
        this.sslFingerPrint = sslFingerPrint;
        return this;
    }

    @ApiModelProperty(value="SSL finger print of Active Directory server.  Mandatory for LDAPS connections. Format: [Algorithm/FingerPrint]")
    public String getSslFingerPrint() {
        return this.sslFingerPrint;
    }

    public void setSslFingerPrint(String sslFingerPrint) {
        this.sslFingerPrint = sslFingerPrint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveDirectoryConfig activeDirectoryConfig = (ActiveDirectoryConfig)o;
        return Objects.equals(this.id, activeDirectoryConfig.id) && Objects.equals(this.alias, activeDirectoryConfig.alias) && Objects.equals(this.serverIp, activeDirectoryConfig.serverIp) && Objects.equals(this.serverPort, activeDirectoryConfig.serverPort) && Objects.equals(this.serverAdminName, activeDirectoryConfig.serverAdminName) && Objects.equals(this.serverAdminPassword, activeDirectoryConfig.serverAdminPassword) && Objects.equals(this.ldapUsersDomain, activeDirectoryConfig.ldapUsersDomain) && Objects.equals(this.userFilter, activeDirectoryConfig.userFilter) && Objects.equals(this.userImport, activeDirectoryConfig.userImport) && Objects.equals(this.adExportGroup, activeDirectoryConfig.adExportGroup) && Objects.equals(this.sdsImportGroup, activeDirectoryConfig.sdsImportGroup) && Objects.equals(this.createHomeFolder, activeDirectoryConfig.createHomeFolder) && Objects.equals(this.homeFolderParent, activeDirectoryConfig.homeFolderParent) && Objects.equals(this.useLdaps, activeDirectoryConfig.useLdaps) && Objects.equals(this.sslFingerPrint, activeDirectoryConfig.sslFingerPrint);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.alias, this.serverIp, this.serverPort, this.serverAdminName, this.serverAdminPassword, this.ldapUsersDomain, this.userFilter, this.userImport, this.adExportGroup, this.sdsImportGroup, this.createHomeFolder, this.homeFolderParent, this.useLdaps, this.sslFingerPrint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActiveDirectoryConfig {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    serverIp: ").append(this.toIndentedString(this.serverIp)).append("\n");
        sb.append("    serverPort: ").append(this.toIndentedString(this.serverPort)).append("\n");
        sb.append("    serverAdminName: ").append(this.toIndentedString(this.serverAdminName)).append("\n");
        sb.append("    serverAdminPassword: ").append(this.toIndentedString(this.serverAdminPassword)).append("\n");
        sb.append("    ldapUsersDomain: ").append(this.toIndentedString(this.ldapUsersDomain)).append("\n");
        sb.append("    userFilter: ").append(this.toIndentedString(this.userFilter)).append("\n");
        sb.append("    userImport: ").append(this.toIndentedString(this.userImport)).append("\n");
        sb.append("    adExportGroup: ").append(this.toIndentedString(this.adExportGroup)).append("\n");
        sb.append("    sdsImportGroup: ").append(this.toIndentedString(this.sdsImportGroup)).append("\n");
        sb.append("    createHomeFolder: ").append(this.toIndentedString(this.createHomeFolder)).append("\n");
        sb.append("    homeFolderParent: ").append(this.toIndentedString(this.homeFolderParent)).append("\n");
        sb.append("    useLdaps: ").append(this.toIndentedString(this.useLdaps)).append("\n");
        sb.append("    sslFingerPrint: ").append(this.toIndentedString(this.sslFingerPrint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

