/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.ChangeUserPasswordRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerData;
import ch.cyberduck.core.sds.io.swagger.client.model.EnableCustomerEncryptionRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.OAuthAuthorization;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateUserAccountRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAccount;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class UserApi {
    private ApiClient apiClient;

    public UserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void changeUserPassword(String xSdsAuthToken, ChangeUserPasswordRequest body) throws ApiException {
        ChangeUserPasswordRequest localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling changeUserPassword");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling changeUserPassword");
        }
        String localVarPath = "/user/account/password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteOAuthAuthorization(String xSdsAuthToken, String clientId) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling deleteOAuthAuthorization");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling deleteOAuthAuthorization");
        }
        String localVarPath = "/user/oauth/authorizations/{client_id}".replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteUserKeyPair(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling deleteUserKeyPair");
        }
        String localVarPath = "/user/account/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CustomerData enableCustomerEncryption(String xSdsAuthToken, EnableCustomerEncryptionRequest body) throws ApiException {
        EnableCustomerEncryptionRequest localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling enableCustomerEncryption");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling enableCustomerEncryption");
        }
        String localVarPath = "/user/account/customer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomerData> localVarReturnType = new GenericType<CustomerData>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomerData getCustomerInfo(String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getCustomerInfo");
        }
        String localVarPath = "/user/account/customer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CustomerData> localVarReturnType = new GenericType<CustomerData>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserKeyPairContainer getCustomerKeyPair(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getCustomerKeyPair");
        }
        String localVarPath = "/user/account/customer/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserKeyPairContainer> localVarReturnType = new GenericType<UserKeyPairContainer>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuthAuthorization> getOAuthAuthorizations(String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getOAuthAuthorizations");
        }
        String localVarPath = "/user/oauth/authorizations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<OAuthAuthorization>> localVarReturnType = new GenericType<List<OAuthAuthorization>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserAccount getUserInfo(String xSdsAuthToken, String xSdsDateFormat, Boolean moreInfo) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getUserInfo");
        }
        String localVarPath = "/user/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "more_info", moreInfo));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserAccount> localVarReturnType = new GenericType<UserAccount>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserKeyPairContainer getUserKeyPair(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getUserKeyPair");
        }
        String localVarPath = "/user/account/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserKeyPairContainer> localVarReturnType = new GenericType<UserKeyPairContainer>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void setUserKeyPair(String xSdsAuthToken, UserKeyPairContainer body) throws ApiException {
        UserKeyPairContainer localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling setUserKeyPair");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setUserKeyPair");
        }
        String localVarPath = "/user/account/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UserAccount updateUserAccount(String xSdsAuthToken, UpdateUserAccountRequest body, String xSdsDateFormat) throws ApiException {
        UpdateUserAccountRequest localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling updateUserAccount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateUserAccount");
        }
        String localVarPath = "/user/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<UserAccount> localVarReturnType = new GenericType<UserAccount>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void userLogout(String xSdsAuthToken, Boolean everywhere) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling userLogout");
        }
        String localVarPath = "/user/logout";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "everywhere", everywhere));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

