/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.ActiveDirectoryAuthInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.BrandingServerInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.ChunkUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateShareUploadChannelRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateShareUploadChannelResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.OpenIdAuthInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicDownloadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicDownloadTokenGenerateRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicDownloadTokenGenerateResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicUploadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicUploadedFileData;
import ch.cyberduck.core.sds.io.swagger.client.model.SdsServerTime;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.io.swagger.client.model.SystemInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.UserFileKeyList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class PublicApi {
    private ApiClient apiClient;

    public PublicApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PublicApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelShareUpload(String accessKey, String uploadId) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling cancelShareUpload");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling cancelShareUpload");
        }
        String localVarPath = "/public/shares/uploads/{access_key}/{upload_id}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PublicUploadedFileData completeShareUpload(String accessKey, String uploadId, UserFileKeyList userFileKeyList) throws ApiException {
        UserFileKeyList localVarPostBody = userFileKeyList;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling completeShareUpload");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling completeShareUpload");
        }
        String localVarPath = "/public/shares/uploads/{access_key}/{upload_id}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicUploadedFileData> localVarReturnType = new GenericType<PublicUploadedFileData>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PublicDownloadTokenGenerateResponse createPublicDownloadShareToken(String accessKey, PublicDownloadTokenGenerateRequest body) throws ApiException {
        PublicDownloadTokenGenerateRequest localVarPostBody = body;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling createPublicDownloadShareToken");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPublicDownloadShareToken");
        }
        String localVarPath = "/public/shares/downloads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicDownloadTokenGenerateResponse> localVarReturnType = new GenericType<PublicDownloadTokenGenerateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateShareUploadChannelResponse createShareUpload(String accessKey, CreateShareUploadChannelRequest body) throws ApiException {
        CreateShareUploadChannelRequest localVarPostBody = body;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling createShareUpload");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createShareUpload");
        }
        String localVarPath = "/public/shares/uploads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CreateShareUploadChannelResponse> localVarReturnType = new GenericType<CreateShareUploadChannelResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ActiveDirectoryAuthInfo getActiveDirectoryAuthInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/public/system/info/auth/ad";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ActiveDirectoryAuthInfo> localVarReturnType = new GenericType<ActiveDirectoryAuthInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BrandingServerInfo getBrandingServerInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/public/branding/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<BrandingServerInfo> localVarReturnType = new GenericType<BrandingServerInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OpenIdAuthInfo getOpenIdAuthInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/public/system/info/auth/openid";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OpenIdAuthInfo> localVarReturnType = new GenericType<OpenIdAuthInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PublicDownloadShare getPublicDownloadShare(String accessKey, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling getPublicDownloadShare");
        }
        String localVarPath = "/public/shares/downloads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicDownloadShare> localVarReturnType = new GenericType<PublicDownloadShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Object getPublicFileData(String accessKey, String token, String range, Boolean genericMimetype) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling getPublicFileData");
        }
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling getPublicFileData");
        }
        String localVarPath = "/public/shares/downloads/{access_key}/{token}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "generic_mimetype", genericMimetype));
        if (range != null) {
            localVarHeaderParams.put("Range", this.apiClient.parameterToString(range));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getPublicFileDataHead(String accessKey, String token, Boolean genericMimetype) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling getPublicFileDataHead");
        }
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling getPublicFileDataHead");
        }
        String localVarPath = "/public/shares/downloads/{access_key}/{token}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "generic_mimetype", genericMimetype));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PublicUploadShare getPublicUploadShare(String accessKey, String xSdsSharePassword, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling getPublicUploadShare");
        }
        String localVarPath = "/public/shares/uploads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsSharePassword != null) {
            localVarHeaderParams.put("X-Sds-Share-Password", this.apiClient.parameterToString(xSdsSharePassword));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicUploadShare> localVarReturnType = new GenericType<PublicUploadShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SdsServerTime getSdsServerTime(String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/public/time";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SdsServerTime> localVarReturnType = new GenericType<SdsServerTime>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SoftwareVersionData getSoftwareVersion(String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/public/software/version";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SoftwareVersionData> localVarReturnType = new GenericType<SoftwareVersionData>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SystemInfo getSystemInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/public/system/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SystemInfo> localVarReturnType = new GenericType<SystemInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkUploadResponse uploadShare(String accessKey, String uploadId, File file, String xSdsDateFormat, String contentRange) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling uploadShare");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling uploadShare");
        }
        if (file == null) {
            throw new ApiException(400, "Missing the required parameter 'file' when calling uploadShare");
        }
        String localVarPath = "/public/shares/uploads/{access_key}/{upload_id}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (contentRange != null) {
            localVarHeaderParams.put("Content-Range", this.apiClient.parameterToString(contentRange));
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ChunkUploadResponse> localVarReturnType = new GenericType<ChunkUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

