/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public class SDSReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(SDSReadFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSReadFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            SDSApiClient client = (SDSApiClient)this.session.getClient();
            HttpGet request = new HttpGet(String.format("%s/nodes/files/%s/downloads", client.getBasePath(), this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())));
            request.addHeader("X-Sds-Auth-Token", "");
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Add range header %s for file %s", header, file));
                }
                request.addHeader((Header)new BasicHeader("Range", header));
                request.addHeader((Header)new BasicHeader("Accept-Encoding", "identity"));
            }
            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 206: {
                    return new HttpMethodReleaseInputStream((HttpResponse)response);
                }
            }
            throw new HttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) throws BackgroundException {
        return true;
    }
}

