/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.exception.ExpiredTokenException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.AuthApi;
import ch.cyberduck.core.sds.io.swagger.client.model.LoginRequest;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SDSErrorResponseInterceptor
extends DisabledServiceUnavailableRetryStrategy
implements HttpRequestInterceptor {
    private static final Logger log = Logger.getLogger(SDSErrorResponseInterceptor.class);
    private static final int MAX_RETRIES = 1;
    private final SDSSession session;
    private String user = "";
    private String password = "";
    private String token = "";

    public SDSErrorResponseInterceptor(SDSSession session) {
        this.session = session;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount > 1) break;
                try {
                    EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                    ApiException failure = new ApiException(response.getStatusLine().getStatusCode(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity()));
                    if (new SDSExceptionMappingService().map(failure) instanceof ExpiredTokenException) {
                        try {
                            this.token = new AuthApi((ApiClient)this.session.getClient()).login(new LoginRequest().authType(this.session.getHost().getProtocol().getAuthorization()).login(this.user).password(this.password)).getToken();
                            return true;
                        }
                        catch (ApiException e) {
                            log.warn((Object)String.format("Attempt to renew expired auth token failed. %s", e.getMessage()));
                            return false;
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    log.warn((Object)String.format("Failure parsing response entity from %s", response));
                    return false;
                }
            }
        }
        return false;
    }

    public void setTokens(String user, String password, String token) {
        this.user = user;
        this.password = password;
        this.token = token;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (StringUtils.isNotBlank((CharSequence)this.token)) {
            request.removeHeaders("X-Sds-Auth-Token");
            request.addHeader("X-Sds-Auth-Token", this.token);
        }
    }
}

