/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.InteractiveTerminalPromptReader;
import ch.cyberduck.cli.TerminalPromptReader;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.SSHFingerprintGenerator;
import ch.cyberduck.core.sftp.openssh.OpenSSHHostKeyVerifier;
import java.security.Key;
import java.security.PublicKey;
import java.text.MessageFormat;
import net.schmizz.sshj.common.KeyType;

public class TerminalHostKeyVerifier
extends OpenSSHHostKeyVerifier {
    private final TerminalPromptReader prompt;

    public TerminalHostKeyVerifier() {
        this(new InteractiveTerminalPromptReader());
    }

    public TerminalHostKeyVerifier(TerminalPromptReader prompt) {
        super(LocalFactory.get(PreferencesFactory.get().getProperty("ssh.knownhosts")).withBookmark(PreferencesFactory.get().getProperty("ssh.knownhosts.bookmark")));
        this.prompt = prompt;
    }

    protected boolean isUnknownKeyAccepted(String hostname, PublicKey key) throws ConnectionCanceledException, ChecksumException {
        String message = String.format("%s. %s %s?", LocaleFactory.localizedString("Unknown fingerprint", "Sftp"), MessageFormat.format(LocaleFactory.localizedString("The fingerprint for the {1} key sent by the server is {0}.", "Sftp"), new SSHFingerprintGenerator().fingerprint(key), KeyType.fromKey((Key)key).name()), LocaleFactory.localizedString("Continue", "Credentials"));
        if (!this.prompt.prompt(message)) {
            throw new ConnectionCanceledException();
        }
        this.allow(hostname, key, true);
        return true;
    }

    protected boolean isChangedKeyAccepted(String hostname, PublicKey key) throws ConnectionCanceledException, ChecksumException {
        String message = String.format("%s. %s %s?", LocaleFactory.localizedString("Changed fingerprint", "Sftp"), MessageFormat.format(LocaleFactory.localizedString("The fingerprint for the {1} key sent by the server is {0}.", "Sftp"), new SSHFingerprintGenerator().fingerprint(key), KeyType.fromKey((Key)key).name()), LocaleFactory.localizedString("Continue", "Credentials"));
        if (!this.prompt.prompt(message)) {
            throw new ConnectionCanceledException();
        }
        this.allow(hostname, key, true);
        return true;
    }
}

