/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordTokenRequest
extends TokenRequest {
    @Key
    private String username;
    @Key
    private String password;

    public PasswordTokenRequest(HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, String username, String password) {
        super(transport, jsonFactory, tokenServerUrl, "password");
        this.setUsername(username);
        this.setPassword(password);
    }

    @Override
    public PasswordTokenRequest setRequestInitializer(HttpRequestInitializer requestInitializer) {
        return (PasswordTokenRequest)super.setRequestInitializer(requestInitializer);
    }

    @Override
    public PasswordTokenRequest setTokenServerUrl(GenericUrl tokenServerUrl) {
        return (PasswordTokenRequest)super.setTokenServerUrl(tokenServerUrl);
    }

    @Override
    public PasswordTokenRequest setScopes(Collection<String> scopes) {
        return (PasswordTokenRequest)super.setScopes(scopes);
    }

    @Override
    public PasswordTokenRequest setGrantType(String grantType) {
        return (PasswordTokenRequest)super.setGrantType(grantType);
    }

    @Override
    public PasswordTokenRequest setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
        return (PasswordTokenRequest)super.setClientAuthentication(clientAuthentication);
    }

    public final String getUsername() {
        return this.username;
    }

    public PasswordTokenRequest setUsername(String username) {
        this.username = (String)Preconditions.checkNotNull((Object)username);
        return this;
    }

    public final String getPassword() {
        return this.password;
    }

    public PasswordTokenRequest setPassword(String password) {
        this.password = (String)Preconditions.checkNotNull((Object)password);
        return this;
    }

    @Override
    public PasswordTokenRequest set(String fieldName, Object value) {
        return (PasswordTokenRequest)super.set(fieldName, value);
    }
}

