/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class L33tSubsEnumerator {
    private final Map<Character, Character[]> table;
    private List<ArrayList<Character[]>> subs;

    L33tSubsEnumerator(Map<Character, Character[]> table) {
        this.table = table;
        this.subs = new ArrayList<ArrayList<Character[]>>();
        this.subs.add(new ArrayList());
    }

    List<Map<Character, Character>> enumerate() {
        Character[] keys = this.table.keySet().toArray(new Character[0]);
        this.helper(keys);
        ArrayList<Map<Character, Character>> subDicts = new ArrayList<Map<Character, Character>>();
        for (ArrayList<Character[]> sub : this.subs) {
            HashMap<Character, Character> subDict = new HashMap<Character, Character>();
            for (Character[] ref : sub) {
                subDict.put(ref[0], ref[1]);
            }
            subDicts.add(subDict);
        }
        return subDicts;
    }

    private List<ArrayList<Character[]>> dedup(List<ArrayList<Character[]>> subs) {
        ArrayList<ArrayList<Character[]>> deduped = new ArrayList<ArrayList<Character[]>>();
        HashMap<String, Boolean> members = new HashMap<String, Boolean>();
        for (ArrayList<Character[]> sub : subs) {
            HashMap<Integer, Character[]> assoc = new HashMap<Integer, Character[]>();
            for (int i = 0; i < sub.size(); ++i) {
                assoc.put(i, sub.get(i));
            }
            ArrayList<String> strings = new ArrayList<String>();
            for (Map.Entry entry : assoc.entrySet()) {
                strings.add(entry.getValue() + "," + entry.getKey());
            }
            StringBuilder builder = new StringBuilder();
            for (String str : strings) {
                builder.append(str).append("-");
            }
            String string = builder.substring(0, builder.length() - 1);
            if (members.containsKey(string)) continue;
            members.put(string, true);
            deduped.add(sub);
        }
        return deduped;
    }

    private void helper(Character[] keys) {
        if (keys.length == 0) {
            return;
        }
        Character firstKey = keys[0];
        ArrayList<Character> restKeys = new ArrayList<Character>();
        for (int i = 1; i < keys.length; ++i) {
            restKeys.add(keys[i]);
        }
        ArrayList<ArrayList<Character[]>> nextSubs = new ArrayList<ArrayList<Character[]>>();
        for (Character l33tChr : this.table.get(firstKey)) {
            for (ArrayList<Character[]> sub : this.subs) {
                int dupL33tIndex = -1;
                for (int i = 0; i < sub.size(); ++i) {
                    if (sub.get(i)[0] != l33tChr) continue;
                    dupL33tIndex = i;
                    break;
                }
                if (dupL33tIndex == -1) {
                    ArrayList<Character[]> subExtension = new ArrayList<Character[]>(sub);
                    subExtension.add(new Character[]{l33tChr, firstKey});
                    nextSubs.add(subExtension);
                    continue;
                }
                ArrayList<Character[]> subAlternative = new ArrayList<Character[]>(sub);
                subAlternative.remove(dupL33tIndex);
                subAlternative.add(new Character[]{l33tChr, firstKey});
                nextSubs.add(sub);
                nextSubs.add(subAlternative);
            }
        }
        this.subs = this.dedup(nextSubs);
        this.helper(restKeys.toArray(new Character[0]));
    }
}

