/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoDeleteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.transfer.TransferStatus;

public class CryptoMoveFeature
implements Move {
    private final Session<?> session;
    private final Move proxy;
    private final Vault vault;

    public CryptoMoveFeature(Session<?> session, Move delegate, Delete delete, CryptoVault cryptomator) {
        this.session = session;
        this.proxy = delegate.withDelete((Delete)new CryptoDeleteFeature(session, delete, cryptomator));
        this.vault = cryptomator;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path target = this.proxy.move(this.vault.encrypt(this.session, file, file.isDirectory()), this.vault.encrypt(this.session, renamed, file.isDirectory()), status, callback, connectionCallback);
        return this.vault.decrypt(this.session, target);
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return this.proxy.isSupported(source, target);
    }

    public Move withDelete(Delete delete) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

