/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;

public class CryptoLifecycleFeature
implements Lifecycle {
    private final Session<?> session;
    private final Lifecycle delegate;
    private final Vault vault;

    public CryptoLifecycleFeature(Session<?> session, Lifecycle delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public LifecycleConfiguration getConfiguration(Path container) throws BackgroundException {
        return this.delegate.getConfiguration(this.vault.encrypt(this.session, container));
    }

    public void setConfiguration(Path container, LifecycleConfiguration configuration) throws BackgroundException {
        this.delegate.setConfiguration(this.vault.encrypt(this.session, container), configuration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoLifecycleFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

