/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import java.util.Set;
import org.apache.log4j.Logger;

public final class CryptoPathCache
implements Cache<Path> {
    private static final Logger log = Logger.getLogger(CryptoPathCache.class);
    private final Cache<Path> delegate;

    public CryptoPathCache(Cache<Path> delegate) {
        this.delegate = delegate;
    }

    public boolean isValid(Path file) {
        return this.delegate.isValid((Referenceable)this.toDecrypted(file));
    }

    public CacheReference key(Path object) {
        return this.delegate.key((Referenceable)object);
    }

    public boolean isCached(Path folder) {
        return this.delegate.isCached((Referenceable)this.toDecrypted(folder));
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public AttributedList<Path> put(Path folder, AttributedList<Path> encrypted) {
        AttributedList list = new AttributedList();
        for (int i = 0; i < encrypted.size(); ++i) {
            Path f = (Path)encrypted.get(i);
            list.add(i, (Referenceable)this.toDecrypted(f));
        }
        return this.delegate.put((Referenceable)this.toDecrypted(folder), list);
    }

    public AttributedList<Path> get(Path folder) {
        AttributedList decrypted = this.delegate.get((Referenceable)this.toDecrypted(folder));
        AttributedList list = new AttributedList();
        for (int i = 0; i < decrypted.size(); ++i) {
            Path f = (Path)decrypted.get(i);
            if (f.getType().contains(AbstractPath.Type.decrypted)) {
                list.add(i, (Referenceable)this.toEncrypted(f));
                continue;
            }
            list.add(i, (Referenceable)f);
        }
        return list;
    }

    public AttributedList<Path> remove(Path folder) {
        return this.delegate.remove((Referenceable)this.toDecrypted(folder));
    }

    public Set<Path> keySet() {
        return this.delegate.keySet();
    }

    public void invalidate(Path folder) {
        this.delegate.invalidate((Referenceable)this.toDecrypted(folder));
    }

    private Path toDecrypted(Path file) {
        if (file.getType().contains(AbstractPath.Type.encrypted)) {
            if (null == file.attributes().getDecrypted()) {
                log.error((Object)String.format("Missing decrypted reference for %s", file));
            }
            return file.attributes().getDecrypted();
        }
        return file;
    }

    private Path toEncrypted(Path file) {
        if (file.getType().contains(AbstractPath.Type.decrypted)) {
            if (null == file.attributes().getEncrypted()) {
                log.error((Object)String.format("Missing encrypted reference for %s", file));
            }
            return file.attributes().getEncrypted();
        }
        return file;
    }

    public void clear() {
        this.delegate.clear();
    }

    public Path lookup(CacheReference<Path> reference) {
        return (Path)this.delegate.lookup(reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoPathCache{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

