/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDrivePatchOperation;
import org.nuxeo.onedrive.client.facets.Facet;
import org.nuxeo.onedrive.client.facets.FileSystemInfoFacet;

public class OneDriveTimestampFeature
extends DefaultTimestampFeature {
    private final OneDriveSession session;

    public OneDriveTimestampFeature(OneDriveSession session) {
        this.session = session;
    }

    public void setTimestamp(Path file, Long modified) throws BackgroundException {
        OneDrivePatchOperation patch = new OneDrivePatchOperation();
        FileSystemInfoFacet info = new FileSystemInfoFacet();
        info.setLastModifiedDateTime(Instant.ofEpochMilli(modified).atOffset(ZoneOffset.UTC));
        patch.facet("fileSystemInfo", (Facet)info);
        try {
            this.session.toFile(file).patch(patch);
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to write attributes of {0}", (Throwable)e, file);
        }
    }
}

