/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.io.IOException;
import java.util.List;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public class OneDriveDeleteFeature
implements Delete {
    private final PathContainerService containerService = new PathContainerService();
    private final OneDriveSession session;

    public OneDriveDeleteFeature(OneDriveSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            if (this.containerService.isContainer(file)) continue;
            callback.delete(file);
            try {
                this.session.toFile(file).delete();
            }
            catch (OneDriveAPIException e) {
                throw new OneDriveExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return !this.containerService.isContainer(file);
    }

    public boolean isRecursive() {
        return true;
    }
}

