/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class DriveWriteFeature
extends AbstractHttpWriteFeature<Void>
implements Write<Void> {
    private final DriveSession session;
    private final DriveFileidProvider fileid;
    private final Find finder;
    private final AttributesFinder attributes;

    public DriveWriteFeature(DriveSession session, DriveFileidProvider fileid) {
        this(session, fileid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public DriveWriteFeature(DriveSession session, DriveFileidProvider fileid, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.fileid = fileid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public HttpResponseOutputStream<Void> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<Void> command = new DelayedHttpEntityCallable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public Void call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    block21: {
                        base = ((Drive)DriveWriteFeature.access$000(DriveWriteFeature.this).getClient()).getRootUrl();
                        if (status.isExists()) {
                            fileid = DriveWriteFeature.access$100(DriveWriteFeature.this).getFileid(file, (ListProgressListener)new DisabledListProgressListener());
                            request = new HttpPatch(String.format("%s/upload/drive/v3/files/%s?supportsTeamDrives=true", new Object[]{base, fileid}));
                            if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                                request.setHeader("Content-Type", status.getMime());
                            }
                            request.setEntity((HttpEntity)entity);
                        } else {
                            request = new HttpPost(String.format(String.format("%%s/upload/drive/v3/files?uploadType=resumable&supportsTeamDrives=%s", new Object[]{PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable")}), new Object[]{base}));
                            request.setEntity((HttpEntity)new StringEntity("{\"name\": \"" + file.getName() + "\", \"parents\": [\"" + DriveWriteFeature.access$100(DriveWriteFeature.this).getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()) + "\"]}", ContentType.create((String)"application/json", (String)"UTF-8")));
                            if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                                request.addHeader("X-Upload-Content-Type", status.getMime());
                            }
                        }
                        request.addHeader("Content-Type", "application/json; charset=UTF-8");
                        client = DriveWriteFeature.access$000(DriveWriteFeature.this).getHttpClient();
                        response = client.execute((HttpUriRequest)request);
                        try {
                            switch (response.getStatusLine().getStatusCode()) {
                                case 200: {
                                    ** break;
lbl21:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    throw new DriveExceptionMappingService().map((IOException)new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                                }
                            }
                        }
                        finally {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        if (!status.isExists()) {
                            if (response.containsHeader("Location")) {
                                putTarget = response.getFirstHeader("Location").getValue();
                                put = new HttpPut(putTarget);
                                put.setEntity((HttpEntity)entity);
                                putResponse = client.execute((HttpUriRequest)put);
                                try {
                                    switch (putResponse.getStatusLine().getStatusCode()) {
                                        case 200: 
                                        case 201: {
                                            ** break;
lbl38:
                                            // 1 sources

                                            break block21;
                                        }
                                        default: {
                                            throw new DriveExceptionMappingService().map((IOException)new HttpResponseException(putResponse.getStatusLine().getStatusCode(), putResponse.getStatusLine().getReasonPhrase()));
                                        }
                                    }
                                }
                                finally {
                                    EntityUtils.consume((HttpEntity)putResponse.getEntity());
                                }
                            }
                            throw new DriveExceptionMappingService().map((IOException)new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                        }
                    }
                    return null;
                }
                catch (IOException e) {
                    throw new DriveExceptionMappingService().map("Upload failed", e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }

    static /* synthetic */ DriveSession access$000(DriveWriteFeature x0) {
        return x0.session;
    }

    static /* synthetic */ DriveFileidProvider access$100(DriveWriteFeature x0) {
        return x0.fileid;
    }
}

