/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;

public class DriveTimestampFeature
extends DefaultTimestampFeature {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveTimestampFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void setTimestamp(Path file, Long modified) throws BackgroundException {
        try {
            String fileid = this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener());
            File properties = new File();
            properties.setModifiedTime(new DateTime(modified.longValue()));
            ((Drive)this.session.getClient()).files().update(fileid, properties).setFields("modifiedTime").setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

