/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UseragentProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveAttributesFinderFeature;
import ch.cyberduck.core.googledrive.DriveBatchDeleteFeature;
import ch.cyberduck.core.googledrive.DriveCopyFeature;
import ch.cyberduck.core.googledrive.DriveDirectoryFeature;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveFindFeature;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveListService;
import ch.cyberduck.core.googledrive.DriveMetadataFeature;
import ch.cyberduck.core.googledrive.DriveMoveFeature;
import ch.cyberduck.core.googledrive.DriveQuotaFeature;
import ch.cyberduck.core.googledrive.DriveReadFeature;
import ch.cyberduck.core.googledrive.DriveSearchFeature;
import ch.cyberduck.core.googledrive.DriveTimestampFeature;
import ch.cyberduck.core.googledrive.DriveTouchFeature;
import ch.cyberduck.core.googledrive.DriveUploadFeature;
import ch.cyberduck.core.googledrive.DriveUrlProvider;
import ch.cyberduck.core.googledrive.DriveWriteFeature;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;

public class DriveSession
extends HttpSession<Drive> {
    private ApacheHttpTransport transport;
    private final JsonFactory json = new GsonFactory();
    private final UseragentProvider useragent = new PreferencesUseragentProvider();
    private OAuth2RequestInterceptor authorizationService;
    private final DriveFileidProvider fileid = new DriveFileidProvider(this);

    public DriveSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    protected Drive connect(Proxy proxy, HostKeyCallback callback, LoginCallback prompt) {
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).build(), this.host.getProtocol()).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.authorizationService));
        this.transport = new ApacheHttpTransport((HttpClient)configuration.build());
        return new Drive.Builder((HttpTransport)this.transport, this.json, new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                request.setSuppressUserAgentSuffix(true);
            }
        }).setApplicationName(this.useragent.get()).build();
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, keychain, prompt, cancel));
    }

    protected void logout() throws BackgroundException {
        this.transport.shutdown();
    }

    public HttpClient getHttpClient() {
        return this.transport.getHttpClient();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new DriveListService(this, this.fileid);
        }
        if (type == Read.class) {
            return (T)new DriveReadFeature(this, this.fileid);
        }
        if (type == Write.class) {
            return (T)((Object)new DriveWriteFeature(this, this.fileid));
        }
        if (type == Upload.class) {
            return (T)((Object)new DriveUploadFeature(new DriveWriteFeature(this, this.fileid)));
        }
        if (type == Directory.class) {
            return (T)new DriveDirectoryFeature(this, this.fileid);
        }
        if (type == Delete.class) {
            return (T)new DriveBatchDeleteFeature(this, this.fileid);
        }
        if (type == Move.class) {
            return (T)new DriveMoveFeature(this, this.fileid);
        }
        if (type == Copy.class) {
            return (T)new DriveCopyFeature(this, this.fileid);
        }
        if (type == Touch.class) {
            return (T)new DriveTouchFeature(this, this.fileid);
        }
        if (type == UrlProvider.class) {
            return (T)new DriveUrlProvider();
        }
        if (type == Home.class) {
            return (T)((Object)new DriveHomeFinderService(this));
        }
        if (type == IdProvider.class) {
            return (T)this.fileid;
        }
        if (type == Quota.class) {
            return (T)new DriveQuotaFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new DriveTimestampFeature(this, this.fileid));
        }
        if (type == Metadata.class) {
            return (T)new DriveMetadataFeature(this, this.fileid);
        }
        if (type == Search.class) {
            return (T)new DriveSearchFeature(this);
        }
        if (type == Find.class) {
            return (T)new DriveFindFeature(this, this.fileid);
        }
        if (type == AttributesFinder.class) {
            return (T)new DriveAttributesFinderFeature(this, this.fileid);
        }
        return (T)super._getFeature(type);
    }
}

