/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;

public class DriveFindFeature
implements Find {
    private final DriveFileidProvider fileid;
    private Cache<Path> cache = PathCache.empty();

    public DriveFindFeature(DriveSession session, DriveFileidProvider fileid) {
        this.fileid = fileid;
    }

    public boolean find(Path file) throws BackgroundException {
        try {
            this.fileid.withCache((Cache)this.cache).getFileid(file, (ListProgressListener)new DisabledListProgressListener());
            return true;
        }
        catch (NotfoundException e) {
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

