/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.apache.http.client.HttpResponseException;

public class DriveExceptionMappingService
extends DefaultIOExceptionMappingService {
    public BackgroundException map(IOException failure) {
        StringBuilder buffer = new StringBuilder();
        if (failure instanceof GoogleJsonResponseException) {
            GoogleJsonResponseException error = (GoogleJsonResponseException)failure;
            this.append(buffer, error.getDetails().getMessage());
            switch (error.getDetails().getCode()) {
                case 403: {
                    List errors = error.getDetails().getErrors();
                    for (GoogleJsonError.ErrorInfo info : errors) {
                        if (!"usageLimits".equals(info.getDomain())) continue;
                        return new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(5L), (Throwable)failure);
                    }
                    break;
                }
            }
        }
        if (failure instanceof com.google.api.client.http.HttpResponseException) {
            com.google.api.client.http.HttpResponseException response = (com.google.api.client.http.HttpResponseException)failure;
            this.append(buffer, response.getStatusMessage());
            return new HttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusCode(), buffer.toString()));
        }
        return super.map(failure);
    }
}

