/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveItemIterator
implements Iterator<OneDriveItem.Metadata> {
    private final OneDriveAPI api;
    private final JsonObjectIterator jsonObjectIterator;

    public OneDriveItemIterator(OneDriveAPI api, URL url) {
        this.api = Objects.requireNonNull(api);
        this.jsonObjectIterator = new JsonObjectIterator(api, url){

            @Override
            protected void onResponse(JsonObject response) {
                OneDriveItemIterator.this.onResponse(response);
            }
        };
    }

    @Override
    public boolean hasNext() throws OneDriveRuntimeException {
        return this.jsonObjectIterator.hasNext();
    }

    @Override
    public OneDriveItem.Metadata next() throws OneDriveRuntimeException {
        OneDriveItem.Metadata nextMetadata;
        JsonObject nextObject = this.jsonObjectIterator.next();
        String id = nextObject.get("id").asString();
        if (nextObject.get("folder") != null && !nextObject.get("folder").isNull()) {
            OneDriveFolder folder;
            OneDriveFolder oneDriveFolder = folder = new OneDriveFolder(this.api, id);
            oneDriveFolder.getClass();
            nextMetadata = new OneDriveFolder.Metadata(oneDriveFolder, nextObject);
        } else if (nextObject.get("file") != null && !nextObject.get("file").isNull()) {
            OneDriveFile file;
            OneDriveFile oneDriveFile = file = new OneDriveFile(this.api, id);
            oneDriveFile.getClass();
            nextMetadata = oneDriveFile.new OneDriveFile.Metadata(nextObject);
        } else if (nextObject.get("package") != null && !nextObject.get("package").isNull()) {
            OneDrivePackageItem packageItem;
            OneDrivePackageItem oneDrivePackageItem = packageItem = new OneDrivePackageItem(this.api, id);
            oneDrivePackageItem.getClass();
            nextMetadata = new OneDrivePackageItem.Metadata(oneDrivePackageItem, nextObject);
        } else {
            throw new OneDriveRuntimeException(new OneDriveAPIException("The object type is currently not handled"));
        }
        return nextMetadata;
    }

    protected void onResponse(JsonObject response) {
    }
}

