/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.crypto;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class NssBridgeKeyConverter
extends JcaPEMKeyConverter {
    public NssBridgeKeyConverter() {
        Provider[] providers = Security.getProviders();
        try {
            if (providers == null || providers.length == 0) {
                System.err.println("Unable to configure ECDSA, no security providers present");
            } else if (providers[0].getName().equals("SunPKCS11-NSS")) {
                Field fieldDefinition = JcaPEMKeyConverter.class.getDeclaredField("algorithms");
                fieldDefinition.setAccessible(true);
                Object fieldValue = fieldDefinition.get(null);
                Method put = fieldValue.getClass().getDeclaredMethod("put", Object.class, Object.class);
                put.invoke(fieldValue, X9ObjectIdentifiers.id_ecPublicKey, "EC");
            }
        }
        catch (ReflectiveOperationException e) {
            System.err.println("SunPKCS11-NSS is preferred security provider, but failed to enable for ECDSA via reflection");
            e.printStackTrace();
        }
    }
}

