/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.io.RepeatableFileInputStream;
import org.jets3t.service.model.BaseStorageItem;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.utils.Mimetypes;
import org.jets3t.service.utils.ServiceUtils;

public class StorageObject
extends BaseStorageItem
implements Cloneable {
    private static final Log log = LogFactory.getLog(StorageObject.class);
    public static final String METADATA_HEADER_HASH_MD5 = "md5-hash";
    public static final String METADATA_HEADER_ORIGINAL_HASH_MD5 = "original-md5-hash";
    public static final String METADATA_HEADER_SERVER_SIDE_ENCRYPTION = "server-side-encryption";
    public static final String METADATA_HEADER_SERVER_SIDE_ENCRYPTION_KMS_KEY_ID = "server-side-encryption-aws-kms-key-id";
    protected AccessControlList acl = null;
    protected transient InputStream dataInputStream = null;
    protected boolean isMetadataComplete = false;
    protected String bucketName = null;
    protected String storageClass = null;
    protected String serverSideEncryptionAlgorithm = null;
    protected String serverSideEncryptionKmsKeyId = null;
    protected File dataInputFile = null;

    public StorageObject(File file) throws NoSuchAlgorithmException, IOException {
        this(file.getName());
        this.setContentLength(file.length());
        this.setContentType(Mimetypes.getInstance().getMimetype(file));
        if (!file.exists()) {
            throw new FileNotFoundException("Cannot read from file: " + file.getAbsolutePath());
        }
        this.setDataInputFile(file);
        this.setMd5Hash(ServiceUtils.computeMD5Hash(new FileInputStream(file)));
    }

    public StorageObject(String key, String dataString) throws NoSuchAlgorithmException, IOException {
        this(key);
        ByteArrayInputStream bais = new ByteArrayInputStream(dataString.getBytes(Constants.DEFAULT_ENCODING));
        this.setDataInputStream(bais);
        this.setContentLength(bais.available());
        this.setContentType("text/plain; charset=utf-8");
        this.setMd5Hash(ServiceUtils.computeMD5Hash(dataString.getBytes(Constants.DEFAULT_ENCODING)));
    }

    public StorageObject(String key, byte[] data) throws NoSuchAlgorithmException, IOException {
        this(key);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        this.setDataInputStream(bais);
        this.setContentLength(bais.available());
        this.setContentType("application/octet-stream");
        this.setMd5Hash(ServiceUtils.computeMD5Hash(data));
    }

    public StorageObject(String key) {
        super(key);
    }

    public Object clone() {
        StorageObject clone = new StorageObject(this.getKey());
        clone.dataInputStream = this.dataInputStream;
        clone.acl = this.acl;
        clone.isMetadataComplete = this.isMetadataComplete;
        clone.dataInputFile = this.dataInputFile;
        clone.setOwner(this.getOwner());
        clone.addAllMetadata(this.getMetadataMap());
        return clone;
    }

    public String toString() {
        return "StorageObject [key=" + this.getKey() + ", lastModified=" + this.getLastModifiedDate() + ", dataInputStream=" + this.dataInputStream + ", Metadata=" + this.getMetadataMap() + "]";
    }

    public StorageObject() {
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public InputStream getDataInputStream() throws ServiceException {
        if (this.dataInputStream == null && this.dataInputFile != null) {
            try {
                this.dataInputStream = new RepeatableFileInputStream(this.dataInputFile);
            }
            catch (FileNotFoundException e) {
                throw new ServiceException("Cannot open file input stream", e);
            }
        }
        return this.dataInputStream;
    }

    public void setDataInputStream(InputStream dataInputStream) {
        this.dataInputFile = null;
        this.dataInputStream = dataInputStream;
    }

    public void setDataInputFile(File dataInputFile) {
        this.dataInputStream = null;
        this.dataInputFile = dataInputFile;
    }

    public File getDataInputFile() {
        return this.dataInputFile;
    }

    public void closeDataInputStream() throws IOException {
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
    }

    public String getETag() {
        String etag = (String)this.getMetadata("ETag");
        if (etag != null && etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    public void setETag(String etag) {
        this.addMetadata("ETag", etag);
    }

    public String getMd5HashAsHex() {
        return (String)this.getMetadata(METADATA_HEADER_HASH_MD5);
    }

    public String getMd5HashAsBase64() {
        String md5HashBase64 = (String)this.getMetadata("Content-MD5");
        if (md5HashBase64 == null) {
            String eTag = this.getETag();
            if (eTag != null && ServiceUtils.isEtagAlsoAnMD5Hash(eTag)) {
                return ServiceUtils.toBase64(ServiceUtils.fromHex(eTag));
            }
            if (this.getMd5HashAsHex() != null) {
                return ServiceUtils.toBase64(ServiceUtils.fromHex(this.getMd5HashAsHex()));
            }
        }
        return md5HashBase64;
    }

    public void setMd5Hash(byte[] md5Hash) {
        this.addMetadata(METADATA_HEADER_HASH_MD5, ServiceUtils.toHex(md5Hash));
        this.addMetadata("Content-MD5", ServiceUtils.toBase64(md5Hash));
    }

    public Date getLastModifiedDate() {
        Date lastModifiedDate = (Date)this.getMetadata("Last-Modified");
        if (lastModifiedDate == null) {
            lastModifiedDate = (Date)this.getMetadata("Date");
        }
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.addMetadata("Last-Modified", lastModifiedDate);
    }

    public long getContentLength() {
        Object contentLength = this.getMetadata("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return Long.parseLong(contentLength.toString());
    }

    public void setContentLength(long size) {
        this.addMetadata("Content-Length", String.valueOf(size));
    }

    public String getContentType() {
        return (String)this.getMetadata("Content-Type");
    }

    public void setContentType(String contentType) {
        this.addMetadata("Content-Type", contentType);
    }

    public String getContentLanguage() {
        return (String)this.getMetadata("Content-Language");
    }

    public void setContentLanguage(String contentLanguage) {
        this.addMetadata("Content-Language", contentLanguage);
    }

    public String getContentDisposition() {
        return (String)this.getMetadata("Content-Disposition");
    }

    public void setContentDisposition(String contentDisposition) {
        this.addMetadata("Content-Disposition", contentDisposition);
    }

    public String getContentEncoding() {
        return (String)this.getMetadata("Content-Encoding");
    }

    public void setContentEncoding(String contentEncoding) {
        this.addMetadata("Content-Encoding", contentEncoding);
    }

    public String getKey() {
        return super.getName();
    }

    public void setKey(String key) {
        super.setName(key);
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getServerSideEncryptionAlgorithm() {
        if (this.serverSideEncryptionAlgorithm != null) {
            return this.serverSideEncryptionAlgorithm;
        }
        return (String)this.getMetadata(METADATA_HEADER_SERVER_SIDE_ENCRYPTION);
    }

    public void setServerSideEncryptionAlgorithm(String serverSideEncryptionAlgorithm) {
        this.serverSideEncryptionAlgorithm = serverSideEncryptionAlgorithm;
    }

    public String getServerSideEncryptionKmsKeyId() {
        if (this.serverSideEncryptionKmsKeyId != null) {
            return this.serverSideEncryptionKmsKeyId;
        }
        return (String)this.getMetadata(METADATA_HEADER_SERVER_SIDE_ENCRYPTION_KMS_KEY_ID);
    }

    public void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
        this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
    }

    public boolean isMetadataComplete() {
        return this.isMetadataComplete;
    }

    public void setMetadataComplete(boolean isMetadataComplete) {
        this.isMetadataComplete = isMetadataComplete;
    }

    @Override
    public void addMetadata(String name, String value) {
        block3: {
            if ("Last-Modified".equals(name) || "Date".equals(name)) {
                try {
                    Date parsedDate = null;
                    parsedDate = value.toString().indexOf("-") >= 0 ? ServiceUtils.parseIso8601Date(value) : ServiceUtils.parseRfc822Date(value);
                    super.addMetadata(name, parsedDate);
                    return;
                }
                catch (ParseException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Unable to parse value we expect to be a valid date: " + name + "=" + value), (Throwable)e);
                }
            }
        }
        super.addMetadata(name, value);
    }

    @Override
    public void addAllMetadata(Map<String, Object> metadata) {
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                this.addMetadata(entry.getKey().toString(), (String)value);
                continue;
            }
            if (value instanceof Date) {
                this.addMetadata(entry.getKey().toString(), (Date)value);
                continue;
            }
            if (value instanceof S3Owner) {
                this.addMetadata(entry.getKey().toString(), (S3Owner)value);
                continue;
            }
            this.addMetadata(entry.getKey().toString(), value);
        }
    }

    public Map<String, Object> getModifiableMetadata() {
        HashMap<String, Object> objectMetadata = new HashMap<String, Object>(this.getMetadataMap());
        objectMetadata.remove("Content-Length");
        objectMetadata.remove("Date");
        objectMetadata.remove("ETag");
        objectMetadata.remove("Last-Modified");
        objectMetadata.remove("__complete__");
        objectMetadata.remove("__service__");
        objectMetadata.remove("__user__");
        objectMetadata.remove("__http__");
        objectMetadata.remove("id-2");
        objectMetadata.remove("request-id");
        return objectMetadata;
    }

    public boolean isDirectoryPlaceholder() {
        if (this.getKey().endsWith("/") && this.getContentLength() == 0L) {
            return true;
        }
        if ("d66759af42f282e1ba19144df2d405d0".equals(this.getETag())) {
            return true;
        }
        if (this.getKey().endsWith("_$folder$") && this.getContentLength() == 0L) {
            return true;
        }
        return this.getContentLength() == 0L && "application/x-directory".equals(this.getContentType());
    }

    public boolean verifyData(File downloadedFile) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        String md5HashB64 = this.getMd5HashAsBase64();
        if (md5HashB64 == null) {
            throw new IllegalStateException("Cannot verify data for this object because the service-provided MD5 hash value is unavailable");
        }
        return md5HashB64.equals(ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(downloadedFile))));
    }

    public boolean verifyData(byte[] downloadedData) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        return this.getMd5HashAsBase64().equals(ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(downloadedData)));
    }

    public boolean verifyData(InputStream downloadedDataStream) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        return this.getMd5HashAsBase64().equals(ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(downloadedDataStream)));
    }
}

