/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.networking;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.spectralogic.ds3client.models.Error;
import java.io.IOException;
import java.util.List;

public class FailedRequestException
extends IOException {
    private static final long serialVersionUID = -2070737734216316074L;
    private final int statusCode;
    private final ImmutableList<Integer> expectedStatusCodes;
    private final Error error;
    private final String responseString;

    public FailedRequestException(ImmutableList<Integer> expectedStatusCodes, int statusCode, Error error, String responseString) {
        super(FailedRequestException.buildExceptionMessage(error, expectedStatusCodes, statusCode));
        this.statusCode = statusCode;
        this.expectedStatusCodes = expectedStatusCodes;
        this.error = error;
        this.responseString = responseString;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public List<Integer> getExpectedStatusCodes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        UnmodifiableIterator unmodifiableIterator = this.expectedStatusCodes.iterator();
        while (unmodifiableIterator.hasNext()) {
            int status = (Integer)unmodifiableIterator.next();
            builder.add((Object)status);
        }
        return builder.build();
    }

    public Error getError() {
        return this.error;
    }

    public String getResponseString() {
        return this.responseString;
    }

    private static String buildExceptionMessage(Error error, ImmutableList<Integer> expectedStatusCodes, int statusCode) {
        Joiner joiner = Joiner.on((String)", ");
        return error == null ? String.format("Expected a status code of %s but got %d. Could not parse the response for additional information.", joiner.join(expectedStatusCodes), statusCode) : String.format("Expected a status code of %s but got %d. Error message: \"%s\"", joiner.join(expectedStatusCodes), statusCode, error.getMessage());
    }

    @Override
    public String toString() {
        if (this.error == null) {
            return this.responseString;
        }
        return this.error.toString();
    }
}

